/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flow;

import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.ExternalCommand;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.flow.FlowManager;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowGlobalFunction {
    public static String getCalendarsFileFullPath() {
        List calendarsFiles = SettingsBooleanKeys.isXmlCalendarFileEnabled() ? GlobalFunctions.getCalendarsFileName() : GlobalFunctions.getJsonCalendarFileNames();
        return calendarsFiles.stream().findFirst().map(calendarRelativeName -> ConversionEntitiesService.getCurrentConversionDirectory() + calendarRelativeName).filter(GlobalFunctions::isFileExist).orElse("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadToEM(String emPath, boolean loadCalendars, String user, String password, String server, String port) {
        boolean runLoadToEm = true;
        String draftFilePath = ConversionEntitiesService.getCurrentConversionDirectory();
        String calendarsFile = draftFilePath + GlobalFunctions.getCalendarsFileName().stream().findFirst().orElse("");
        if (loadCalendars) {
            String loadCalCmd = "\"" + emPath + "\\bin\\emdef\" defcal -u " + user + " -p " + password + " -s " + server + " -src \"" + calendarsFile + "\"";
            try {
                if (!(user == null || user.isEmpty() || password == null || password.isEmpty() || server == null || server.isEmpty())) {
                    ExternalCommand extCmd = new ExternalCommand.Builder(new String[]{loadCalCmd}).isScript(true).waitFor(true).build();
                    FlowManager.instance().setBusyWait(true);
                    extCmd.startThrows();
                    if (extCmd.getOutputStdOut().contains("Error:") || extCmd.getExitValue() != 0) {
                        runLoadToEm = BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("LOAD_EM_PANEL_DIALOG_LOADING_CALENDARS_TITLE"), (String)TextManager.instance().get("LOAD_EM_PANEL_DIALOG_LOADING_CALENDARS_FAILED"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)extCmd.getOutputStdOut());
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    int errorCnt = 0;
                    if (user == null || user.isEmpty()) {
                        ++errorCnt;
                        stringBuilder.append("    \u2022  ").append(TextManager.instance().get("FIELD_LOAD_USER_NAME")).append(" ").append("\n");
                    }
                    if (password == null || password.isEmpty()) {
                        ++errorCnt;
                        stringBuilder.append("    \u2022  ").append(TextManager.instance().get("FIELD_LOAD_PASSWORD")).append(" ").append("\n");
                    }
                    if (server == null || server.isEmpty()) {
                        ++errorCnt;
                        stringBuilder.append("    \u2022  ").append(TextManager.instance().get("FIELD_LOAD_MACHINE_NAME")).append("\n");
                    }
                    runLoadToEm = BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("LOAD_EM_PANEL_DIALOG_LOADING_CALENDARS_TITLE"), (String)TextManager.instance().get("LOAD_EM_PANEL_DIALOG_LOADING_CALENDARS_FAILED"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)((errorCnt > 1 ? TextManager.instance().get("LOAD_EM_PANEL_DIALOG_MISSING_PARAMETERS") : TextManager.instance().get("LOAD_EM_PANEL_DIALOG_MISSING_PARAMETER")) + ": \n" + String.valueOf(stringBuilder)));
                }
            }
            catch (IOException | InterruptedException e) {
                BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("LOAD_EM_LOADING_TO_CTM_DIALOG_TITLE"), (String)TextManager.instance().get("LOAD_EM_LOADING_TO_CTM_DIALOG_LOADING_CALEDARS_FAILED"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE);
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            finally {
                FlowManager.instance().setBusyWait(false);
            }
        }
        if (runLoadToEm) {
            String zosServers;
            String emGUIName = "emdesktop";
            Object emCredentials = "";
            Object emNS = " -s " + server;
            String emFile = " -file ";
            String string = zosServers = Params.instance().isZOS() ? " -zos_servers " + Params.instance().getMFDatacenterName() : "";
            if (!Params.instance().getGUIVersion().equals("7")) {
                emGUIName = "emwa";
                emNS = (String)emNS + FlowGlobalFunction.getNSStr(emPath);
                emFile = " ";
                zosServers = "";
            }
            emNS = String.format(" -webhost %s -webport %s", server, port);
            if (!user.isEmpty()) {
                emCredentials = (String)emCredentials + " -u " + user;
            }
            if (!password.isEmpty()) {
                emCredentials = (String)emCredentials + " -p " + password;
            }
            String emCmd = "START \"ConversionLoadToControl-M\" \"" + emPath + "\\bin\\" + emGUIName + "\" " + (String)emCredentials + (String)emNS + zosServers + emFile + FlowGlobalFunction.getDraftsStr(draftFilePath);
            ExternalCommand extCmd = new ExternalCommand.Builder(new String[]{emCmd}).isScript(true).waitFor(false).build();
            try {
                extCmd.startThrows();
            }
            catch (IOException e) {
                BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("LOAD_EM_LOADING_TO_CTM_DIALOG_TITLE"), (String)TextManager.instance().get("LOAD_EM_LOADING_TO_CTM_DIALOG_STARTING_CTM_FAILED"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE);
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            catch (InterruptedException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return runLoadToEm;
    }

    private static String getNSStr(String emPath) {
        File confic = new File(emPath + "etc\\domains\\config.xml");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(confic);
            doc.getDocumentElement().normalize();
            NodeList variables = doc.getDocumentElement().getElementsByTagName("variable");
            for (int index = 0; index < variables.getLength(); ++index) {
                Node variable = variables.item(index);
                if (!variable.getAttributes().getNamedItem("name").getNodeValue().equals("-ORBInitRef")) continue;
                String NSValue = variable.getAttributes().getNamedItem("value").getNodeValue();
                Pattern pattern = Pattern.compile("NameService=.*?@(.*):(\\d+)/NameService");
                Matcher matcher = pattern.matcher(NSValue);
                if (!matcher.matches()) continue;
                return " -nshost " + matcher.group(1) + " -nsport " + matcher.group(2);
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return "";
    }

    private static String getDraftsStr(String path) {
        File[] files;
        StringBuilder draftsStr = new StringBuilder();
        File draftsFolder = new File(path);
        if (draftsFolder.isDirectory() && (files = draftsFolder.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().startsWith("draft")) continue;
                draftsStr.append("\"").append(file.getAbsolutePath()).append("\" ");
            }
        }
        return draftsStr.toString();
    }
}

