/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flow;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseFrame;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.report.FullReportPanel;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.awt.Component;

public class ConversionReportManager
implements NavegationListener {
    private static ConversionReportManager instance;
    private BaseFrame mainFrame = new BaseFrame();
    private FullReportPanel report;

    public static ConversionReportManager instance() {
        if (instance == null) {
            instance = new ConversionReportManager();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private ConversionReportManager() {
        this.mainFrame.addNavegationListener((NavegationListener)this);
    }

    public FullReportPanel getConversionReport() {
        return new FullReportPanel(ConversionEntitiesService.getCurrentConversionDirectory(), FullReportPanel.REPORT_TYPE_EMBEDDED);
    }

    public void viewConversionReport() {
        this.report = null;
        final BaseProgressBar progressBar = new BaseProgressBar(TextManager.instance().get("TITLE_CONVERSION_REPORT"));
        progressBar.setLabel(TextManager.instance().get("LOADING_CONVERSION_REPORT"));
        progressBar.setSnakeLook(true);
        Thread loadConversionReport = new Thread(){

            @Override
            public void run() {
                ConversionReportManager.this.report = new FullReportPanel(ConversionEntitiesService.getCurrentConversionDirectory(), FullReportPanel.REPORT_TYPE_CONVERSION);
                ConversionReportManager.this.report.addNavegationListener(instance);
                ConversionReportManager.this.mainFrame.setContent((BaseComponent)ConversionReportManager.this.report);
                ConversionReportManager.this.mainFrame.setJMenuBar(ConversionReportManager.this.report.getJMenuBar());
                ConversionReportManager.this.mainFrame.setVisible(true);
                progressBar.dispose();
            }
        };
        loadConversionReport.start();
        progressBar.setVisible(true);
        if (progressBar.isCancelled()) {
            loadConversionReport.stop();
        }
    }

    public Component getMainFrame() {
        return this.mainFrame.getComponent();
    }

    public void navegationActionPerformed(ConversionEvent e) {
        if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            this.closeOperation();
        } else if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"))) {
            this.report.navegationActionPerformed(e);
        }
    }

    public void setTitle(String title) {
        this.mainFrame.setTitle(title);
    }

    public void closeOperation() {
        this.mainFrame.dispose();
    }
}

