/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.dataimport;

import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImporterType;
import com.bmc.ctmconvert.progress.ProgressEvent;
import com.bmc.ctmconvert.progress.ProgressListener;
import com.bmc.ctmconvert.progress.Progressable;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProgressEntry
extends Progressable
implements ProgressListener {
    private JPanel panel;
    private ImportEntry entry;
    private JLabel titleLabel;
    private JLabel descriptionLabel;
    private JLabel progressStepLabel;
    private JLabel progressLabel;
    private int maxProgress = 0;
    private int currentProgress = 0;
    private static final String progressFormatDB = "%d/%d %s";
    private static final String progressFormatFile = "%d/%d %s";
    private String progressFormat = "";
    private String progressUnit = "";
    private Icon titleIcon;

    public void run() {
    }

    public ProgressEntry(ImportEntry entry) {
        this.entry = entry;
        if (entry.getType().equals((Object)ImporterType.DBTable)) {
            this.titleIcon = FlowGlobals.IMPORT_DB_TABLE_ICON;
            this.progressFormat = "%d/%d %s";
            this.progressUnit = "Rows";
        } else {
            this.titleIcon = FlowGlobals.IMPORT_FILE_ICON;
            this.progressFormat = "%d/%d %s";
            this.progressUnit = "Bytes";
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(FlowGlobals.FONT_STYLE_BOLD);
        this.titleLabel.setForeground(FlowGlobals.ConversionBlue);
        this.titleLabel.setText(entry.getTitle());
        this.titleLabel.setIcon(this.titleIcon);
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        this.panel.add(titlePanel);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new BoxLayout(descriptionPanel, 0));
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setFont(FlowGlobals.FONT_STYLE_ITALIC);
        this.descriptionLabel.setText(entry.getCommmand());
        descriptionPanel.add(Box.createRigidArea(new Dimension(30, 0)));
        descriptionPanel.add(this.descriptionLabel);
        descriptionPanel.add(Box.createHorizontalGlue());
        this.panel.add(descriptionPanel);
        this.panel.add(Box.createRigidArea(new Dimension(0, 7)));
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout(new BoxLayout(progressPanel, 0));
        this.progressStepLabel = new JLabel();
        progressPanel.add(this.progressStepLabel);
        this.progressLabel = new JLabel();
        this.setProgressLabel();
        progressPanel.add(Box.createHorizontalGlue());
        progressPanel.add(this.progressLabel);
        this.panel.add(progressPanel);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getID() {
        return this.entry.getID();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void setDescription(String description) {
        this.descriptionLabel.setText(description);
    }

    public void setCurrentProgress(String currentProgress) {
        this.currentProgress = Integer.valueOf(currentProgress);
        this.setProgressLabel();
    }

    public void setMaxProgress(String maxProgress) {
        this.maxProgress = Integer.valueOf(maxProgress);
        this.setProgressLabel();
    }

    public void setProgressUnit(String progressUnit) {
        this.progressUnit = progressUnit;
        this.setProgressLabel();
    }

    public void setProgressStepLabel(String state) {
        this.progressStepLabel.setText(state);
    }

    private void setProgressLabel() {
        this.progressLabel.setText(String.format(this.progressFormat, this.currentProgress, this.maxProgress, this.progressUnit));
    }

    public void updateProgress(ProgressEvent evt) {
        if (this.entry.getID().equals(evt.getID())) {
            switch (evt.getType()) {
                case PROGRESS: {
                    this.setCurrentProgress(evt.getValue());
                    break;
                }
                case PROGRESS_MAX: {
                    this.setMaxProgress(evt.getValue());
                    break;
                }
                case PROGRESS_STATUS: {
                    break;
                }
                case PROGRESS_STEP: {
                    this.setProgressStepLabel(evt.getValue());
                    break;
                }
                case PROGRESS_UNIT: {
                    this.setProgressUnit(evt.getValue());
                    break;
                }
            }
            this.fireProgressEvent(evt);
        }
    }
}

