/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.dataimport;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTabbedPane;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.dataImport.EntriesContentPanel;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.dataimport.DefaultImporter;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.autofiledetect.DataForImportDetector;
import com.bmc.ctmconvert.progress.ProgressEvent;
import com.bmc.ctmconvert.progress.ProgressListener;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DefaultDataImport
extends DataImportVendor {
    protected BaseContentPanel importDefaultPanel;
    protected ImportEntryList entries;
    protected boolean automatic = true;
    private DefaultImporter importer;
    private Importer vendorImporter;
    private DataForImportDetector vendorDataForImportDetector;
    private static final String AutomaticTitle = "Automatic";
    private static final String ManualTitle = "Manual";
    private int totalMaxProgress = 0;
    private long totalCurrentProgress = 0L;
    private Map<String, Integer> currntValues;

    public abstract List<BaseField> getAutomaticFields();

    protected DefaultDataImport(ImportEntryList entries) {
        this.entries = entries;
        this.vendorImporter = VendorDataManager.instance().getVendorData(Params.instance().getVendorName()).getVendorImporter();
        this.vendorDataForImportDetector = VendorDataManager.instance().getVendorData(Params.instance().getVendorName()).getDataForImportDetector();
    }

    public String getHelpTitle() {
        return VendorDataManager.instance().getVendorData(Params.instance().getVendorName()).getHelpTitle(this.automatic);
    }

    public String getFieldsData() {
        return "";
    }

    public BaseContentPanel getNextPanel() {
        if (this.importDefaultPanel == null) {
            final BaseTabbedPane tabs = new BaseTabbedPane();
            final BaseContentPanel automaticContent = this.getAutomaticTab(this.getAutomaticFields());
            final BaseContentPanel manualContent = this.getManualTab();
            this.importDefaultPanel = new BaseContentPanel(new BaseTitlePanel(""));
            final ValidityListener validityListener = new ValidityListener(){

                public void validityActionPerformed(ConversionEvent e) {
                    boolean valid = false;
                    if (automaticContent == null || tabs.getTitleAt(tabs.getSelectedIndex()).equals(DefaultDataImport.ManualTitle)) {
                        DefaultDataImport.this.automatic = false;
                    } else if (tabs.getTitleAt(tabs.getSelectedIndex()).equals(DefaultDataImport.AutomaticTitle)) {
                        DefaultDataImport.this.automatic = true;
                    }
                    valid = DefaultDataImport.this.automatic ? automaticContent.isValid() : manualContent.isValid();
                    DefaultDataImport.this.importDefaultPanel.setValid(valid);
                }
            };
            tabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    validityListener.validityActionPerformed(new ConversionEvent("", true));
                }
            });
            if (automaticContent != null) {
                tabs.addTab(AutomaticTitle, automaticContent.getComponent());
                automaticContent.addValidityListener(validityListener);
                tabs.addTab(ManualTitle, manualContent.getComponent());
                manualContent.addValidityListener(validityListener);
                this.importDefaultPanel.setContentPanel((BaseComponent)tabs);
            } else {
                manualContent.addValidityListener(validityListener);
                this.importDefaultPanel.setContentPanel((BaseComponent)manualContent);
                this.importDefaultPanel.setValid(manualContent.isValid());
            }
        }
        return this.importDefaultPanel;
    }

    private BaseContentPanel getAutomaticTab(List<BaseField> fields) {
        BaseContentPanel tab = null;
        if (fields != null && !fields.isEmpty()) {
            ArrayList<BaseButton> componentList = new ArrayList<BaseButton>();
            BaseButton button = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.TEST, (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultDataImport.this.testImport();
                }
            });
            button.setEnabled(false);
            componentList.add(button);
            tab = new BaseContentPanel(new BaseFooterPanel("", componentList));
            tab.setBorder(null);
            BaseSection section = new BaseSection("");
            for (final BaseField field : fields) {
                field.setData((Object)this.entries.getImportDetails().getProperty(field.getID()));
                field.getBaseComponent().setValidityLook(true);
                field.getBaseComponent().addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        DefaultDataImport.this.entries.getImportDetails().setProperty(field.getID(), (String)field.getData());
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                    }
                });
                section.addField(field);
            }
            section.addValidityListener(e -> button.setEnabled(e.getValue()));
            tab.addSection(section);
            tab.buildContentPanel();
            section.setValid(section.isValid());
        }
        return tab;
    }

    private BaseContentPanel getManualTab() {
        EntriesContentPanel tab = new EntriesContentPanel(this.entries, this.vendorDataForImportDetector);
        return tab;
    }

    public Component getDefaultFocusedComponent() {
        return this.getAutomaticFields().get(0).getBaseComponent().getComponent();
    }

    public boolean isImportable() {
        ProcessAlertsManager.instance().init();
        this.importer = new DefaultImporter(this.automatic, this.entries, this.vendorImporter);
        boolean isImportable = this.importer.isImportable();
        if (!isImportable) {
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("DATA_IMPORT_AUTOMATIC_TEST_TITLE"), (String)TextManager.instance().get("DATA_IMPORT_AUTOMATIC_TEST_MSG_FAILURE"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)ProcessAlertsManager.instance().getMessages(), (boolean)true);
        }
        return isImportable;
    }

    private void testImport() {
        ProcessAlertsManager.instance().init();
        this.importer = new DefaultImporter(this.automatic, this.entries, this.vendorImporter);
        boolean isImportable = this.importer.isImportable();
        if (isImportable) {
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("DATA_IMPORT_AUTOMATIC_TEST_TITLE"), (String)TextManager.instance().get("DATA_IMPORT_AUTOMATIC_TEST_MSG_SUCCESS"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.SUCCESS_MESSAGE, (String)ProcessAlertsManager.instance().getMessages(), (boolean)true);
        } else {
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("DATA_IMPORT_AUTOMATIC_TEST_TITLE"), (String)TextManager.instance().get("DATA_IMPORT_AUTOMATIC_TEST_MSG_FAILURE"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)ProcessAlertsManager.instance().getMessages(), (boolean)true);
        }
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        this.currntValues = new ConcurrentHashMap<String, Integer>();
        final BaseProgressBar progress = new BaseProgressBar(TextManager.instance().get("CAPTURE_DATA_IMPORT_ENDED_DIALOG_TITLE"), (Progressable)this.importer);
        this.importer.addProgressListener(new ProgressListener(){

            public void updateProgress(ProgressEvent evt) {
                if (evt.getID().equals(DefaultDataImport.this.importer.getID())) {
                    switch (evt.getStatus()) {
                        case ENDED_SUCCESS: 
                        case ENDED_STOPED: 
                        case ENDED_FAILURE: 
                        case ENDED_WITH_MESSAGE: {
                            progress.dispose();
                            break;
                        }
                    }
                    if (evt.getType() == ProgressEvent.ProgressType.PROGRESS_STEP) {
                        progress.setLabel(evt.getValue());
                    }
                } else {
                    switch (evt.getType()) {
                        case PROGRESS: {
                            DefaultDataImport.this.currntValues.put(evt.getID(), Integer.parseInt(evt.getValue()));
                            IntSummaryStatistics stats = DefaultDataImport.this.currntValues.values().stream().mapToInt(x -> x).summaryStatistics();
                            DefaultDataImport.this.totalCurrentProgress = stats.getSum();
                            progress.setProgressValue((int)DefaultDataImport.this.totalCurrentProgress);
                            break;
                        }
                        case PROGRESS_MAX: {
                            int tmpMax = Integer.parseInt(evt.getValue());
                            if (tmpMax > 0) {
                                DefaultDataImport.this.totalMaxProgress += tmpMax;
                            } else {
                                DefaultDataImport.this.currntValues = new HashMap<String, Integer>();
                                DefaultDataImport.this.totalMaxProgress = tmpMax;
                            }
                            progress.setProgressMax(DefaultDataImport.this.totalMaxProgress);
                            break;
                        }
                    }
                }
            }
        });
        new Thread((Runnable)this.importer).start();
        progress.setVisible(true);
        FlowGlobals.COMPLETION_MODE toRet = FlowGlobals.COMPLETION_MODE.SUCCESS;
        if (this.importer.getStatus() == Progressable.ProgressStatus.ENDED_FAILURE) {
            toRet = FlowGlobals.COMPLETION_MODE.FAILURE;
        } else if (this.importer.getStatus() == Progressable.ProgressStatus.ENDED_STOPED) {
            toRet = FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        return toRet;
    }
}

