/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.applications;

import com.bmc.applications.IApplicationExtractor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApplicationUtils {
    private static HashMap<String, String> applicationToPropertiesFile = new HashMap();
    private static HashMap<String, String> classesMap = new HashMap();
    private static String partyFolderPath = "./AppJars/3dparty";
    private static String jarFolderPath = "./AppJars";
    private static String errorInputMsg = "Invalid input parameter, please type 'Help' to more help";
    private static String helpMsg = "Parameters: \nGETAPPLIST [-o] \nGETDATA -t -c [-o, -f]\nGETPROPERTIES -t [-o]\nTEST -t -c [-o] \n\n-o  path of output file (if not set, the output will print to standard output)\n-f  path to filter properties file\n-c  path to connection profile properties file\n-t  application Type\n\n\nExamples: \nGETAPPLIST \nGETAPPLIST -o c:\\output\\outputDB1.txt\nGETDATA -t DB -c c:\\con\\myConn.prop\nGETDATA -t DB -c c:\\con\\myConn.prop -f c:\\con\\filter.prop -o c:\\output\\outputDB1.txt";
    private static String connectionProfilePath = null;
    private static String appType = null;
    private static String filterPath = null;
    private static String outputPath = null;
    static boolean _isFirstInit = true;

    public static void main(String[] args) {
        block17: {
            int length = args.length;
            if (length < 1 || !ApplicationUtils.parseArguments(args)) {
                System.out.println(errorInputMsg);
                return;
            }
            try {
                String action = args[0].toUpperCase();
                if (action.equals("GETAPPLIST")) {
                    HashMap<String, String> appDic = ApplicationUtils.getSupportedApplications();
                    String appsStr = ApplicationUtils.hashToXml(appDic);
                    if (length == 1) {
                        System.out.println(appsStr);
                    } else if (outputPath != null) {
                        boolean isSaved = ApplicationUtils.saveToFile(outputPath, appsStr);
                        if (isSaved) {
                            System.out.println("Successfully saved to file: " + outputPath);
                        } else {
                            System.out.println("Fail save to file: " + outputPath);
                        }
                    } else {
                        System.out.println("GETAPPLIST wrong input parameters, please type 'Help' to more help");
                    }
                    break block17;
                }
                if (action.equals("GETPROPERTIES")) {
                    ApplicationUtils.getSupportedApplications();
                    if (appType == null) {
                        System.out.println("Missed Application Type");
                        return;
                    }
                    String propStr = ApplicationUtils.getApplicationProperties(appType);
                    if (outputPath == null) {
                        System.out.println(propStr);
                        return;
                    }
                    ApplicationUtils.saveToFile(outputPath, propStr);
                    break block17;
                }
                if (action.equals("GETDATA")) {
                    if (appType == null) {
                        System.out.println("Missed Application Type");
                        return;
                    }
                    Properties connectionProperties = ApplicationUtils.initProperties(connectionProfilePath);
                    Properties filterProperties = ApplicationUtils.initProperties(filterPath);
                    IApplicationExtractor appExec = ApplicationUtils.getExtractor(appType);
                    String outXml = appExec.getData(connectionProperties, filterProperties, null);
                    if (outputPath == null) {
                        System.out.println(outXml);
                        return;
                    }
                    ApplicationUtils.saveToFile(outputPath, outXml);
                    break block17;
                }
                if (action.equals("HELP") || action.equals("?")) {
                    System.out.println(helpMsg);
                    return;
                }
                System.out.println(errorInputMsg);
                return;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                System.exit(1);
            }
        }
        System.exit(0);
    }

    private static String hashToXml(HashMap<String, String> appDic) {
        StringWriter sw = new StringWriter();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("Applications");
            doc.appendChild(rootElement);
            Set<String> appTypes = appDic.keySet();
            for (String appType : appTypes) {
                Element jobData = doc.createElement("Application");
                rootElement.appendChild(jobData);
                Attr attrFolder = doc.createAttribute("DISPLAY_NAME");
                attrFolder.setValue(appDic.get(appType));
                jobData.setAttributeNode(attrFolder);
                Attr attrJobName = doc.createAttribute("TYPE");
                attrJobName.setValue(appType);
                jobData.setAttributeNode(attrJobName);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String xmlString = sw.toString();
        return xmlString;
    }

    private static Properties initProperties(String path) throws IOException, FileNotFoundException {
        Properties connectionProperties = null;
        if (path != null) {
            connectionProperties = new Properties();
            connectionProperties.load(new FileInputStream(path));
        }
        return connectionProperties;
    }

    private static boolean parseArguments(String[] args) {
        try {
            int i = 1;
            while (i <= args.length - 1) {
                if (args[i].equalsIgnoreCase("-o")) {
                    outputPath = args[++i];
                } else if (args[i].equalsIgnoreCase("-f")) {
                    filterPath = args[++i];
                } else if (args[i].equalsIgnoreCase("-c")) {
                    connectionProfilePath = args[++i];
                } else if (args[i].equalsIgnoreCase("-t")) {
                    appType = args[++i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean saveToFile(String targetFileName, String appsStr) throws Exception {
        File fullPath = new File(targetFileName);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fullPath, false));
        bufferedWriter.write(appsStr);
        bufferedWriter.close();
        return true;
    }

    public static HashMap<String, String> getSupportedApplications() {
        HashMap<String, String> toRet = new HashMap<String, String>();
        File directory = new File(jarFolderPath);
        File[] filesList = directory.listFiles();
        if (filesList != null) {
            File[] fileArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().toLowerCase().endsWith(".xml")) {
                    String fileContent = ApplicationUtils.fileToString(file);
                    String applicationName = ApplicationUtils.getDataFromXml(file, "TYPE");
                    String displayName = ApplicationUtils.getDataFromXml(file, "DISPLAY_NAME");
                    String className = ApplicationUtils.getDataFromXml(file, "CLASS_NAME");
                    toRet.put(applicationName, displayName);
                    if (_isFirstInit) {
                        applicationToPropertiesFile.put(applicationName, fileContent);
                        classesMap.put(applicationName, className);
                    }
                }
                ++n2;
            }
        }
        _isFirstInit = false;
        return toRet;
    }

    private static String getDataFromXml(File file, String attr) {
        String returnValue = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            Element attributes = (Element)document.getElementsByTagName("Attributes").item(0);
            returnValue = attributes.getAttribute(attr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    private static String fileToString(File file) {
        StringBuilder fileContents = new StringBuilder((int)file.length());
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(String.valueOf(scanner.nextLine()) + lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    public static String getApplicationProperties(String applicationType) {
        return applicationToPropertiesFile.get(applicationType);
    }

    public static IApplicationExtractor getExtractor(String type) {
        ApplicationUtils.getSupportedApplications();
        Object appInstance = null;
        try {
            ApplicationUtils.addURL(new URL(String.format("file:%s/Application.%s.jar", jarFolderPath, type)));
            ApplicationUtils.add3dPartys();
            String classNameToBeLoaded = classesMap.get(type);
            ClassLoader myClassLoader = ClassLoader.getSystemClassLoader();
            Class<?> myApplicationExtractor = myClassLoader.loadClass(classNameToBeLoaded);
            appInstance = myApplicationExtractor.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appInstance;
    }

    private static void add3dPartys() throws MalformedURLException, IOException {
        File directory = new File(partyFolderPath);
        File[] filesList = directory.listFiles();
        if (filesList != null) {
            File[] fileArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().toLowerCase().endsWith(".jar")) {
                    ApplicationUtils.addURL(new URL(String.format("file:" + file.getPath(), new Object[0])));
                }
                ++n2;
            }
        }
    }

    private static void addURL(URL u) throws IOException {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = sysLoader.getURLs();
        int i = 0;
        while (i < urls.length) {
            if (urls[i].toString().equalsIgnoreCase(u.toString())) {
                return;
            }
            ++i;
        }
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysLoader, u);
        }
        catch (Throwable t) {
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

