/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.jobtypes.sql;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.jobtypes.JobTypesHelper;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SchedEntityUtils;
import com.bmc.ctmconvert.db.DbSqlWrapper;
import java.util.Optional;

public class SqlQueryConverter {
    private final AutosysJob job;
    private final JobTypesHelper helper;

    public SqlQueryConverter(AutosysJob autosysJob) {
        this.job = autosysJob;
        this.helper = new JobTypesHelper(this.job);
    }

    public void convert() {
        new DbSqlWrapper((SchedEntity)this.job).convertToDbSqlJob().addSqlQuery(this.getQuery()).setConnectionProfile(this.helper.getConnectionProfile()).setAppendOutputTo(DbSqlWrapper.OutputFormat.TEXT);
        this.copyOutputToFile();
    }

    private void copyOutputToFile() {
        this.getDestinationFile().filter(v -> !"NULL".equals(v)).ifPresent(file -> SchedEntityUtils.setCopyOutputToFile((SchedEntity)this.job, (String)file));
    }

    private Optional<String> getDestinationFile() {
        return this.helper.getOptionalSourceAttribute("destination_file").map(GlobalFunctions::removeQuotesIfNeeded).map(this.helper::handleBuiltinAutoEdits);
    }

    private String getQuery() {
        return this.helper.getOptionalSourceAttribute("sql_command").map(GlobalFunctions::removeQuotesIfNeeded).map(this.helper::handleBuiltinAutoEdits).orElse("");
    }
}

