/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.jobtypes;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.HandleBuiltinAutoEdits;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.Optional;

public class JobTypesHelper {
    private final AutosysJob job;
    private final HandleBuiltinAutoEdits handleBuiltinAutoEdits;

    public JobTypesHelper(AutosysJob job) {
        this.job = job;
        this.handleBuiltinAutoEdits = new HandleBuiltinAutoEdits(job);
    }

    public String handleBuiltinAutoEdits(String input) {
        return this.handleBuiltinAutoEdits.handle(input);
    }

    public String getSourceAttribute(String attr) {
        return this.job.getSourceAttr().getAttr(attr);
    }

    public Optional<String> getOptionalSourceAttribute(String attr) {
        return Optional.ofNullable(this.getSourceAttribute(attr));
    }

    public String getConnectionProfile() {
        String connectionProfileName = this.getSourceAttribute("connect_string");
        return FieldValidation.instance().validateAndReturnFixedValue(this.job::addMessage, "CONNECTION_PROFILE", connectionProfileName, true, "connect_string");
    }
}

