/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.jobtypes;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AutosysBoxSuccessFailureAssistingJobsBuilder {
    private final AutosysDefs sourceDefs;
    private final AutosysJob job;

    public AutosysBoxSuccessFailureAssistingJobsBuilder(AutosysJob job, AutosysDefs sourceDefs) {
        this.job = job;
        this.sourceDefs = sourceDefs;
    }

    public List<AssistingJob> buildBoxSuccessFailureAssistingJobs(String boxSuccess, String boxFailure) {
        ArrayList<AssistingJob> boxAssistingJobs = new ArrayList<AssistingJob>();
        if (!boxSuccess.isEmpty()) {
            boxAssistingJobs.add(this.getBoxSuccessAssistingJob(boxSuccess));
        }
        if (!boxFailure.isEmpty()) {
            boxAssistingJobs.add(this.getBoxFailureAssistingJob());
        }
        return boxAssistingJobs;
    }

    private AssistingJob getBoxSuccessAssistingJob(String boxSuccess) {
        AssistingJob assistingSuccessJob = new AssistingJob((SchedEntity)this.job);
        assistingSuccessJob.setAsChildAssistingJob(this.job.type());
        assistingSuccessJob.setAttribute("END_FOLDER", "Y");
        this.addNameForAssistingJob(assistingSuccessJob, "box_success");
        this.addInCondForAssistingJob(assistingSuccessJob);
        this.job.addMessage("WRN4067", this.job.getOriginalJobName(), this.job.getJobName(), assistingSuccessJob.getJobName(), boxSuccess);
        return assistingSuccessJob;
    }

    private AssistingJob getBoxFailureAssistingJob() {
        AssistingJob assistingFailureJob = new AssistingJob((SchedEntity)this.job);
        assistingFailureJob.setAsChildAssistingJob(this.job.type());
        this.addNameForAssistingJob(assistingFailureJob, "box_failure");
        OnStatement.OnOkStatement onJobEndedStatement = new OnStatement.OnOkStatement();
        onJobEndedStatement.addDo(Do.createDoNotOk());
        onJobEndedStatement.accept((on, doStatements) -> {
            Properties onDoStatement = new Properties();
            onDoStatement.putAll((Map<?, ?>)on);
            onDoStatement.putAll((Map<?, ?>)((Map)doStatements.get(0)));
            assistingFailureJob.addOnStmt(onDoStatement);
        });
        this.addInCondForAssistingJob(assistingFailureJob);
        return assistingFailureJob;
    }

    private void addNameForAssistingJob(AssistingJob boxJob, String boxStatus) {
        String boxJobName = AutosysBoxSuccessFailureAssistingJobsBuilder.getAssistingJobName(this.job.getOriginalJobName(), boxStatus);
        boxJob.setJobName(boxJobName);
    }

    private void addInCondForAssistingJob(AssistingJob assistingJob) {
        if (this.sourceDefs.getJobInconds(assistingJob.getJobName()) != null) {
            AutosysDefs.removeDummyConditions(this.sourceDefs.getJobInconds(assistingJob.getJobName())).forEach(arg_0 -> ((AssistingJob)assistingJob).addInCondition(arg_0));
        }
    }

    public static String getAssistingJobName(String boxName, String boxStatus) {
        String jobName = String.format("%s_%s", boxStatus, boxName);
        return FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", jobName);
    }
}

