/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoMail;
import com.bmc.ctmconvert.ondo.OnStatement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;

public class SendNotificationHandler {
    private final List<Properties> onStmtList;
    private final IAttrHolder sourceAttr;
    private final SendNotification sendNotification;

    public SendNotificationHandler(AutosysJob autosysJob) {
        this.onStmtList = autosysJob.getOnStmt(true);
        this.sourceAttr = autosysJob.getSourceAttr();
        this.sendNotification = new SendNotification(this.sourceAttr);
    }

    private void createCompleteMail(Properties domail) {
        String howEnded = "Ended";
        domail.setProperty("CODE", "COMPSTAT EQ ANY");
        domail.setProperty("SUBJECT", "Control-M: %%JOBNAME " + howEnded);
    }

    private void createNOTOKMail(Properties domail) {
        String howEnded = "Ended-NOTOK";
        domail.setProperty("CODE", "NOTOK");
        domail.setProperty("SUBJECT", "Control-M: %%JOBNAME " + howEnded);
    }

    private String loopThroughMails(String type, String dest, int mailCount) {
        String str;
        StringBuilder destBuilder = new StringBuilder(dest);
        while ((str = this.sourceAttr.getAttr(type + mailCount)) != null && !str.equals("NULL") && !str.equals("null")) {
            destBuilder.append(str).append(";");
            ++mailCount;
        }
        dest = destBuilder.toString();
        return dest;
    }

    private String getEmailDestinations() {
        String dest = "";
        int mailCount = 1;
        if ((dest = this.loopThroughMails("notification_emailaddress", dest, mailCount)).isEmpty()) {
            dest = this.loopThroughMails("notification_id", dest, mailCount);
        }
        if (dest.length() > 0) {
            dest = dest.substring(0, dest.length() - 1);
        }
        return dest;
    }

    public void handleSendNotification() {
        this.handleNormalNotifications();
        this.handleOnSuccessNotifications();
        this.handleOnFailureNotifications();
    }

    private void handleOnFailureNotifications() {
        String subject = "Control-M: %%JOBNAME Ended Not Ok";
        this.handleOnSuccessFailureNotifications(subject, (OnStatement)new OnStatement.OnNotOkStatement(), "notification_emailaddress_on_failure");
    }

    private void handleOnSuccessNotifications() {
        String subject = "Control-M: %%JOBNAME Ended Ok";
        this.handleOnSuccessFailureNotifications(subject, (OnStatement)new OnStatement.OnOkStatement(), "notification_emailaddress_on_success");
    }

    private void handleOnSuccessFailureNotifications(String subject, OnStatement onStatement, String emailAddressAttribute) {
        String emailAddress = this.sourceAttr.getAttr(emailAddressAttribute);
        if (!this.nullOrEmpty(emailAddress) && this.sendNotification.isSendNotification()) {
            DoMail doMail = new DoMail(new String[]{emailAddress}).setSubject(subject).setMessage(subject);
            onStatement.addDo((Do)doMail);
            onStatement.accept((on, doStatements) -> {
                Properties onDoStatement = new Properties();
                onDoStatement.putAll((Map<?, ?>)on);
                onDoStatement.putAll((Map<?, ?>)((Map)doStatements.get(0)));
                this.onStmtList.add(onDoStatement);
            });
        }
    }

    private void handleNormalNotifications() {
        Properties domail = new Properties();
        String emailDestination = this.getEmailDestinations();
        String message = this.sourceAttr.getAttr("notification_msg");
        if (this.sendNotification.nullOrEmpty() || this.nullOrEmpty(emailDestination) || this.nullOrEmpty(message)) {
            return;
        }
        if (this.sendNotification.isSendNotification()) {
            this.createCompleteMail(domail);
        } else if (this.sendNotification.isFailSendNotification()) {
            this.createNOTOKMail(domail);
        } else if (this.sendNotification.isNotSendNotification()) {
            return;
        }
        domail.setProperty("ACTION", "DOMAIL");
        domail.setProperty("DEST", this.getEmailDestinations());
        domail.setProperty("URGENCY", "R");
        domail.setProperty("MESSAGE", message);
        domail.setProperty("ATTACH_SYSOUT", "D");
        domail.setProperty("STMT", "*");
        this.onStmtList.add(domail);
    }

    private boolean nullOrEmpty(String input) {
        return input == null || input.isEmpty() || input.equals("NULL");
    }

    private static class SendNotification {
        private final String sendNotificationValue;

        public SendNotification(IAttrHolder sourceAttr) {
            this.sendNotificationValue = sourceAttr.getAttr("send_notification");
        }

        public boolean isFailSendNotification() {
            return this.compareNotification("2", "f", "F");
        }

        private boolean isSendNotification() {
            return this.compareNotification("1", "y");
        }

        private boolean isNotSendNotification() {
            return this.compareNotification("0", "n");
        }

        private boolean compareNotification(String ... values) {
            return Stream.of(values).anyMatch(this.sendNotificationValue::equalsIgnoreCase);
        }

        private boolean nullOrEmpty() {
            return this.sendNotificationValue == null || this.sendNotificationValue.isEmpty() || this.sendNotificationValue.equals("NULL");
        }
    }
}

