/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.HandleBuiltinAutoEdits;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.Map;
import java.util.Properties;

public class RedirectionHandler {
    private Map<String, String> m_jobAttr;
    private IAttrHolder m_sourceAttr;
    private String m_jobName;
    private HandleBuiltinAutoEdits handleBuiltinAutoEdits;
    private AutosysJob autosysJob;

    public RedirectionHandler(AutosysJob autosysJob) {
        this.m_jobAttr = autosysJob.getJobAttr();
        this.m_sourceAttr = autosysJob.getSourceAttr();
        this.m_jobName = autosysJob.getJobName();
        this.handleBuiltinAutoEdits = autosysJob.getHandleBuiltinAutoEdits();
        this.autosysJob = autosysJob;
    }

    public Properties getDoShoutWithRedirection() {
        String operator;
        String stdIn = this.m_sourceAttr.getAttr("std_in_file").trim();
        if (!stdIn.equals("NULL") && !stdIn.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.m_jobAttr.get("CMDLINE"));
            sb.append(stdIn.startsWith("<") ? "" : "<");
            sb.append("\"" + stdIn + "\"");
            this.m_jobAttr.put("CMDLINE", sb.toString());
        }
        int errMode = 0;
        String stdErr = this.m_sourceAttr.getAttr("std_err_file").trim();
        while (stdErr.startsWith(">")) {
            ++errMode;
            stdErr = stdErr.substring(1);
        }
        int outMode = 0;
        String stdOut = this.m_sourceAttr.getAttr("std_out_file").trim();
        while (stdOut.startsWith(">")) {
            ++outMode;
            stdOut = stdOut.substring(1);
        }
        String targetFile = stdOut;
        if ((stdErr.equals("NULL") || stdErr.isEmpty()) && (stdOut.equals("NULL") || stdOut.isEmpty())) {
            return new Properties();
        }
        if (!AutosysDefs.getAutosysJobType(this.m_sourceAttr).equals("c")) {
            this.autosysJob.addMessage("WRN4006", this.m_jobName, "output redirection");
            return new Properties();
        }
        if (!stdErr.isEmpty() && !stdErr.equals("NULL")) {
            targetFile = stdOut.equals("NULL") || stdOut.isEmpty() ? stdErr : stdOut;
            this.autosysJob.addMessage("INF4003", this.m_jobName, targetFile);
        }
        if (outMode > 0) {
            operator = outMode == 1 ? ">" : ">>";
            this.autosysJob.addMessage("INF4007", operator, "std_out_file", this.m_jobName, targetFile);
        }
        if (errMode > 0) {
            operator = errMode == 1 ? ">" : ">>";
            this.autosysJob.addMessage("INF4007", operator, "std_err_file", this.m_jobName, targetFile);
        }
        return this.redirectStatement(targetFile);
    }

    private Properties redirectStatement(String targetFile) {
        Properties tmpStatement = new Properties();
        tmpStatement.setProperty("CODE", "COMPSTAT EQ ANY");
        tmpStatement.setProperty("STMT", "*");
        tmpStatement.setProperty("ACTION", "DOSYSOUT");
        tmpStatement.setProperty("OPTION", "Copy");
        targetFile = this.handleBuiltinAutoEdits.handle(targetFile);
        tmpStatement.setProperty("PAR", targetFile);
        return tmpStatement;
    }
}

