/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys.handlers;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutosysSAPConvertorHandler {
    private static AutosysSAPConvertorHandler m_instance = null;

    private AutosysSAPConvertorHandler() {
    }

    public static AutosysSAPConvertorHandler instance() {
        if (m_instance == null) {
            m_instance = new AutosysSAPConvertorHandler();
        }
        return m_instance;
    }

    public boolean isSapJobCommand(String command) {
        return command.matches("\\s*sapjob.*");
    }

    public int getNumberOfSteps(String command) {
        if (!command.matches("\\s*sapjob.*")) {
            return 0;
        }
        return command.split("\\s*-r\\s*").length - 1;
    }

    private static Map<String, String> getR3Autoedits(String command, HashMap<String, String> jobAttr, ArrayList<String> messages) {
        boolean progFound = false;
        HashMap<String, String> r3Autoedits = new HashMap<String, String>();
        r3Autoedits.put("%%SAPR3-JOBCLASS", "C");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_NUMCOLUMNS", "-1");
        r3Autoedits.put("%%SAPR3-JOBLOG", "*SYSOUT");
        r3Autoedits.put("%%SAPR3-ACCOUNT", "DEFAULT_ACCOUNT");
        String[] commandArr = command.split("\\s+");
        for (int i = 0; i < commandArr.length; ++i) {
            if (commandArr[i].compareTo("-C") == 0) {
                try {
                    String account = "";
                    account = commandArr[++i].toUpperCase();
                    r3Autoedits.put("%%SAPR3-ACCOUNT", account);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                continue;
            }
            if (commandArr[i].startsWith("CONFIG=")) {
                r3Autoedits.put("%%SAPR3-ACCOUNT", commandArr[i].split("=", 2)[1]);
                continue;
            }
            if (commandArr[i].compareTo("-L") == 0) {
                r3Autoedits.put("%%SAPR3-SPOOL", "*SYSOUT");
                r3Autoedits.put("%%SAPR3-JOBLOG", "*SYSOUT");
                continue;
            }
            if (commandArr[i].compareTo("-r") == 0) {
                String targetServer = "";
                try {
                    targetServer = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    targetServer = "TARGET_SERVER";
                }
                r3Autoedits.put("%%SAPR3-TARGET_SERVER", targetServer);
                continue;
            }
            if (commandArr[i].compareTo("prog") == 0 || commandArr[i].compareTo("-prog") == 0) {
                progFound = true;
                String program = "";
                String variant = "";
                try {
                    program = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    program = "PROGRAM";
                }
                try {
                    if (commandArr.length > i + 1 && !commandArr[i + 1].startsWith("-") && (variant = commandArr[++i]).startsWith("\"")) {
                        int index = i;
                        StringBuilder sb = new StringBuilder(commandArr[index++]);
                        while (commandArr.length > index && !commandArr[index].endsWith("\"")) {
                            sb.append(" " + commandArr[index++]);
                        }
                        if (commandArr.length > index) {
                            sb.append(" " + commandArr[index]);
                        }
                        variant = sb.toString().replaceAll("\"", "");
                        i = index;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    variant = "VARIANT";
                }
                r3Autoedits.put("%%SAPR3-STEP-S01-PROGRAM", program);
                r3Autoedits.put("%%SAPR3-STEP-S01-VAR-NAME", variant);
                r3Autoedits.put("%%SAPR3-JOB_MODE", "CREATE");
                continue;
            }
            if (commandArr[i].compareTo("-k") == 0) {
                String jobClass = "";
                try {
                    jobClass = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    jobClass = "C";
                }
                r3Autoedits.put("%%SAPR3-JOBCLASS", jobClass.toUpperCase());
                continue;
            }
            if (commandArr[i].compareTo("-z") == 0) {
                String columns = "";
                try {
                    columns = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    columns = "255";
                }
                r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_NUMCOLUMNS", columns);
                continue;
            }
            if (commandArr[i].startsWith("LINE_SIZE=")) {
                r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_NUMCOLUMNS", commandArr[i].split("=", 2)[1]);
                continue;
            }
            if (commandArr[i].compareTo("job") == 0) {
                r3Autoedits.put("%%SAPR3-JOBNAME", commandArr[++i]);
                continue;
            }
            if (commandArr[i].compareTo("auto_r3v45") == 0) continue;
            boolean _progFound = false;
            for (int j = 0; j < commandArr.length; ++j) {
                if (commandArr[j].compareTo("prog") != 0 && commandArr[j].compareTo("-prog") != 0) continue;
                _progFound = true;
                break;
            }
            if (!_progFound) continue;
            Reporter.addMessage(messages, (String)"WRN4011", (String)jobAttr.get("JOBNAME"), (String[])new String[]{commandArr[i]});
        }
        if (!progFound) {
            r3Autoedits.put("%%SAPR3-JOB_MODE", "RUN_COPY");
        }
        if (r3Autoedits.get("%%SAPR3-JOBNAME") == null || ((String)r3Autoedits.get("%%SAPR3-JOBNAME")).isEmpty()) {
            r3Autoedits.put("%%SAPR3-JOBNAME", jobAttr.get("JOBNAME"));
        }
        r3Autoedits.put("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        r3Autoedits.put("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
        r3Autoedits.put("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        r3Autoedits.put("%%SAPR3-JOB_COUNT", "LAST_SCHEDULED");
        r3Autoedits.put("%%SAPR3-JOBCOUNT", "LAST_SCHEDULED");
        r3Autoedits.put("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        r3Autoedits.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        r3Autoedits.put("%%SAPR3-SUBMIT_ASAP", "X");
        r3Autoedits.put("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        r3Autoedits.put("%%SAPR3-XBP_VERSION", "XBP30");
        r3Autoedits.put("%%SAPR3-DETECT_OPTION", "1");
        r3Autoedits.put("%%SAPR3-INC_APP_STAT", "no");
        r3Autoedits.put("%%SAPR3-RERUN_STEP_NUM", "1");
        r3Autoedits.put("%%SAPR3-STEP-S01-STEP_TYPE", "A");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_COPIES", "1");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_RELEASE", "N");
        r3Autoedits.put("%%SAPR3-STEP-S01-NEW_LIST_ID", "X");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_EXPIRATION", "8");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_BANNER", "D");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_HOST_BANNER", "D");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_IMMED", "N");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_BANNER_PAGE", "N");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_NUMLINES", "-1");
        r3Autoedits.put("%%SAPR3-STEP-S01-PRINT_ARCHMODE", "Print");
        return r3Autoedits;
    }

    private static Map<String, String> getsapjobAutoedit(String command, HashMap<String, String> jobAttr, ArrayList<String> messages) {
        int StepCounter = 0;
        HashMap<String, String> sapjobAutoedits = new HashMap<String, String>();
        sapjobAutoedits.put("%%SAPR3-JOBCLASS", "C");
        sapjobAutoedits.put("%%SAPR3-ACCOUNT", "DEFAULT_ACCOUNT");
        sapjobAutoedits.put("%%SAPR3-SUBMIT_ASAP", "X");
        String[] commandArr = command.split("\\s+");
        for (int i = 0; i < commandArr.length; ++i) {
            String columns;
            String value;
            String newSpool;
            String jobClass;
            StringBuilder sb;
            String variant;
            String program;
            if (commandArr[i].compareTo("-r") == 0) {
                program = "";
                try {
                    program = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    program = "PROGRAM";
                }
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PROGRAM", ++StepCounter), program);
                continue;
            }
            if (commandArr[i].startsWith("REPORT=")) {
                program = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PROGRAM", ++StepCounter), program);
                continue;
            }
            if (commandArr[i].compareTo("-v") == 0) {
                variant = "";
                try {
                    variant = commandArr[++i];
                    if (variant.startsWith("\"") && variant.endsWith("\"")) {
                        variant = variant.replaceAll("\"", "");
                    } else if (variant.startsWith("\"")) {
                        sb = new StringBuilder(variant);
                        while (!commandArr[i + 1].endsWith("\"")) {
                            sb.append(" ").append(commandArr[++i]);
                        }
                        sb.append(" ").append(commandArr[++i]);
                        variant = sb.toString().replaceAll("\"", "");
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    variant = "VARIANT";
                }
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-VAR-NAME", StepCounter), variant.toUpperCase());
                continue;
            }
            if (commandArr[i].startsWith("VARIANT=")) {
                variant = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-VAR-NAME", StepCounter), variant.toUpperCase());
                continue;
            }
            if (commandArr[i].compareTo("-4") == 0) {
                jobClass = "";
                try {
                    jobClass = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    jobClass = "C";
                }
                sapjobAutoedits.put("%%SAPR3-JOBCLASS", jobClass.toUpperCase());
                continue;
            }
            if (commandArr[i].startsWith("JOBCLASS=")) {
                jobClass = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put("%%SAPR3-JOBCLASS", jobClass.toUpperCase());
                continue;
            }
            if (commandArr[i].compareTo("+C") == 0) {
                try {
                    String account = "";
                    account = commandArr[++i].toUpperCase();
                    sapjobAutoedits.put("%%SAPR3-ACCOUNT", account);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                continue;
            }
            if (commandArr[i].startsWith("CONFIG=")) {
                sapjobAutoedits.put("%%SAPR3-ACCOUNT", commandArr[i].split("=", 2)[1]);
                continue;
            }
            if (commandArr[i].compareTo("+s") == 0 || commandArr[i].startsWith("TARGETSERVER=")) {
                String hostname = "";
                if (commandArr[i].compareTo("+s") == 0) {
                    try {
                        hostname = commandArr[++i];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        ExceptionHandler.writeToExceptionFile((Exception)e);
                        hostname = "";
                    }
                } else {
                    hostname = commandArr[i].split("=", 2)[1];
                }
                sapjobAutoedits.put("%%SAPR3-TARGET_SERVER", hostname);
                String[] nameSplited = hostname.split("_");
                if (nameSplited.length == 3) {
                    sapjobAutoedits.put("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
                    continue;
                }
                sapjobAutoedits.put("%%SAPR3-SERVER_OR_GROUP_TYPE", "G");
                continue;
            }
            if (commandArr[i].compareTo("-b") == 0) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-LIST_TEXT", StepCounter), commandArr[++i]);
                continue;
            }
            if (commandArr[i].startsWith("TITLE=")) {
                String spoolText = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-LIST_TEXT", StepCounter), spoolText);
                continue;
            }
            if (commandArr[i].compareToIgnoreCase("-c") == 0) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", StepCounter), commandArr[++i]);
                continue;
            }
            if (commandArr[i].startsWith("COPIES=")) {
                String numberOfCcopies = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", StepCounter), numberOfCcopies);
                continue;
            }
            if (commandArr[i].compareToIgnoreCase("-i") == 0) {
                if (commandArr[++i].compareTo("Y") != 0) continue;
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", StepCounter), "X");
                continue;
            }
            if (commandArr[i].startsWith("IMMEDIATELY=")) {
                if (!commandArr[i].equals("IMMEDIATELY=Y")) continue;
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", StepCounter), "X");
                continue;
            }
            if (commandArr[i].compareTo("-k") == 0) {
                String mode = commandArr[++i];
                String jobMode = "";
                if (mode.compareTo("P") == 0) {
                    jobMode = "Print";
                } else if (mode.compareTo("A") == 0) {
                    jobMode = "ARCHIVE";
                } else if (mode.compareTo("B") == 0) {
                    jobMode = "PRINT_ARCHIVE";
                }
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_ARCHMODE", StepCounter), jobMode);
                continue;
            }
            if (commandArr[i].compareTo("-p") == 0) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_DEST", StepCounter), commandArr[++i]);
                continue;
            }
            if (commandArr[i].startsWith("PDEST=")) {
                String dest = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_DEST", StepCounter), dest);
                continue;
            }
            if (commandArr[i].compareTo("+r") == 0) {
                sapjobAutoedits.put("%%SAPR3-RECIPIENT", commandArr[++i]);
                continue;
            }
            if (commandArr[i].startsWith("RECIPIENT=")) {
                String recipientname = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put("%%SAPR3-RECIPIENT", recipientname);
                continue;
            }
            if (commandArr[i].compareTo("+t") == 0 || commandArr[i].startsWith("RECIPIENT_TYPE=")) {
                String recipientType = "";
                String sapJobArgument = "";
                if (commandArr[i].compareTo("+t") == 0) {
                    sapJobArgument = commandArr[i];
                    try {
                        recipientType = commandArr[++i];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        ExceptionHandler.writeToExceptionFile((Exception)e);
                        recipientType = "";
                    }
                } else {
                    sapJobArgument = commandArr[i].split("=", 2)[0];
                    recipientType = commandArr[i].split("=", 2)[1];
                }
                switch (recipientType) {
                    case "B": {
                        sapjobAutoedits.put("%%SAPR3-RECIP_TYPE", "B");
                        break;
                    }
                    case "C": {
                        sapjobAutoedits.put("%%SAPR3-RECIP_TYPE", "C");
                        break;
                    }
                    case "P": {
                        sapjobAutoedits.put("%%SAPR3-RECIP_TYPE", "P");
                        break;
                    }
                    default: {
                        Reporter.addMessage(messages, (String)"WRN4015", (String)jobAttr.get("JOBNAME"), (String[])new String[]{sapJobArgument, recipientType});
                        break;
                    }
                }
                continue;
            }
            if (commandArr[i].compareTo("-1") == 0) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-ARCHIVE_INFO", StepCounter), commandArr[++i]);
                continue;
            }
            if (commandArr[i].compareTo("-2") == 0) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-ARCHIVE_OBJECT", StepCounter), commandArr[++i]);
                continue;
            }
            if (commandArr[i].compareTo("-3") == 0) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-ARCHIVE_SAPOBJECT", StepCounter), commandArr[++i]);
                continue;
            }
            if (commandArr[i].compareTo("-5") == 0) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_AUTH", StepCounter), commandArr[++i]);
                continue;
            }
            if (commandArr[i].compareTo("-7") == 0) {
                newSpool = commandArr[++i];
                value = "";
                if (newSpool.compareTo("N") == 0) {
                    value = "N";
                } else if (newSpool.compareTo("Y") == 0) {
                    value = "X";
                }
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", StepCounter), value);
                continue;
            }
            if (commandArr[i].startsWith("NEWSPOOL=")) {
                newSpool = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", StepCounter), newSpool.equals("Y") ? "X" : "N");
                continue;
            }
            if (commandArr[i].startsWith("ARCTEXT=")) {
                String archText = "";
                try {
                    archText = commandArr[i].replaceAll("ARCTEXT=", "");
                    sb = new StringBuilder(archText);
                    while (!commandArr[i + 1].endsWith("\"")) {
                        sb.append(" " + commandArr[++i]);
                    }
                    sb.append(" " + commandArr[++i]);
                    archText = sb.toString().replaceAll("\"", "");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    archText = "ARCTEXT";
                }
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-ARCH_TEXT", StepCounter), archText);
                continue;
            }
            if (commandArr[i].startsWith("JOBNAME=")) {
                String jobname = commandArr[i].substring(commandArr[i].indexOf("=") + 1);
                sapjobAutoedits.put("%%SAPR3-JOBNAME", jobname);
                continue;
            }
            if (commandArr[i].compareTo("-m") == 0 || commandArr[i].compareTo("-d") == 0 || commandArr[i].compareTo("-u") == 0) {
                String message = commandArr[i] + " " + commandArr[++i];
                Reporter.addMessage(messages, (String)"WRN4011", (String)jobAttr.get("JOBNAME"), (String[])new String[]{message});
                continue;
            }
            if (commandArr[i].compareTo("-z") == 0) {
                columns = "";
                try {
                    columns = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    columns = "255";
                }
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_NUMCOLUMNS", StepCounter), columns);
                continue;
            }
            if (commandArr[i].startsWith("LINE_SIZE=")) {
                columns = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_NUMCOLUMNS", StepCounter), columns);
                continue;
            }
            if (commandArr[i].compareTo("-t") == 0) {
                String lines = "";
                try {
                    lines = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    lines = "-1";
                }
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_NUMLINES", StepCounter), lines);
                continue;
            }
            if (commandArr[i].compareTo("-sn") == 0) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-LIST_NAME", StepCounter), commandArr[++i]);
                continue;
            }
            if (commandArr[i].startsWith("SPOOLNAME=")) {
                String spoolName = commandArr[i].split("=", 2)[1];
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-LIST_NAME", StepCounter), spoolName);
                continue;
            }
            if (commandArr[i].startsWith("START")) {
                Object start = "X";
                value = commandArr[i].substring(commandArr[i].indexOf("=") + 1, commandArr[i].length());
                if (value.compareTo("I") == 0) {
                    start = "N";
                } else if (value.compareTo("A") == 0) {
                    start = "X";
                } else {
                    Reporter.addMessage(messages, (String)"WRN4011", (String)jobAttr.get("JOBNAME"), (String[])new String[]{commandArr[i]});
                }
                sapjobAutoedits.put("%%SAPR3-SUBMIT_ASAP", (String)start);
                continue;
            }
            if (commandArr[i].compareTo("sapjob") == 0) continue;
            Reporter.addMessage(messages, (String)"WRN4011", (String)jobAttr.get("JOBNAME"), (String[])new String[]{commandArr[i]});
        }
        if (sapjobAutoedits.get("%%SAPR3-JOBNAME") == null || ((String)sapjobAutoedits.get("%%SAPR3-JOBNAME")).isEmpty()) {
            sapjobAutoedits.put("%%SAPR3-JOBNAME", jobAttr.get("JOBNAME"));
        }
        if (sapjobAutoedits.get("%%SAPR3-STEP-S01-PROGRAM") != null && !((String)sapjobAutoedits.get("%%SAPR3-STEP-S01-PROGRAM")).isEmpty()) {
            sapjobAutoedits.put("%%SAPR3-JOB_MODE", "CREATE");
        } else {
            sapjobAutoedits.put("%%SAPR3-JOB_MODE", "RUN_COPY");
        }
        HashMap<String, String> lastFormatedStepParameters = AutosysSAPConvertorHandler.getDefaultStepParameters(sapjobAutoedits, StepCounter);
        AutosysSAPConvertorHandler.removeExceedSteps(sapjobAutoedits, 99);
        if (StepCounter > 99) {
            StepCounter = 99;
        }
        for (String ParameterFormat : lastFormatedStepParameters.keySet()) {
            for (int i = 1; i <= StepCounter; ++i) {
                String tmpAutoEdit = String.format(ParameterFormat, i);
                if (sapjobAutoedits.containsKey(tmpAutoEdit)) continue;
                sapjobAutoedits.put(tmpAutoEdit, lastFormatedStepParameters.get(ParameterFormat));
            }
        }
        for (int i = 1; i <= StepCounter; ++i) {
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-STEP_TYPE", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-STEP_TYPE", i), "A");
            }
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", i), "1");
            }
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", i), "N");
            }
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION", i), "8");
            }
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER", i), "D");
            }
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER", i), "D");
            }
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE", i), "N");
            }
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", i), "N");
            }
            if (!sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", i))) {
                sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-PRINT_ARCHMODE", i), "Print");
            }
            if (sapjobAutoedits.containsKey(String.format("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", i))) continue;
            sapjobAutoedits.put(String.format("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", i), "X");
        }
        sapjobAutoedits.put("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        sapjobAutoedits.put("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
        if (!sapjobAutoedits.containsKey("%%SAPR3-SERVER_OR_GROUP_TYPE")) {
            sapjobAutoedits.put("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        }
        sapjobAutoedits.put("%%SAPR3-JOB_COUNT", "LAST_SCHEDULED");
        sapjobAutoedits.put("%%SAPR3-JOBCOUNT", "LAST_SCHEDULED");
        sapjobAutoedits.put("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        sapjobAutoedits.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        sapjobAutoedits.put("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        sapjobAutoedits.put("%%SAPR3-XBP_VERSION", "XBP30");
        sapjobAutoedits.put("%%SAPR3-DETECT_OPTION", "1");
        sapjobAutoedits.put("%%SAPR3-INC_APP_STAT", "no");
        sapjobAutoedits.put("%%SAPR3-RERUN_STEP_NUM", "1");
        sapjobAutoedits.put("%%SAPR3-JOBLOG", "*SYSOUT");
        Map<String, String> sortedAotuEdits = AutosysSAPConvertorHandler.sortHash(sapjobAutoedits);
        return sortedAotuEdits;
    }

    public void convertSAPJob(String command, HashMap<String, String> jobAttr, ArrayList<String> optionalAttr, LinkedHashMap<String, String> autoedits, RulesDataSet rules, ArrayList<String> messages) {
        Matcher capchainMatcher = this.createMatcherForSapCommand("capchain", command);
        Matcher autoMatcher = this.createMatcherForSapCommand("auto_r3v45", command);
        Matcher sapJobMatcher = this.createMatcherForSapCommand("sapjob", command);
        Matcher sapipkgMatcher = this.createMatcherForSapCommand("sapipkg", command);
        if (autoMatcher.matches()) {
            commandMatch = autoMatcher.group("command");
            autoedits.putAll(AutosysSAPConvertorHandler.getR3Autoedits(commandMatch, jobAttr, messages));
            optionalAttr.addAll(AutosysSAPConvertorHandler.getOtionalSAPAttributes());
            jobAttr.putAll(AutosysSAPConvertorHandler.getJobSAPR3Attributes(rules));
            Reporter.addMessage(messages, (String)"INF4009", (String)jobAttr.get("JOBNAME"), (String[])new String[]{jobAttr.get("JOBNAME")});
        } else if (sapJobMatcher.matches()) {
            commandMatch = sapJobMatcher.group("command");
            autoedits.putAll(AutosysSAPConvertorHandler.getsapjobAutoedit(commandMatch, jobAttr, messages));
            optionalAttr.addAll(AutosysSAPConvertorHandler.getOtionalSAPAttributes());
            jobAttr.putAll(AutosysSAPConvertorHandler.getJobSAPR3Attributes(rules));
            Reporter.addMessage(messages, (String)"INF4010", (String)jobAttr.get("JOBNAME"), (String[])new String[]{jobAttr.get("JOBNAME")});
        } else if (capchainMatcher.matches()) {
            commandMatch = capchainMatcher.group("command");
            autoedits.putAll(this.getCapchainAutoedit(commandMatch, jobAttr, messages));
            optionalAttr.addAll(AutosysSAPConvertorHandler.getOtionalSAPAttributes());
            jobAttr.putAll(AutosysSAPConvertorHandler.getJobSAPBusinessWarehouseAttributes(rules));
            Reporter.addMessage(messages, (String)"INF4011", (String)jobAttr.get("JOBNAME"), (String[])new String[]{jobAttr.get("JOBNAME")});
        } else if (sapipkgMatcher.matches()) {
            commandMatch = sapipkgMatcher.group("command");
            autoedits.putAll(this.getSapipkgAutoedit(commandMatch, jobAttr, messages));
            optionalAttr.addAll(AutosysSAPConvertorHandler.getOtionalSAPAttributes());
            jobAttr.putAll(AutosysSAPConvertorHandler.getJobSAPBusinessWarehouseAttributes(rules));
            Reporter.addMessage(messages, (String)"INF4013", (String)jobAttr.get("JOBNAME"), (String[])new String[]{jobAttr.get("JOBNAME")});
        } else {
            return;
        }
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("ACTENTTYPE", "SAPACC");
        action.put("JOBID", jobAttr.get("JOBNAME"));
        action.put("ACTENTNAME", autoedits.get("%%SAPR3-ACCOUNT"));
        action.put("ACTSTATUS", "0");
        Reporter.addAction(action);
    }

    private Matcher createMatcherForSapCommand(String sapCommandName, String fullCommandLine) {
        return Pattern.compile(".*(?<command>%s.*)".formatted(sapCommandName)).matcher(fullCommandLine);
    }

    private Map<String, String> getSapipkgAutoedit(String command, HashMap<String, String> jobAttr, ArrayList<String> messages) {
        HashMap<String, String> sapipkgAutoedits = new HashMap<String, String>();
        String[] commandArr = command.split("\\s+");
        for (int i = 0; i < commandArr.length; ++i) {
            if (commandArr[i].compareTo("+C") == 0) {
                String account = "";
                try {
                    account = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                sapipkgAutoedits.put("%%SAPR3-ACCOUNT", account.toUpperCase());
                continue;
            }
            if (commandArr[i].startsWith("CONFIG=")) {
                sapipkgAutoedits.put("%%SAPR3-ACCOUNT", commandArr[i].split("=", 2)[1]);
                continue;
            }
            if (commandArr[i].compareTo("-t") == 0) {
                String techName = "";
                try {
                    techName = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                sapipkgAutoedits.put("%%SAPR3-InfoPackage_TechName", techName);
                continue;
            }
            if (commandArr[i].startsWith("TECHNAME=")) {
                sapipkgAutoedits.put("%%SAPR3-InfoPackage_TechName", commandArr[i].split("=", 2)[1]);
                continue;
            }
            if (commandArr[i].compareTo("-n") == 0) {
                String desc = "";
                try {
                    desc = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                sapipkgAutoedits.put("%%SAPR3-InfoPackage_Desc", desc);
                continue;
            }
            if (commandArr[i].startsWith("NAME=")) {
                sapipkgAutoedits.put("%%SAPR3-InfoPackage_Desc", commandArr[i].split("=", 2)[1]);
                continue;
            }
            if (commandArr[i].compareTo("-j") == 0) {
                String jobName = "";
                try {
                    jobName = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                sapipkgAutoedits.put("%%SAPR3-BACKJOBNAME", jobName);
                continue;
            }
            if (commandArr[i].startsWith("JOBNAME=")) {
                sapipkgAutoedits.put("%%SAPR3-BACKJOBNAME", commandArr[i].split("=", 2)[1]);
                continue;
            }
            if (commandArr[i].compareTo("sapipkg") == 0) continue;
            Reporter.addMessage(messages, (String)"WRN4011", (String)jobAttr.get("JOBNAME"), (String[])new String[]{commandArr[i]});
        }
        if (!sapipkgAutoedits.containsKey("%%SAPR3-InfoPackage_Desc")) {
            Reporter.addMessage(messages, (String)"WRN4013", (String)jobAttr.get("JOBNAME"), (String[])new String[]{jobAttr.get("JOBNAME"), "Auto Generated Description by Control-M"});
            sapipkgAutoedits.put("%%SAPR3-InfoPackage_Desc", "Auto Generated Description by Control-M");
        }
        sapipkgAutoedits.put("%%SAPR3-JOB_MODE", "IP_RUN_ORG");
        sapipkgAutoedits.put("%%SAPR3-PROCESS_TYPE", "InfoPackage");
        sapipkgAutoedits.put("%%SAPR3-PC_periodic", "X");
        sapipkgAutoedits.put("%%SAPR3-PC_DONT_POLL", "N");
        sapipkgAutoedits.put("%%SAPR3-JOBLOG", "*SYSOUT");
        sapipkgAutoedits.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        sapipkgAutoedits.put("%%SAPR3-JOBNAME", jobAttr.get("JOBNAME"));
        sapipkgAutoedits.put("%%SAPR3-RUNCOUNT", "%%RUNCOUNT");
        return sapipkgAutoedits;
    }

    private HashMap<String, String> getCapchainAutoedit(String command, HashMap<String, String> jobAttr, ArrayList<String> messages) {
        HashMap<String, String> capchainAutoedits = new HashMap<String, String>();
        String[] commandArr = command.split("\\s+");
        for (int i = 0; i < commandArr.length; ++i) {
            if (commandArr[i].compareTo("+C") == 0) {
                String account = "";
                try {
                    account = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                capchainAutoedits.put("%%SAPR3-ACCOUNT", account.toUpperCase());
                continue;
            }
            if (commandArr[i].startsWith("CONFIG=")) {
                capchainAutoedits.put("%%SAPR3-ACCOUNT", commandArr[i].split("=", 2)[1].toUpperCase());
                continue;
            }
            if (commandArr[i].compareTo("-n") == 0) {
                String chainID = "";
                try {
                    chainID = commandArr[++i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
                capchainAutoedits.put("%%SAPR3-ProcessChain_ID", chainID);
                continue;
            }
            if (commandArr[i].startsWith("CHAINID=")) {
                capchainAutoedits.put("%%SAPR3-ProcessChain_ID", commandArr[i].split("=", 2)[1]);
                continue;
            }
            if (commandArr[i].compareTo("capchain") == 0) continue;
            Reporter.addMessage(messages, (String)"WRN4011", (String)jobAttr.get("JOBNAME"), (String[])new String[]{commandArr[i]});
        }
        capchainAutoedits.putIfAbsent("%%SAPR3-ACCOUNT", "DEFAULT_CONNECTION");
        capchainAutoedits.put("%%SAPR3-JOBNAME", jobAttr.get("JOBNAME"));
        capchainAutoedits.put("%%SAPR3-RUNCOUNT", "%%RUNCOUNT");
        capchainAutoedits.put("%%SAPR3-JOB_MODE", "PC_RUN_ORG");
        capchainAutoedits.put("%%SAPR3-PROCESS_TYPE", "ProcessChain");
        capchainAutoedits.put("%%SAPR3-PROCESSCHAIN_RERUN_INSTANCE", "PC_RUN_CURR_INSTANCE");
        capchainAutoedits.put("%%SAPR3-PC_periodic", "X");
        capchainAutoedits.put("%%SAPR3-PC_DONT_POLL", "N");
        capchainAutoedits.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        capchainAutoedits.put("%%SAPR3-JOBLOG", "*SYSOUT");
        return capchainAutoedits;
    }

    private static HashMap<String, String> getDefaultStepParameters(HashMap<String, String> sapjobAutoedits, int numberOfSteps) {
        HashMap<String, String> lastParameters = new HashMap<String, String>();
        Map<Integer, HashMap<String, String>> stepsMap = AutosysSAPConvertorHandler.getStepsAutoEditsMap(sapjobAutoedits);
        for (int i = numberOfSteps; i > 0; --i) {
            Map stepAutoedits = stepsMap.get(i);
            if (stepAutoedits == null) continue;
            for (String tmpStepAutoedit : stepAutoedits.keySet()) {
                if (lastParameters.containsKey(tmpStepAutoedit)) continue;
                lastParameters.put(tmpStepAutoedit, (String)stepAutoedits.get(tmpStepAutoedit));
            }
        }
        return lastParameters;
    }

    private static Map<Integer, HashMap<String, String>> getStepsAutoEditsMap(HashMap<String, String> sapjobAutoedits) {
        LinkedHashMap<Integer, HashMap<String, String>> stepsMap = new LinkedHashMap<Integer, HashMap<String, String>>();
        for (String autoedit : sapjobAutoedits.keySet()) {
            if (!autoedit.matches(".*STEP-S\\d+.*") || autoedit.contains("-PROGRAM") || autoedit.contains("-VAR-NAME")) continue;
            int stepNumber = Integer.parseInt(autoedit.split("STEP-S")[1].replaceAll("\\D+", ""));
            if (!stepsMap.containsKey(stepNumber)) {
                stepsMap.put(stepNumber, new HashMap());
            }
            String AutoeditFormat = autoedit.replaceAll("%", "%%");
            AutoeditFormat = AutoeditFormat.replaceFirst("STEP-S\\d+", "STEP-S%02d");
            ((HashMap)stepsMap.get(stepNumber)).put(AutoeditFormat, sapjobAutoedits.get(autoedit));
        }
        return stepsMap;
    }

    private static void removeExceedSteps(HashMap<String, String> sapjobAutoedits, int limit) {
        if (sapjobAutoedits == null) {
            return;
        }
        Iterator<String> it = sapjobAutoedits.keySet().iterator();
        while (it.hasNext()) {
            int stepNumber;
            String autoedit = it.next();
            if (!autoedit.matches(".*STEP-S\\d+.*") || (stepNumber = Integer.parseInt(autoedit.split("STEP-S")[1].replaceAll("\\D+", ""))) <= limit) continue;
            it.remove();
        }
    }

    private static Map<String, String> sortHash(HashMap<String, String> sapipkgAutoedits) {
        LinkedHashMap<String, String> sortedAotuedits = new LinkedHashMap<String, String>();
        ArrayList<String> autoEditskeysArr = new ArrayList<String>(sapipkgAutoedits.keySet());
        Collections.sort(autoEditskeysArr);
        for (String autoedit : autoEditskeysArr) {
            sortedAotuedits.put(autoedit, sapipkgAutoedits.get(autoedit));
        }
        return sortedAotuedits;
    }

    private static Map<String, String> getJobSAPR3Attributes(RulesDataSet rules) {
        HashMap<String, String> sapAttr = new HashMap<String, String>(Globs.SAP_TYPE_FORM_VERSION);
        sapAttr.put("MEMLIB", "Not in use for SAP jobs");
        if (rules.getBooleanRule("TaskType", new String[]{"ConvertAllToDummy"}).booleanValue()) {
            sapAttr.put("TASKTYPE", "Dummy");
        } else {
            sapAttr.put("TASKTYPE", "Job");
        }
        return sapAttr;
    }

    private static Map<String, String> getJobSAPBusinessWarehouseAttributes(RulesDataSet rules) {
        HashMap<String, String> sapAttr = new HashMap<String, String>(Globs.SAP_TYPE_FORM_VERSION);
        sapAttr.put("MEMLIB", "Not in use for SAP jobs");
        sapAttr.put("APPL_FORM", "SAP Business Warehouse");
        if (rules.getBooleanRule("TaskType", new String[]{"ConvertAllToDummy"}).booleanValue()) {
            sapAttr.put("TASKTYPE", "Dummy");
        } else {
            sapAttr.put("TASKTYPE", "Job");
        }
        return sapAttr;
    }

    private static Collection<String> getOtionalSAPAttributes() {
        return Globs.SAP_TYPE_FORM_VERSION.keySet();
    }

    public boolean isSapJob(String command) {
        Matcher capchainMatcher = this.createMatcherForSapCommand("capchain", command);
        Matcher autoMatcher = this.createMatcherForSapCommand("auto_r3v45", command);
        Matcher sapJobMatcher = this.createMatcherForSapCommand("sapjob", command);
        Matcher sapipkgMatcher = this.createMatcherForSapCommand("sapipkg", command);
        return List.of(capchainMatcher, autoMatcher, sapJobMatcher, sapipkgMatcher).stream().anyMatch(Matcher::matches);
    }
}

