/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;

public class TimezoneConvert {
    private Properties autosys2Ctm = null;
    private final Map<String, String> autosysMapping = new HashMap<String, String>();

    public TimezoneConvert(String autosysTzFile) throws IOException {
        this.init(autosysTzFile);
    }

    private static Properties getCtmTzTranslateTable() throws IOException {
        String vendorName = Params.instance().getVendorName();
        try (FileInputStream is = new FileInputStream(Globs.MODULES_DATA_DIR + Globs.DIRSEP + vendorName + Globs.DIRSEP + "Autosys2CtmTimeZones.txt");){
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
    }

    private void init(String autosysTzFile) throws IOException {
        this.autosys2Ctm = TimezoneConvert.getCtmTzTranslateTable();
        Path autosysTzFilePath = Paths.get(autosysTzFile, new String[0]);
        if (!Files.exists(autosysTzFilePath, new LinkOption[0])) {
            return;
        }
        try (Stream<String> lines = Files.lines(autosysTzFilePath);){
            lines.map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("Entry")).filter(line -> !line.startsWith("------------")).map(line -> line.split("[ ]+")).filter(l -> {
                if (((String[])l).length != 3) {
                    ConversionLogger.getLogger().warning(() -> "Warning: %s: Invalid line skipped [%s]\n".formatted(autosysTzFile, l));
                    return false;
                }
                return true;
            }).forEach(vec -> this.autosysMapping.put(vec[0].toUpperCase(), vec[2].toUpperCase()));
        }
    }

    public String translate(String autosysTimezoneName) {
        String tzName = autosysTimezoneName.toUpperCase();
        for (int i = 0; i < 5; ++i) {
            String ctmTz = this.autosys2Ctm.getProperty(tzName);
            if (ctmTz != null) {
                return ctmTz;
            }
            if ((tzName = this.autosysMapping.get(tzName)) == null) break;
        }
        return null;
    }
}

