/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.autosys.AutosysGlobals;
import com.bmc.ctmconvert.autosys.SourceDataAutoSysManager;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.SourceDataBox;
import com.bmc.ctmconvert.io.csv.CsvReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SourceDataReportCSVReader {
    private final ArrayList<String[]> dataMatrix = new ArrayList();
    private final HashMap<String, Integer> columnsIndex = new HashMap();
    private final HashMap<String, Integer> jobNameIndex = new HashMap();
    private final HashMap<String, ArrayList<String>> calendarJobs = new HashMap();
    private final HashMap<String, ArrayList<String>> ownerJobs = new HashMap();
    private final HashMap<String, ArrayList<String>> agentJobs = new HashMap();
    private final HashMap<String, ArrayList<String>> autoSysJobs = new HashMap();
    private final HashMap<String, ArrayList<String>> excludeCalendarJobs = new HashMap();
    private final HashMap<String, SourceDataBox> boxes = new HashMap();
    private final List<SourceDataBox> levelOneBoxes = new ArrayList<SourceDataBox>();
    private final List<String> fileWatcherJobs = new ArrayList<String>();
    private final List<String> ftpJobs = new ArrayList<String>();
    private final List<String> boxSuccessFailureJobs = new ArrayList<String>();
    private final List<String> sapJobs = new ArrayList<String>();
    private final List<String> psftJobs = new ArrayList<String>();
    private final List<String> sapR3CopyJobs = new ArrayList<String>();
    private final List<String> sapR3CreateJobs = new ArrayList<String>();
    private final List<String> sapBwJobs = new ArrayList<String>();
    private final List<String> sqlJobs = new ArrayList<String>();
    private final List<String> storedProcedureJobs = new ArrayList<String>();
    private final List<String> omtfJobs = new ArrayList<String>();
    private final List<String> os400Jobs = new ArrayList<String>();
    private final List<String> zosJobs = new ArrayList<String>();
    private final List<String> httpJobs = new ArrayList<String>();
    private final List<String> unsupportedJobTypes = new ArrayList<String>();
    private String[] columnsHeaders;
    private int rowsCount = 0;
    private int jobsInsideBoxesCount = 0;
    private static final String JOB_SAP_TYPE_SUFFIX = "auto_r3";
    private static final String JOB_PSFT_TYPE_SUFFIX = "auto_ps7";

    public int getJobsNumber() {
        int num = 0;
        num += this.jobsInsideBoxesCount;
        if (null != this.getAllJobsNames()) {
            num += this.getAllJobsNames().size();
        }
        return num;
    }

    public String[] getColumnsHeaders() {
        return this.columnsHeaders;
    }

    public String[] getJobInfo(String jobName) {
        return Optional.ofNullable(this.jobNameIndex.get(jobName)).map(this.dataMatrix::get).orElse(new String[0]);
    }

    public List<String> getAllFileWatcherJobsNames() {
        return this.fileWatcherJobs;
    }

    public List<String> getAllFtpJobsNames() {
        return this.ftpJobs;
    }

    public List<String> getAllBoxSuccessFailureJobsNames() {
        return this.boxSuccessFailureJobs;
    }

    public List<String> getAllSAPJobsNames() {
        return this.sapJobs;
    }

    public List<String> getAllPsftJobsNames() {
        return this.psftJobs;
    }

    public List<String> getAllJobsNames() {
        ArrayList<String> result = new ArrayList<String>();
        int jobNameIndexColumn = this.columnsIndex.get("insert_job");
        int jobTypeIndexColumn = this.columnsIndex.get("job_type");
        int jobBoxIndexColumn = this.columnsIndex.get("box_name");
        for (int i = 0; i < this.rowsCount; ++i) {
            if (this.dataMatrix.get(i)[jobTypeIndexColumn].toLowerCase().startsWith("b") || !this.dataMatrix.get(i)[jobBoxIndexColumn].equalsIgnoreCase("NULL")) continue;
            result.add(this.dataMatrix.get(i)[jobNameIndexColumn]);
        }
        return result;
    }

    public List<String> getCalendarsJobsNames(String calendarName) {
        return this.calendarJobs.get(calendarName);
    }

    public Set<String> getCalendarsList() {
        return this.calendarJobs.keySet();
    }

    public List<String> getExcludeCalendarsJobsNames(String calendarName) {
        return this.excludeCalendarJobs.get(calendarName);
    }

    public Set<String> getExcludeCalendarsList() {
        return this.excludeCalendarJobs.keySet();
    }

    public List<String> getOwnersJobsNames(String ownerName) {
        return this.ownerJobs.get(ownerName);
    }

    public Set<String> getOwnersList() {
        return this.ownerJobs.keySet();
    }

    public List<String> getAgentsJobsNames(String agentName) {
        return this.agentJobs.get(agentName);
    }

    public Set<String> getAgentsList() {
        return this.agentJobs.keySet();
    }

    public Set<String> getAutoSysList() {
        return this.autoSysJobs.keySet();
    }

    public List<String> getAutoSysJobsNames(String autoSysName) {
        return this.autoSysJobs.get(autoSysName);
    }

    public Set<String> getBoxesList() {
        return this.boxes.keySet();
    }

    public List<String> getAllSapR3CopyJobNames() {
        return this.sapR3CopyJobs;
    }

    public List<String> getAllSapR3CreateJobNames() {
        return this.sapR3CreateJobs;
    }

    public List<String> getAllSapBwJobNames() {
        return this.sapBwJobs;
    }

    public List<String> getAllSQLJobNames() {
        return this.sqlJobs;
    }

    public List<String> getAllStoredProcedureJobs() {
        return this.storedProcedureJobs;
    }

    public List<String> getAllOMTFJobNames() {
        return this.omtfJobs;
    }

    public List<String> getAllOS400JobNames() {
        return this.os400Jobs;
    }

    public List<String> getUnsupportedJobTypes() {
        return this.unsupportedJobTypes;
    }

    public SourceDataBox getBoxByName(String boxName) {
        return this.boxes.get(boxName);
    }

    public SourceDataReportCSVReader(String fileName) {
        this.init(fileName);
    }

    public void init(String fileName) {
        try (CsvReader reader = new CsvReader(fileName);){
            SourceDataAutoSysManager autoSysMngr = new SourceDataAutoSysManager("dummy", false);
            int jobNameIndexColumn = 0;
            int calendarIndexColumn = 0;
            int ownerIndexColumn = 0;
            int agentIndexColumn = 0;
            int commandIndexColumn = 0;
            int jobTypeIndexColumn = 0;
            int boxNameIndexColumn = 0;
            int excludeCalendarIndexColumn = 0;
            int boxSuccessIndexColumn = 0;
            int boxFailureIndexColumn = 0;
            boolean columnsRow = true;
            while (reader.readRecord()) {
                ArrayList<String> agentJobsList;
                ArrayList<String> ownerJobsList;
                ArrayList<String> excludeCalendarJobsList;
                if (columnsRow) {
                    int columnsCount = reader.getValues().length;
                    this.columnsHeaders = new String[columnsCount];
                    for (int i = 0; i < columnsCount; ++i) {
                        this.columnsIndex.put(reader.getValues()[i], i);
                        this.columnsHeaders[i] = reader.getValues()[i];
                    }
                    jobNameIndexColumn = this.columnsIndex.get("insert_job");
                    calendarIndexColumn = this.columnsIndex.get("run_calendar");
                    ownerIndexColumn = this.columnsIndex.get("owner");
                    agentIndexColumn = this.columnsIndex.get("machine");
                    jobTypeIndexColumn = this.columnsIndex.get("job_type");
                    commandIndexColumn = this.columnsIndex.get("command");
                    boxNameIndexColumn = this.columnsIndex.get("box_name");
                    excludeCalendarIndexColumn = this.columnsIndex.get("exclude_calendar");
                    boxSuccessIndexColumn = this.columnsIndex.get("box_success");
                    boxFailureIndexColumn = this.columnsIndex.get("box_failure");
                    columnsRow = false;
                    continue;
                }
                this.dataMatrix.add(reader.getValues());
                this.jobNameIndex.put(reader.getValues()[jobNameIndexColumn], this.rowsCount);
                ArrayList<String> calendarJobsList = this.calendarJobs.get(reader.getValues()[calendarIndexColumn]);
                if (null == calendarJobsList) {
                    calendarJobsList = new ArrayList();
                }
                calendarJobsList.add(reader.getValues()[jobNameIndexColumn]);
                if (!reader.getValues()[calendarIndexColumn].equalsIgnoreCase("NULL")) {
                    this.calendarJobs.put(reader.getValues()[calendarIndexColumn], calendarJobsList);
                }
                if (null == (excludeCalendarJobsList = this.excludeCalendarJobs.get(reader.getValues()[excludeCalendarIndexColumn]))) {
                    excludeCalendarJobsList = new ArrayList();
                }
                excludeCalendarJobsList.add(reader.getValues()[jobNameIndexColumn]);
                if (!reader.getValues()[excludeCalendarIndexColumn].equalsIgnoreCase("NULL")) {
                    this.excludeCalendarJobs.put(reader.getValues()[excludeCalendarIndexColumn], excludeCalendarJobsList);
                }
                if (null == (ownerJobsList = this.ownerJobs.get(reader.getValues()[ownerIndexColumn]))) {
                    ownerJobsList = new ArrayList();
                }
                ownerJobsList.add(reader.getValues()[jobNameIndexColumn]);
                if (!reader.getValues()[ownerIndexColumn].equalsIgnoreCase("NULL")) {
                    this.ownerJobs.put(reader.getValues()[ownerIndexColumn], ownerJobsList);
                }
                if (null == (agentJobsList = this.agentJobs.get(reader.getValues()[agentIndexColumn]))) {
                    agentJobsList = new ArrayList();
                }
                agentJobsList.add(reader.getValues()[jobNameIndexColumn]);
                if (!reader.getValues()[agentIndexColumn].equalsIgnoreCase("NULL")) {
                    this.agentJobs.put(reader.getValues()[agentIndexColumn], agentJobsList);
                }
                if (!reader.getValues()[commandIndexColumn].equalsIgnoreCase("NULL")) {
                    String[] cmdStrings;
                    for (String cmdString : cmdStrings = reader.getValues()[commandIndexColumn].split("\\ ")) {
                        if (cmdString.endsWith(JOB_SAP_TYPE_SUFFIX)) {
                            this.sapJobs.add(reader.getValues()[jobNameIndexColumn]);
                            break;
                        }
                        if (!cmdString.endsWith(JOB_PSFT_TYPE_SUFFIX)) continue;
                        this.psftJobs.add(reader.getValues()[jobNameIndexColumn]);
                        break;
                    }
                    String[] commandString = reader.getValues()[commandIndexColumn].split("[ /\"']+");
                    boolean bBreak = false;
                    for (String autoSysName : autoSysMngr.getAllAutoSysKeys()) {
                        for (String s : commandString) {
                            if (!s.equalsIgnoreCase(autoSysName)) continue;
                            ArrayList<String> autoSysJobsList = this.autoSysJobs.get(autoSysName);
                            if (null == autoSysJobsList) {
                                autoSysJobsList = new ArrayList();
                            }
                            autoSysJobsList.add(reader.getValues()[jobNameIndexColumn]);
                            this.autoSysJobs.put(autoSysName, autoSysJobsList);
                            bBreak = true;
                            break;
                        }
                        if (!bBreak) continue;
                        break;
                    }
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("ftp") || reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("scp")) {
                    this.ftpJobs.add(reader.getValues()[jobNameIndexColumn]);
                } else if (reader.getValues()[jobTypeIndexColumn].toLowerCase().startsWith("f")) {
                    this.fileWatcherJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("sapjc")) {
                    this.sapR3CopyJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("sap")) {
                    this.sapR3CreateJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("sapbwpc")) {
                    this.sapBwJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("sql")) {
                    this.sqlJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("dbproc")) {
                    this.storedProcedureJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("omtf")) {
                    this.omtfJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("i5")) {
                    this.os400Jobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("zos")) {
                    this.zosJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].equalsIgnoreCase("http")) {
                    this.httpJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (!AutosysGlobals.SUPPORTED_JOB_TYPES.contains(AutosysDefs.getPrefixType(reader.getValues()[jobTypeIndexColumn]))) {
                    this.unsupportedJobTypes.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (!reader.getValues()[boxSuccessIndexColumn].equalsIgnoreCase("NULL") || !reader.getValues()[boxFailureIndexColumn].equalsIgnoreCase("NULL")) {
                    this.boxSuccessFailureJobs.add(reader.getValues()[jobNameIndexColumn]);
                }
                if (reader.getValues()[jobTypeIndexColumn].toLowerCase().startsWith("b")) {
                    boolean nestedBox = false;
                    if (!reader.getValues()[boxNameIndexColumn].equalsIgnoreCase("NULL")) {
                        nestedBox = true;
                    }
                    if (!nestedBox) {
                        tempBox = new SourceDataBox(reader.getValues()[jobNameIndexColumn]);
                        this.boxes.put(reader.getValues()[jobNameIndexColumn], tempBox);
                        this.levelOneBoxes.add(tempBox);
                    } else {
                        for (SourceDataBox level1Box : this.levelOneBoxes) {
                            SourceDataBox tempParentBox = level1Box.getBoxByName(reader.getValues()[boxNameIndexColumn]);
                            if (null == tempParentBox) continue;
                            tempBox = new SourceDataBox(reader.getValues()[jobNameIndexColumn]);
                            tempParentBox.AddBoxToList(tempBox);
                            break;
                        }
                    }
                } else if (!reader.getValues()[boxNameIndexColumn].equalsIgnoreCase("NULL")) {
                    for (SourceDataBox level1Box : this.levelOneBoxes) {
                        tempBox = level1Box.getBoxByName(reader.getValues()[boxNameIndexColumn]);
                        if (null == tempBox) continue;
                        tempBox.AddJobToList(reader.getValues()[jobNameIndexColumn]);
                        break;
                    }
                    ++this.jobsInsideBoxesCount;
                }
                ++this.rowsCount;
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading csv file: " + String.valueOf(e) + " at line : " + this.rowsCount));
        }
    }

    public List<String> getAllZOSJobNames() {
        return this.zosJobs;
    }

    public List<String> getAllHTTPJobNames() {
        return this.httpJobs;
    }
}

