/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.SourceDataReportCSVReader;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseFilteredTree;
import com.bmc.ctmconvert.base.BaseListCellRenderer;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseSplitPane;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDataBox;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class SourceDataPanel
extends BasePanel
implements ActionListener,
TreeSelectionListener {
    private SourceDataReportCSVReader m_SDReport = null;
    private JTextArea m_jobsInfoAreaText = null;
    private JList m_jobsSelectingList = null;
    private String m_treeNodeParentName = "";
    private static final String m_newline = System.getProperty("line.separator");
    private boolean m_bJobNodeView = false;
    private boolean m_bJobAreaIncreased = false;
    private static final String m_sJobs = "Jobs";
    private static final String m_sCalendars = "Calendars";
    private static final String m_sOwners = "Owners";
    private static final String m_sAgents = "Agents";
    private static final String m_sAutoSys = "AutosysUtilitiesJobs";
    private static final String m_sExcludeCalendars = "Exclude Calendars";
    private static final String m_sFileWatcher = "File Watcher";
    private static final String m_sFTP = "FileTransfer";
    private static final String m_sBoxSuccessFailure = "Box Success/Failure";
    private static final String m_sSAPJobs = "SAP Jobs";
    private static final String m_sPsftJobs = "PeopleSoft Jobs";
    private static final String m_sNA = "N\\A";
    private static final String m_sOMTF = "OMTF Jobs";
    private static final String m_i5Jobs = "ISeries Jobs";
    private static final String m_sZOS = "ZOS Jobs";
    private static final String m_http = "HTTP Jobs";
    private int m_counterCalendarsJobs = 0;
    private int m_counterExcludeCalendarsJobs = 0;
    private int m_counterOwnersJobs = 0;
    private int m_counterAgentsJobs = 0;
    private int m_counterAutoSysJobs = 0;
    private int m_counterBoxes = 0;
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private HashMap<String, String> m_NodeName_EntityCount = new HashMap();
    private HashMap<String, String> m_NodeName_InfluenceCount = new HashMap();
    private Map<String, String> m_nodeName_nodeDescription;
    private static final int m_LowMachinesThreshold = 25;
    private int m_iLowMachinesUse;
    private List<String> m_listNamesOflowMachinesUse = new ArrayList<String>();
    private BaseSplitPane mainSplitPane;
    private BaseSplitPane rightHandSplitPane;
    private BaseFilteredTree mainTree;
    private static final String SAP_R3_COPY_JOBS_TITLE = "Sap R3 Copy jobs";
    private static final String SAP_R3_CREATE_JOBS_TITLE = "Sap R3 Create jobs";
    private static final String SAP_BW_COPY_JOBS_TITLE = "Sap Business Warehouse jobs";
    private static final String SQL_JOBS_TITLE = "SQL jobs";
    private static final String STORED_PROCEDURE_TITLE = "SQL Stored Procedure jobs";
    private static final String OMTF_JOBS_TITLE = "Text File Reading and Monitoring jobs";
    private static final String i5_JOBS_TITLE = "ISeries jobs";
    private static final String ZOS_JOBS_TITLE = "ZOS Jobs";
    private static final String HTTP_JOBS_TITLE = "HTTP Jobs";
    private static final String UNSUPPORTED_JOB_TYPES_TITLE = "UnSupported job types";

    public SourceDataPanel(String fileName, String descriptionXMLFileName) {
        this.init(fileName, descriptionXMLFileName);
    }

    private void init(String fileName, String descriptionXMLFileName) {
        this.m_SDReport = new SourceDataReportCSVReader(fileName);
        this.createTreePanel();
        this.createRightHandPanel();
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.m_nodeName_nodeDescription = this.getDescriptionNodes();
        this.mainTree.setSelectionRow(0);
        this.updateRightHandPanel();
        this.baseContentPanel = new BaseContentPanel();
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.CLOSE}));
        this.mainSplitPane = new BaseSplitPane(1, this.mainTree.getComponent(), this.rightHandSplitPane.getComponent());
        this.baseContentPanel.setContentPanel((BaseComponent)this.mainSplitPane);
        this.setContentPanel(this.baseContentPanel);
    }

    private void createRightHandPanel() {
        this.rightHandSplitPane = new BaseSplitPane(0);
        this.increaseJobsInfoArea();
    }

    private void updateRightHandPanel() {
        if (null != this.m_jobsSelectingList) {
            JScrollPane selectionList = new JScrollPane(this.m_jobsSelectingList);
            selectionList.setBorder(null);
            this.rightHandSplitPane.setComponent((Component)selectionList, BaseSplitPane.ComponentPosition.TOP);
        } else {
            this.rightHandSplitPane.setComponent(null, BaseSplitPane.ComponentPosition.TOP);
        }
        if (null != this.m_jobsInfoAreaText) {
            JScrollPane jobInfo = new JScrollPane(this.m_jobsInfoAreaText);
            jobInfo.setBorder(null);
            this.rightHandSplitPane.setComponent((Component)jobInfo, BaseSplitPane.ComponentPosition.BOTTOM);
            this.m_jobsInfoAreaText.setSelectionStart(0);
            this.m_jobsInfoAreaText.setSelectionEnd(0);
        } else {
            this.rightHandSplitPane.setComponent(null, BaseSplitPane.ComponentPosition.BOTTOM);
        }
    }

    private void updateJobsInfoArea(String messageID, boolean clearJobsInfoArea) {
        StringBuilder formatedData = new StringBuilder();
        if (!clearJobsInfoArea) {
            String[] columns = this.m_SDReport.getColumnsHeaders();
            String[] jobInfo = this.m_SDReport.getJobInfo(messageID);
            for (int i = 1; i < columns.length; ++i) {
                if (jobInfo[i].equalsIgnoreCase("NULL")) continue;
                formatedData.append(columns[i]);
                formatedData.append(" : ");
                formatedData.append(jobInfo[i]);
                formatedData.append(m_newline);
            }
        }
        this.m_jobsInfoAreaText.setText(formatedData.toString());
        this.m_jobsInfoAreaText.setSelectionStart(0);
        this.m_jobsInfoAreaText.setSelectionEnd(0);
    }

    private void setDescriptionArea(String sDescription) {
        if (null != sDescription) {
            if (!sDescription.isEmpty()) {
                if (null == this.m_jobsInfoAreaText) {
                    this.m_jobsInfoAreaText = new JTextArea();
                    this.m_jobsInfoAreaText.setEditable(false);
                    this.m_jobsInfoAreaText.setBackground(Color.WHITE);
                }
                this.m_jobsInfoAreaText.setText(sDescription);
            } else if (null != this.m_jobsInfoAreaText) {
                this.m_jobsInfoAreaText = null;
            }
        } else if (null != this.m_jobsInfoAreaText) {
            this.m_jobsInfoAreaText.setText("");
        }
        this.updateRightHandPanel();
    }

    private void decreaseJobsInfoArea() {
        if (null != this.m_jobsInfoAreaText) {
            this.m_jobsInfoAreaText.removeAll();
            this.m_jobsInfoAreaText = null;
        }
        this.m_jobsInfoAreaText = new JTextArea();
        this.m_jobsInfoAreaText.setEditable(false);
        this.m_jobsInfoAreaText.setBackground(Color.WHITE);
        if (null != this.m_jobsSelectingList) {
            this.m_jobsSelectingList.removeAll();
            this.m_jobsSelectingList = null;
        }
        this.m_jobsSelectingList = new JList();
        this.m_jobsSelectingList.setCellRenderer(new BaseListCellRenderer());
        this.m_jobsSelectingList.setFixedCellHeight(20);
        this.m_jobsSelectingList.setSelectionMode(0);
        this.m_jobsSelectingList.addListSelectionListener(e -> {
            JList jListSource = (JList)e.getSource();
            List selection = jListSource.getSelectedValuesList();
            if (!e.getValueIsAdjusting()) {
                for (Object o : selection) {
                    this.updateJobsInfoArea((String)o, false);
                }
            }
        });
        this.updateRightHandPanel();
    }

    private void increaseJobsInfoArea() {
        if (null != this.m_jobsSelectingList) {
            this.m_jobsSelectingList = null;
        }
        this.updateRightHandPanel();
    }

    private void updateListArea(String parentID, String messageID, boolean clearList) {
        String nodeName;
        String[] nodeInfo = messageID.split("\\(");
        String string = nodeName = nodeInfo.length == 2 ? nodeInfo[0] : this.splitString(messageID);
        if (clearList) {
            this.m_jobsSelectingList.removeAll();
            this.m_jobsSelectingList.setModel(new DefaultListModel());
        } else {
            List<String> allJobs = null;
            this.m_jobsSelectingList.removeAll();
            if (!(parentID.startsWith(m_sFTP) || parentID.startsWith(m_sJobs) || parentID.startsWith(m_sFileWatcher) || parentID.startsWith(m_sBoxSuccessFailure) || parentID.startsWith(m_sSAPJobs) || parentID.startsWith(m_sOMTF) || parentID.startsWith(m_i5Jobs) || parentID.startsWith("ZOS Jobs") || parentID.startsWith("HTTP Jobs"))) {
                if (parentID.startsWith(m_sCalendars)) {
                    allJobs = this.m_SDReport.getCalendarsJobsNames(nodeName);
                } else if (parentID.startsWith(m_sOwners)) {
                    allJobs = this.m_SDReport.getOwnersJobsNames(nodeName);
                } else if (parentID.startsWith(m_sAgents)) {
                    allJobs = this.m_SDReport.getAgentsJobsNames(nodeName);
                } else if (parentID.startsWith(m_sAutoSys)) {
                    allJobs = this.m_SDReport.getAutoSysJobsNames(nodeName);
                } else if (parentID.startsWith(m_sExcludeCalendars)) {
                    allJobs = this.m_SDReport.getExcludeCalendarsJobsNames(nodeName);
                }
            }
            if (null != allJobs) {
                this.m_jobsSelectingList.setListData(allJobs.toArray());
            }
        }
        this.m_jobsSelectingList.updateUI();
    }

    private void createTreePanel() {
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode node = null;
        StringBuilder nodeName = new StringBuilder();
        DefaultMutableTreeNode jobsNodes = new DefaultMutableTreeNode("Jobs(" + this.m_SDReport.getJobsNumber() + ")");
        this.m_NodeName_EntityCount.put(m_sJobs, Integer.toString(this.m_SDReport.getJobsNumber()));
        this.m_NodeName_InfluenceCount.put(m_sJobs, Integer.toString(this.m_SDReport.getJobsNumber()));
        TreeSet<String> boxesList = new TreeSet<String>(this.m_SDReport.getBoxesList());
        for (String boxName : boxesList) {
            jobsNodes.add(this.getBoxSubTree(this.m_SDReport.getBoxByName(boxName)));
        }
        List<String> jobsList = this.m_SDReport.getAllJobsNames();
        if (jobsList != null) {
            Collections.sort(jobsList);
            for (String jobName : jobsList) {
                node = new DefaultMutableTreeNode(jobName);
                jobsNodes.add(node);
            }
        }
        mainTreeNodes.add(jobsNodes);
        this.getNodeFor(this.m_SDReport.getAllFileWatcherJobsNames(), m_sFileWatcher).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllFtpJobsNames(), m_sFTP).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllBoxSuccessFailureJobsNames(), m_sBoxSuccessFailure).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllSAPJobsNames(), m_sSAPJobs).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllPsftJobsNames(), m_sPsftJobs).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllSapR3CopyJobNames(), SAP_R3_COPY_JOBS_TITLE).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllSapR3CreateJobNames(), SAP_R3_CREATE_JOBS_TITLE).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllSapBwJobNames(), SAP_BW_COPY_JOBS_TITLE).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllSQLJobNames(), SQL_JOBS_TITLE).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllStoredProcedureJobs(), STORED_PROCEDURE_TITLE).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllOMTFJobNames(), OMTF_JOBS_TITLE).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllOS400JobNames(), i5_JOBS_TITLE).ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllZOSJobNames(), "ZOS Jobs").ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getAllHTTPJobNames(), "HTTP Jobs").ifPresent(mainTreeNodes::add);
        this.getNodeFor(this.m_SDReport.getUnsupportedJobTypes(), UNSUPPORTED_JOB_TYPES_TITLE).ifPresent(mainTreeNodes::add);
        this.getCalendarNodes(nodeName).ifPresent(mainTreeNodes::add);
        this.getExcludeCalendarNodes(nodeName).ifPresent(mainTreeNodes::add);
        this.getOwnersNodes(nodeName).ifPresent(mainTreeNodes::add);
        this.getAgentsNodes(nodeName).ifPresent(mainTreeNodes::add);
        this.getAllAutosys(nodeName).ifPresent(mainTreeNodes::add);
        this.mainTree = new BaseFilteredTree(mainTreeNodes);
        this.mainTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    private Optional<DefaultMutableTreeNode> getAllAutosys(StringBuilder nodeName) {
        DefaultMutableTreeNode autoSysNodes = null;
        TreeSet<String> autoSysList = new TreeSet<String>(this.m_SDReport.getAutoSysList());
        if (!autoSysList.isEmpty()) {
            autoSysNodes = new DefaultMutableTreeNode("AutosysUtilitiesJobs(" + autoSysList.size() + ")");
            this.m_NodeName_EntityCount.put(m_sAutoSys, Integer.toString(autoSysList.size()));
            for (String autoSys : autoSysList) {
                nodeName.delete(0, nodeName.length());
                nodeName.append(autoSys);
                nodeName.append("(");
                nodeName.append(this.m_SDReport.getAutoSysJobsNames(autoSys).size());
                this.m_counterAutoSysJobs += this.m_SDReport.getAutoSysJobsNames(autoSys).size();
                nodeName.append(")");
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeName.toString());
                autoSysNodes.add(node);
            }
        }
        this.m_NodeName_InfluenceCount.put(m_sAutoSys, Integer.toString(this.m_counterAutoSysJobs));
        return Optional.ofNullable(autoSysNodes);
    }

    private Optional<DefaultMutableTreeNode> getAgentsNodes(StringBuilder nodeName) {
        DefaultMutableTreeNode agentsNodes = null;
        TreeSet<String> agentsList = new TreeSet<String>(this.m_SDReport.getAgentsList());
        if (!agentsList.isEmpty()) {
            agentsNodes = new DefaultMutableTreeNode("Agents(" + agentsList.size() + ")");
            this.m_NodeName_EntityCount.put(m_sAgents, Integer.toString(agentsList.size()));
            for (String agent : agentsList) {
                nodeName.delete(0, nodeName.length());
                nodeName.append(agent);
                nodeName.append("(");
                nodeName.append(this.m_SDReport.getAgentsJobsNames(agent).size());
                this.m_counterAgentsJobs += this.m_SDReport.getAgentsJobsNames(agent).size();
                nodeName.append(")");
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeName.toString());
                agentsNodes.add(node);
                if (this.m_SDReport.getAgentsJobsNames(agent).size() > 25) continue;
                this.m_listNamesOflowMachinesUse.add(agent);
                ++this.m_iLowMachinesUse;
            }
        }
        this.m_NodeName_InfluenceCount.put(m_sAgents, Integer.toString(this.m_counterAgentsJobs));
        return Optional.ofNullable(agentsNodes);
    }

    private Optional<DefaultMutableTreeNode> getOwnersNodes(StringBuilder nodeName) {
        TreeSet<String> ownersList = new TreeSet<String>(this.m_SDReport.getOwnersList());
        DefaultMutableTreeNode result = null;
        if (!ownersList.isEmpty()) {
            result = new DefaultMutableTreeNode("Owners(" + ownersList.size() + ")");
            this.m_NodeName_EntityCount.put(m_sOwners, Integer.toString(ownersList.size()));
            for (String owner : ownersList) {
                nodeName.delete(0, nodeName.length());
                nodeName.append(owner);
                nodeName.append("(");
                nodeName.append(this.m_SDReport.getOwnersJobsNames(owner).size());
                this.m_counterOwnersJobs += this.m_SDReport.getOwnersJobsNames(owner).size();
                nodeName.append(")");
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeName.toString());
                result.add(node);
            }
        }
        this.m_NodeName_InfluenceCount.put(m_sOwners, Integer.toString(this.m_counterOwnersJobs));
        return Optional.ofNullable(result);
    }

    private Optional<DefaultMutableTreeNode> getExcludeCalendarNodes(StringBuilder nodeName) {
        DefaultMutableTreeNode excludeCalendarNodes = null;
        TreeSet<String> excludeCalendarsList = new TreeSet<String>(this.m_SDReport.getExcludeCalendarsList());
        if (!excludeCalendarsList.isEmpty()) {
            excludeCalendarNodes = new DefaultMutableTreeNode("Exclude Calendars(" + excludeCalendarsList.size() + ")");
            this.m_NodeName_EntityCount.put(m_sExcludeCalendars, Integer.toString(excludeCalendarsList.size()));
            for (String calendar : excludeCalendarsList) {
                nodeName.delete(0, nodeName.length());
                nodeName.append(calendar);
                nodeName.append("(");
                nodeName.append(this.m_SDReport.getExcludeCalendarsJobsNames(calendar).size());
                this.m_counterExcludeCalendarsJobs += this.m_SDReport.getExcludeCalendarsJobsNames(calendar).size();
                nodeName.append(")");
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeName.toString());
                excludeCalendarNodes.add(node);
            }
        }
        this.m_NodeName_InfluenceCount.put(m_sExcludeCalendars, Integer.toString(this.m_counterExcludeCalendarsJobs));
        return Optional.ofNullable(excludeCalendarNodes);
    }

    private Optional<DefaultMutableTreeNode> getCalendarNodes(StringBuilder nodeName) {
        DefaultMutableTreeNode calendarsNodes = null;
        TreeSet<String> calendarsList = new TreeSet<String>(this.m_SDReport.getCalendarsList());
        if (!calendarsList.isEmpty()) {
            calendarsNodes = new DefaultMutableTreeNode("Calendars(" + calendarsList.size() + ")");
            this.m_NodeName_EntityCount.put(m_sCalendars, Integer.toString(calendarsList.size()));
            for (String calendar : calendarsList) {
                nodeName.delete(0, nodeName.length());
                nodeName.append(calendar);
                nodeName.append("(");
                nodeName.append(this.m_SDReport.getCalendarsJobsNames(calendar).size());
                this.m_counterCalendarsJobs += this.m_SDReport.getCalendarsJobsNames(calendar).size();
                nodeName.append(")");
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeName.toString());
                calendarsNodes.add(node);
            }
        }
        this.m_NodeName_InfluenceCount.put(m_sCalendars, Integer.toString(this.m_counterCalendarsJobs));
        return Optional.ofNullable(calendarsNodes);
    }

    private Optional<DefaultMutableTreeNode> getNodeFor(List<String> jobNames, String title) {
        DefaultMutableTreeNode nodes = null;
        if (!jobNames.isEmpty()) {
            Collections.sort(jobNames);
            nodes = new DefaultMutableTreeNode(title + "(" + jobNames.size() + ")");
            this.m_NodeName_EntityCount.put(title, Integer.toString(jobNames.size()));
            for (String jobName : jobNames) {
                nodes.add(new DefaultMutableTreeNode(jobName));
            }
        }
        return Optional.ofNullable(nodes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        int level;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.mainTree.getLastSelectedPathComponent();
        this.m_treeNodeParentName = "";
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        String sNodeParent = "";
        DefaultMutableTreeNode nodeParent = null;
        DefaultMutableTreeNode chosenNode = node;
        if (!node.isRoot()) {
            while (null != node.getParent()) {
                nodeParent = node;
                node = (DefaultMutableTreeNode)node.getParent();
            }
            sNodeParent = ((Object)nodeParent).toString();
        }
        if ((level = chosenNode.getLevel()) <= 1) {
            this.increaseJobsInfoArea();
            this.m_bJobAreaIncreased = true;
            String description = chosenNode.toString().split("\\(")[0];
            this.setDescriptionArea(this.m_nodeName_nodeDescription.get(description));
        } else {
            boolean bl = this.m_bJobNodeView = sNodeParent.startsWith(m_sJobs) || sNodeParent.startsWith(m_sFTP) || sNodeParent.startsWith(m_sFileWatcher) || sNodeParent.startsWith(m_sBoxSuccessFailure) || sNodeParent.startsWith(m_sSAPJobs) || sNodeParent.startsWith(m_sPsftJobs) || sNodeParent.startsWith(SAP_R3_COPY_JOBS_TITLE) || sNodeParent.startsWith(SAP_R3_CREATE_JOBS_TITLE) || sNodeParent.startsWith(SAP_BW_COPY_JOBS_TITLE) || sNodeParent.startsWith(SQL_JOBS_TITLE) || sNodeParent.startsWith(STORED_PROCEDURE_TITLE) || sNodeParent.startsWith(OMTF_JOBS_TITLE) || sNodeParent.startsWith(i5_JOBS_TITLE) || sNodeParent.startsWith("ZOS Jobs") || sNodeParent.startsWith("HTTP Jobs") || sNodeParent.startsWith(UNSUPPORTED_JOB_TYPES_TITLE) || chosenNode.toString().equalsIgnoreCase(m_sNA);
            if (chosenNode.isLeaf()) {
                this.m_treeNodeParentName = sNodeParent;
                if (!this.m_bJobNodeView) {
                    if (this.m_bJobAreaIncreased) {
                        this.decreaseJobsInfoArea();
                        this.m_bJobAreaIncreased = false;
                    }
                    this.updateListArea(this.m_treeNodeParentName, nodeInfo.toString(), false);
                    this.updateJobsInfoArea(nodeInfo.toString(), true);
                } else {
                    if (!this.m_bJobAreaIncreased) {
                        this.increaseJobsInfoArea();
                        this.m_bJobAreaIncreased = true;
                    }
                    if (nodeInfo.toString().endsWith("(0)")) {
                        String[] sNodeInfo = nodeInfo.toString().split("\\(");
                        String nodeName = sNodeInfo.length == 2 ? sNodeInfo[0] : this.splitString(nodeInfo.toString());
                        this.updateJobsInfoArea(nodeName, false);
                    } else {
                        this.updateJobsInfoArea(nodeInfo.toString(), chosenNode.toString().equalsIgnoreCase(m_sNA));
                    }
                }
            } else if (!this.m_bJobNodeView) {
                if (this.m_bJobAreaIncreased) {
                    this.decreaseJobsInfoArea();
                    this.m_bJobAreaIncreased = false;
                }
                this.updateListArea(this.m_treeNodeParentName, nodeInfo.toString(), true);
                this.updateJobsInfoArea(nodeInfo.toString(), true);
            } else {
                if (!this.m_bJobAreaIncreased) {
                    this.increaseJobsInfoArea();
                    this.m_bJobAreaIncreased = true;
                }
                if (chosenNode.toString().equals(sNodeParent)) {
                    this.updateJobsInfoArea(nodeInfo.toString(), true);
                } else {
                    String[] sNodeInfo = nodeInfo.toString().split("\\(");
                    String nodeName = sNodeInfo.length == 2 ? sNodeInfo[0] : this.splitString(nodeInfo.toString());
                    this.updateJobsInfoArea(nodeName, false);
                }
            }
        }
        if (this.m_jobsSelectingList != null) {
            this.m_jobsSelectingList.setSelectedIndex(0);
        }
    }

    public DefaultMutableTreeNode getBoxSubTree(SourceDataBox box) {
        ArrayList jobs;
        ++this.m_counterBoxes;
        if (box.size() <= 0) {
            DefaultMutableTreeNode boxNode = new DefaultMutableTreeNode(box.getBoxName() + "(0)");
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode(m_sNA);
            boxNode.add(temp);
            return boxNode;
        }
        DefaultMutableTreeNode boxNode = new DefaultMutableTreeNode(box.getBoxName() + "(" + box.size() + ")");
        ArrayList boxes = box.getBoxesList();
        if (null != boxes) {
            for (SourceDataBox tempBox : boxes) {
                boxNode.add(this.getBoxSubTree(tempBox));
            }
        }
        if (null != (jobs = box.getJobsList())) {
            for (String job : jobs) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(job);
                boxNode.add(node);
            }
        }
        return boxNode;
    }

    public String splitString(String inSTR) {
        StringTokenizer st = new StringTokenizer(inSTR, "\\(\\)", true);
        StringBuilder sNodeInfo = new StringBuilder();
        String[] tempArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tempArray[i] = st.nextToken();
            ++i;
        }
        for (i = 0; i < tempArray.length - 3; ++i) {
            sNodeInfo.append(tempArray[i]);
        }
        return sNodeInfo.toString();
    }

    protected Map<String, String> getDescriptionNodes() {
        String sMainSummary;
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("Summary:");
        mainSummary.append(m_newline);
        mainSummary.append(m_newline);
        String extraSummary = null;
        for (String nodeName : descriptionMap_NodeName_NodeDesc.keySet()) {
            if (this.m_DescriptionXMLReader.isAutoBuildMainSummary() && nodeName.compareToIgnoreCase("MainSummary") != 0) {
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = (String)descriptionMap_NodeName_NodeDesc.get(nodeName);
                } else {
                    mainSummary.append(nodeName);
                    mainSummary.append(m_newline);
                    mainSummary.append(this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
                    mainSummary.append(m_newline);
                    mainSummary.append(m_newline);
                }
            }
            descriptionMap_NodeName_NodeDesc.put(nodeName, this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
        }
        if (null != extraSummary) {
            mainSummary.append("ExtraSummary");
            mainSummary.append(m_newline);
            mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", extraSummary));
            mainSummary.append(m_newline);
            mainSummary.append(m_newline);
        }
        if (!this.m_DescriptionXMLReader.isAutoBuildMainSummary() && null != (sMainSummary = (String)descriptionMap_NodeName_NodeDesc.get("MainSummary"))) {
            mainSummary.append(sMainSummary);
            String sExtraSummary = (String)descriptionMap_NodeName_NodeDesc.get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append(m_newline);
                mainSummary.append(m_newline);
                mainSummary.append("ExtraSummary");
                mainSummary.append(m_newline);
                mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary));
                mainSummary.append(m_newline);
            }
        }
        descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName_NodeDesc;
    }

    public String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (!sDescription.contains("#")) {
            return sDescription;
        }
        String sNum = null;
        sNum = this.m_NodeName_EntityCount.get(sNodeName);
        if (null == sNum) {
            sNum = "0";
        }
        sDescription = sDescription.replace("#NUM_ENTITIES#", sNum);
        sNum = this.m_NodeName_InfluenceCount.get(sNodeName);
        if (null == sNum) {
            sNum = "0";
        }
        sDescription = sDescription.replace("#NUM_INFL_JOB#", sNum);
        sDescription = sDescription.replace("#NUM_TABLES#", Integer.toString(this.m_counterBoxes));
        sDescription = sDescription.replace("#ENV_NAME#", Params.instance().getDatasourceName());
        if ((sDescription = sDescription.replace("#NUM_LOW_USED_MACHINES#", Integer.toString(this.m_iLowMachinesUse))).contains("#NUM_LOW_USED_MACHINES_LIST#")) {
            StringBuilder machinesList = new StringBuilder();
            Collections.sort(this.m_listNamesOflowMachinesUse);
            for (String machine : this.m_listNamesOflowMachinesUse) {
                machinesList.append(machine);
                machinesList.append(m_newline);
            }
            sDescription = sDescription.replace("#NUM_LOW_USED_MACHINES_LIST#", machinesList.toString());
        }
        return sDescription;
    }

    public void navegationActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            this.fireNavegationEvent(actionCommand);
        }
    }
}

