/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.Jil;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Jil2Csv {
    private String lastAttribute;
    private final BaseProgressBar progressBar;
    private static final String JIL_ATTR_REGEX = String.join((CharSequence)"|", List.of("alarm_if_fail", "alarm_if_terminated", "auto_delete", "auto_hold", "avg_runtime", "box_failure", "box_name", "box_success", "box_terminator", "chk_files", "command", "condition", "date_conditions", "days_of_week", "delete_box", "delete_job", "description", "exclude_calendar", "heartbeat_interval", "insert_job", "job_load", "resources", "job_terminator", "job_type", "machine", "max_exit_success", "max_run_alarm", "min_run_alarm", "must_start_times", "must_complete_times", "n_retrys", "override_job", "owner", "permission", "priority", "profile", "run_calendar", "run_window", "start_mins", "start_times", "std_err_file", "std_in_file", "std_out_file", "term_run_time", "timezone", "update_job", "watch_file", "watch_file_min_size", "watch_interval", "group", "application", "notification_msg", "send_notification", "notification_emailaddress", "notification_id", "envvars", "success_codes", "ftp_transfer_type", "ftp_local_name", "ftp_remote_name", "ftp_server_name", "ftp_transfer_direction", "ftp_local_user", "scp_transfer_direction", "scp_local_name", "scp_remote_dir", "scp_remote_name", "scp_server_name", "scp_local_user", "scp_target_os", "sap_job_name", "sap_job_count", "sap_release_option", "sap_mon_child", "sap_chain_id", "sql_command", "connect_string", "destination_file", "sp_name", "sap_step_parms", "text_file_name", "text_file_mode", "monitor_mode", "text_file_filter", "upper_boundary", "lower_boundary", "text_file_filter_exists", "notification_emailaddress_on_success", "notification_emailaddress_on_failure", "i5_action", "RUN_PROGRAM", "RUN_PROG_IN_FILE", "COMMAND", "i5_name", "i5_cc_exit", "i5_curr_lib", "i5_job_name", "i5_job_queue", "i5_job_desc", "i5_lda", "i5_lib", "i5_library_list", "i5_others", "i5_params", "i5_process_priority", "jcl_member", "jcl_library", "provider_url", "invocation_type"));
    private final List<String> jilAttrArray = new ArrayList<String>(Arrays.asList("ID", "insert_job", "alarm_if_fail", "alarm_if_terminated", "application", "auto_delete", "auto_hold", "avg_runtime", "box_failure", "box_name", "box_success", "box_terminator", "chk_files", "command", "condition", "date_conditions", "days_of_week", "delete_box", "delete_job", "description", "exclude_calendar", "group", "heartbeat_interval", "job_load", "resources", "job_terminator", "job_type", "machine", "max_exit_success", "max_run_alarm", "min_run_alarm", "must_start_times", "must_complete_times", "n_retrys", "override_job", "owner", "permission", "priority", "profile", "run_calendar", "run_window", "start_mins", "start_times", "std_err_file", "std_in_file", "std_out_file", "term_run_time", "timezone", "update_job", "watch_file", "watch_file_min_size", "watch_interval", "notification_msg", "send_notification", "envvars", "success_codes", "ftp_transfer_type", "ftp_local_name", "ftp_remote_name", "ftp_server_name", "ftp_transfer_direction", "ftp_local_user", "scp_transfer_direction", "scp_local_name", "scp_remote_dir", "scp_remote_name", "scp_server_name", "scp_local_user", "scp_target_os", "sap_job_name", "sap_job_count", "sap_release_option", "sap_mon_child", "sap_chain_id", "sql_command", "connect_string", "destination_file", "sp_name", "sap_step_parms", "text_file_name", "text_file_mode", "monitor_mode", "text_file_filter", "upper_boundary", "lower_boundary", "text_file_filter_exists", "notification_emailaddress_on_success", "notification_emailaddress_on_failure", "i5_action", "RUN_PROGRAM", "RUN_PROG_IN_FILE", "COMMAND", "i5_name", "i5_cc_exit", "i5_curr_lib", "i5_job_name", "i5_job_queue", "i5_job_desc", "i5_lda", "i5_lib", "i5_library_list", "i5_others", "i5_params", "i5_process_priority", "jcl_member", "jcl_library", "provider_url", "invocation_type"));
    private static final Pattern ALL_ATTRIBUTES_PATTERN = Pattern.compile("\\s*(?:(" + JIL_ATTR_REGEX + ")\\s*:\\s*)((?:\".*?(?<!\\\\)\")?(?:(?:(?!(?:(?:" + JIL_ATTR_REGEX + ")\\s*:\\s*)).)*))(.*)");
    private static final Pattern MULTI_LINE_PATTERN = Pattern.compile("((?:\\s*\".*?(?<!\\\\)\")?(?:(?:(?!(?:(?:" + JIL_ATTR_REGEX + ")\\s*:\\s*)).)*))(.*)");
    private final List<Jil> jilEntries = new ArrayList<Jil>();
    private int mailCount = 1;
    private int idCount = 1;
    private int maxMailColumns = 0;
    private int maxIdColumns = 0;
    private final BufferedReader inputBufferedRead;
    private final OutputStream outputStream;

    public Jil2Csv(InputStream inputStream, OutputStream outputStream, BaseProgressBar pb) {
        this.outputStream = outputStream;
        this.progressBar = pb;
        this.inputBufferedRead = new BufferedReader(new InputStreamReader(inputStream));
    }

    public boolean convert2CSV() throws ConvertorCancelClickException {
        if (this.initJilEntries()) {
            return this.createCSV();
        }
        return false;
    }

    private boolean createCSV() throws ConvertorCancelClickException {
        try {
            CsvWriter csvWriter = new CsvWriter((Writer)new OutputStreamWriter(this.outputStream), ',');
            csvWriter.writeRecord((String[])this.jilAttrArray.toArray(String[]::new));
            for (int i = 0; i < this.jilEntries.size(); ++i) {
                if (this.progressBar != null && this.progressBar.getTask().isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                String[] csvRecord = new String[this.jilAttrArray.size()];
                csvRecord[0] = Integer.toString(i);
                for (int j = 1; j < this.jilAttrArray.size(); ++j) {
                    String key = this.jilAttrArray.get(j);
                    String value = this.jilEntries.get(i).getValue(key);
                    if (value == null) {
                        value = "NULL";
                    }
                    csvRecord[j] = value = value.replace("\\:", ":");
                }
                csvWriter.writeRecord(csvRecord);
            }
            csvWriter.close();
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initJilEntries() throws ConvertorCancelClickException {
        try {
            String line;
            Jil tmpJilEntry = new Jil();
            int jobsCounter = 0;
            while ((line = this.inputBufferedRead.readLine()) != null) {
                String startingNewEntityToken = "insert_job";
                if (line.trim().startsWith(startingNewEntityToken)) {
                    this.mailCount = 1;
                    this.idCount = 1;
                    this.lastAttribute = null;
                    if (this.progressBar != null) {
                        this.progressBar.setProgressValue(jobsCounter);
                    }
                    if (!tmpJilEntry.getJobDefinition().isEmpty()) {
                        this.jilEntries.add(tmpJilEntry);
                        tmpJilEntry = new Jil();
                        ++jobsCounter;
                    }
                }
                if (!line.isEmpty() && !line.trim().startsWith("/*")) {
                    this.updateJilEntry(tmpJilEntry, line);
                }
                if (this.progressBar == null || !this.progressBar.isCancelled()) continue;
                throw new ConvertorCancelClickException();
            }
            if (!tmpJilEntry.getJobDefinition().isEmpty()) {
                this.jilEntries.add(tmpJilEntry);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.inputBufferedRead.close();
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(e.getMessage());
            }
        }
    }

    private void updateJilEntry(Jil jilEntry, String line) {
        Matcher matcher = ALL_ATTRIBUTES_PATTERN.matcher(line);
        if (matcher.matches()) {
            String attr;
            this.lastAttribute = attr = matcher.group(1);
            String value = matcher.group(2);
            if (attr != null && !attr.isEmpty()) {
                if (attr.equalsIgnoreCase("notification_emailaddress") || attr.equalsIgnoreCase("notification_id")) {
                    this.addMailAddress(jilEntry, value, attr);
                } else if (attr.equalsIgnoreCase("i5_params")) {
                    this.updateParam(jilEntry, "i5_params", ",", value);
                } else if (attr.equalsIgnoreCase("condition")) {
                    this.updateParam(jilEntry, "condition", " ", value);
                } else if (attr.equalsIgnoreCase("envvars")) {
                    this.updateParam(jilEntry, "envvars", ",", value);
                } else if (!this.isMultiLineAttribute(attr)) {
                    jilEntry.getJobDefinition().put(attr, value.trim());
                } else {
                    jilEntry.getJobDefinition().put(attr, value);
                }
            } else {
                ConversionLogger.getLogger().info(() -> "Line is not valid: " + line);
            }
            String rest = matcher.group(3);
            if (rest != null && !rest.isEmpty()) {
                this.updateJilEntry(jilEntry, rest);
            }
        } else if (!this.handleMultipleLines(jilEntry, line)) {
            ConversionLogger.getLogger().info(() -> "Line does not match expression: " + line);
        }
    }

    private boolean handleMultipleLines(Jil jilEntry, String line) {
        Matcher matcher;
        if (this.isMultiLineAttribute(this.lastAttribute) && (matcher = MULTI_LINE_PATTERN.matcher(line)).matches()) {
            String val = matcher.group(1);
            jilEntry.getJobDefinition().compute(this.lastAttribute, (k, value) -> value + val);
            String rest = matcher.group(2);
            if (rest != null && !rest.isEmpty()) {
                this.updateJilEntry(jilEntry, rest);
            }
            return true;
        }
        return false;
    }

    private boolean isMultiLineAttribute(String attribute) {
        return "Command".equalsIgnoreCase(attribute) || "condition".equalsIgnoreCase(attribute);
    }

    private void addMailAddress(Jil jilEntry, String value, String emailType) {
        if (emailType.equalsIgnoreCase("notification_emailaddress")) {
            String mailName = "notification_emailaddress" + this.mailCount;
            if (this.mailCount > this.maxMailColumns) {
                this.maxMailColumns = this.mailCount;
                this.jilAttrArray.add(mailName);
            }
            ++this.mailCount;
            jilEntry.getJobDefinition().put(mailName, value.trim());
        } else {
            this.addIdAddress(jilEntry, value);
        }
    }

    private void updateParam(Jil jilEntry, String paramName, String separator, String newValue) {
        jilEntry.getJobDefinition().compute(paramName, (k, oldValue) -> oldValue == null ? newValue.trim() : oldValue.concat(separator).concat(newValue.trim()));
    }

    private void addIdAddress(Jil jilEntry, String value) {
        String idName = "notification_id" + this.idCount;
        if (this.idCount > this.maxIdColumns) {
            this.maxIdColumns = this.idCount;
            this.jilAttrArray.add(idName);
        }
        ++this.idCount;
        jilEntry.getJobDefinition().put(idName, value.trim());
    }
}

