/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.IJobTypeConvertor;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class FileTransferConvertor
implements IJobTypeConvertor {
    protected AutosysJob autosysJob;
    protected Map<String, String> jobAttr;
    protected IAttrHolder sourceAttr;
    protected LinkedHashMap<String, String> autoedits;

    protected FileTransferConvertor(AutosysJob autosysJob) {
        this.autosysJob = autosysJob;
        this.jobAttr = this.autosysJob.getJobAttr();
        this.sourceAttr = this.autosysJob.getSourceAttr();
        this.autoedits = this.autosysJob.getAutoedits();
    }

    @Override
    public void convert() {
        this.addFileTransferDefaultAttribute();
        this.addFileTransferDefaultVariables();
    }

    protected void addFileTransferDefaultVariables() {
        this.autoedits.put("%%FTP-TYPE1", "I");
        this.autoedits.put("%%FTP-PATH", "Not in use for application jobs");
        this.autoedits.put("%%FTP-LPASSIVE", "0");
        this.autoedits.put("%%FTP-RPASSIVE", "0");
        this.autoedits.put("%%FTP-UPLOAD1", "1");
        this.autoedits.put("%%FTP-TIMELIMIT_UNIT1", "1");
        this.autoedits.put("%%FTP-TIMELIMIT1", "0");
        this.autoedits.put("%%FTP-ABSTIME1", "0");
        this.autoedits.put("%%FTP-OVERRIDE_WATCH_INTERVAL1", "0");
        this.autoedits.put("%%FTP-WATCH_INTERVAL1", "30");
        this.autoedits.put("%%FTP-IF_EXIST1", "0");
        this.autoedits.put("%%FTP-DSTOPT1", "0");
        this.autoedits.put("%%FTP-UNIQUE1", "0");
        this.autoedits.put("%%FTP-TRIM1", "1");
        this.autoedits.put("%%FTP-FLDS1", "0");
        this.autoedits.put("%%FTP-VERNUM1", "0");
        this.autoedits.put("%%FTP-EXCLUDE_WILDCARD1", "0");
        this.autoedits.put("%%FTP-CASEIFS1", "0");
        this.autoedits.put("%%FTP-TRANSFER_NUM", "1");
        this.autoedits.put("%%FTP-CONT_EXE_NOTOK", "0");
        this.autoedits.put("%%FTP-RPF", "0");
        this.autoedits.put("%%FTP-USE_DEF_NUMRETRIES", "0");
        this.autoedits.put("%%FTP-NUM_RETRIES", "5");
        this.autoedits.put("%%FTP-Is", "5");
        this.autoedits.put("%%FTP-AUTOREFRESH", "False");
    }

    protected void addFileTransferDefaultAttribute() {
        this.jobAttr.put("TASKTYPE", this.getTaskType());
        this.jobAttr.put("APPL_FORM", "AFT");
        this.jobAttr.put("APPL_TYPE", "FILE_TRANS");
        this.jobAttr.put("APPL_VER", "6.1.01");
        this.jobAttr.put("CM_VER", "610");
    }

    private String getTaskType() {
        if (this.autosysJob.getRules().getTaskTypeHandler().isToDummy()) {
            return "Dummy";
        }
        return "Job";
    }

    protected void checkAndInsertAutoedit(String filed, String attr) {
        if (!attr.equals("NULL")) {
            this.autoedits.put(filed, this.resolveAutosysVariables(attr));
        }
    }

    protected String converteToLegalCP(String localUser, String serverName) {
        return localUser + "_TO_" + serverName;
    }

    protected String getDirection(String directionAttribute) {
        String direction = this.sourceAttr.getAttr(directionAttribute);
        if ("DOWNLOAD".equals(direction)) {
            direction = "0";
        } else if ("UPLOAD".equals(direction)) {
            direction = "1";
        }
        return direction;
    }

    private String resolveAutosysVariables(String withVariable) {
        return this.autosysJob.getHandleBuiltinAutoEdits().handle(withVariable);
    }
}

