/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Dependency {
    private final String rawDependency;
    private String outJob;
    private String inJob;
    private String condType;
    private String condModifier;
    private String paren = null;
    private String orAnd = "AND";
    public boolean isValid = true;
    private static final String TYPES_SUB_EXPR = "(success|s|f|fail|failure|e|exitcode|d|done|n|notrunning|t|terminated|v|value)";
    private static final String CONDITION_TYPES_SUB_EXPR = "(success|s|f|fail|failure|d|done|n|notrunning|t|terminated|)";
    private static final String OPS_SUB_EXPR = "([<>=!][=]?)";
    public static final String CONDITION_DEPENDENCY_PATTERN = "[()\t ]*(success|s|f|fail|failure|d|done|n|notrunning|t|terminated|)[ \t]*\\(([^)]+)(.*)";
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("[\\(\\)\t ]*(success|s|f|fail|failure|e|exitcode|d|done|n|notrunning|t|terminated|v|value)[ \t]*\\(([^\\)]+)(.*)", 2);
    private static final Pattern EVERYTHING_IN_PARENTS_PATTERN = Pattern.compile(".*\\(([^\\(\\)]+)\\).*");
    private static final Pattern LOOK_BACK_DEP_COMMA_TIME_PATTERN = Pattern.compile(".* *, *([0-9]+[.:])([0-9]+[.:]?)+");
    private static final Pattern LOOK_BACK_DEP_COMMA_ZERO_PATTERN = Pattern.compile(".* *, *([0-9])+");
    private static final Pattern COND_MODIFIER_PATTERN = Pattern.compile(".*\\)\\s*([<>=!][=]?)\\s*(\\d+).*");

    public Dependency(String autosysDependencyType) {
        this.rawDependency = autosysDependencyType;
        Matcher matcher = DEPENDENCY_PATTERN.matcher(autosysDependencyType);
        if (matcher.matches()) {
            this.condType = matcher.group(1).toLowerCase();
            this.outJob = matcher.group(2).trim();
            this.condModifier = matcher.group(3);
        } else {
            this.isValid = false;
            matcher = EVERYTHING_IN_PARENTS_PATTERN.matcher(autosysDependencyType);
            if (matcher.matches()) {
                this.outJob = matcher.group(1);
            } else {
                return;
            }
        }
        int openCount = autosysDependencyType.length() - autosysDependencyType.replaceAll("\\(", "").length();
        int closeCount = autosysDependencyType.length() - autosysDependencyType.replaceAll("\\)", "").length();
        if (openCount > closeCount) {
            this.paren = "(";
        }
        if (openCount < closeCount) {
            this.paren = ")";
        }
    }

    public String getDepName(RulesDataSet rules) {
        String stringRule = rules.getStringRule("Autosys rules", new String[]{"ConvertToFormat"});
        boolean currentFormat = stringRule.equals("{Job/Folder Name}-TO-{TargetJob:Job/Folder Name}");
        String toRet = currentFormat ? String.format("%s-TO-%s", this.getOutJob(), this.inJob) : this.jobEndedFormat();
        return toRet;
    }

    private String jobEndedFormat() {
        String toRet = null;
        if (this.condType.matches("\\s*(not ?running|n)\\s*")) {
            toRet = this.getOutJob();
        } else if (this.condType.matches("\\s*(success|s)\\s*")) {
            toRet = String.format("%s_ENDED_OK", this.getOutJob());
        } else if (this.condType.matches("\\s*(fail|failure|f|terminated|t)\\s*")) {
            toRet = String.format("%s_ENDED_NOTOK", this.getOutJob());
        } else if (this.condType.matches("\\s*(done|d)\\s*")) {
            toRet = String.format("%s_DONE", this.getOutJob());
        } else if (this.condType.matches("\\s*(exitcode|e)\\s*")) {
            toRet = this.generateCompStatCode().replace("COMPSTAT", this.getOutJob() + "_EXIT").replace(" ", "_");
        }
        return toRet;
    }

    public String getOutJob() {
        if (this.isLookbackDep()) {
            return this.outJob.substring(0, this.outJob.lastIndexOf(44));
        }
        ValueVariableResolver valueVariableResolver = new ValueVariableResolver(this.rawDependency);
        if (valueVariableResolver.isValueVariable()) {
            return valueVariableResolver.getName();
        }
        return this.outJob;
    }

    public Pair<String, String> getLookBackDetails() {
        Pattern lookBackPattern = Pattern.compile("(?<name>[^,]+),(?<lookBack>[^)]+)");
        Matcher matcher = lookBackPattern.matcher(this.outJob);
        if (matcher.find()) {
            String name = matcher.group("name");
            String lookBack = matcher.group("lookBack");
            return new Pair((Object)name, (Object)lookBack);
        }
        return new Pair((Object)"", (Object)"");
    }

    public boolean isLookbackDep() {
        return this.outJob != null && (LOOK_BACK_DEP_COMMA_TIME_PATTERN.matcher(this.outJob).matches() || LOOK_BACK_DEP_COMMA_ZERO_PATTERN.matcher(this.outJob).matches());
    }

    public Dependency setInJob(String inJob) {
        this.inJob = inJob.trim();
        return this;
    }

    public String getInJob() {
        return this.inJob;
    }

    public void setCondType(String condType) {
        this.condType = condType;
    }

    public String getCondType() {
        return this.condType;
    }

    public String getParen() {
        return this.paren;
    }

    public void setOrAnd(String orAnd) {
        this.orAnd = orAnd;
    }

    public String getOrAnd() {
        return this.orAnd;
    }

    public String generateCompStatCode() {
        Object result = "Invalid condition used by " + this.inJob;
        if (this.condType.matches("\\s*(exitcode|e)\\s*")) {
            Matcher matcher = COND_MODIFIER_PATTERN.matcher(this.condModifier);
            if (matcher.matches()) {
                String value = matcher.group(2);
                if (value == null || value.isEmpty()) {
                    this.isValid = false;
                } else {
                    value = value.trim();
                    String operator = matcher.group(1);
                    switch (operator = operator.trim()) {
                        case "=": {
                            operator = "EQ";
                            break;
                        }
                        case "!=": {
                            operator = "NE";
                            break;
                        }
                        case ">": {
                            operator = "GT";
                            break;
                        }
                        case "<": {
                            operator = "LT";
                            break;
                        }
                        case ">=": {
                            int intVal = Integer.parseInt(value);
                            value = Integer.toString(--intVal);
                            operator = "GT";
                            break;
                        }
                        case "<=": {
                            int intVal = Integer.parseInt(value);
                            value = Integer.toString(++intVal);
                            operator = "LT";
                        }
                    }
                    result = String.format("COMPSTAT %s %s", operator, value);
                }
            } else {
                this.isValid = false;
            }
        } else if (this.condType.matches("\\s*(done|d)\\s*")) {
            result = "NOTOK";
        } else if (this.condType.matches("\\s*(fail|failure|f|terminated|t)\\s*")) {
            result = "NOTOK";
        }
        return result;
    }

    public void handleCrossInstanceCond(Map<String, List<String>> jobMessages, Map<String, List<Map<String, String>>> jobActions) {
        int splitIndex = this.outJob.indexOf(94);
        if (splitIndex < 0) {
            return;
        }
        if (this.inJob == null || this.inJob.isEmpty()) {
            return;
        }
        String name = this.outJob.substring(0, splitIndex);
        if (!this.condType.matches("\\s*(not ?running|n)\\s*")) {
            if (!jobMessages.containsKey(this.inJob)) {
                jobMessages.put(this.inJob, new ArrayList());
            }
            Reporter.addMessage(jobMessages.get(this.inJob), (String)"INF4006", (String)this.inJob, (String[])new String[]{this.outJob, name});
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "GLOBALCOND");
            action.put("JOBID", this.inJob);
            action.put("ACTENTNAME", name);
            action.put("ACTENTQTY", "0");
            action.put("ACTSTATUS", "0");
            this.addJobAction(this.inJob, action, jobActions);
        }
        this.outJob = name;
    }

    private void addJobAction(String key, Map<String, String> action, Map<String, List<Map<String, String>>> jobActions) {
        jobActions.computeIfAbsent(key, k -> new ArrayList());
        jobActions.get(key).add(action);
    }

    private static class ValueVariableResolver {
        private static final Pattern VALUE_CONDITION_PATTERN = Pattern.compile("(v|value|VALUE|V)\\(\\s*(?<variableName>[^)]+)\\)\\s*(?<operator>!=|=|<=|>=|<|>)\\s*(?<variableValue>.*)$");
        private final Matcher conditionMatcher;

        public ValueVariableResolver(String condition) {
            this.conditionMatcher = VALUE_CONDITION_PATTERN.matcher(condition);
        }

        public boolean isValueVariable() {
            return this.conditionMatcher.find();
        }

        public String getName() {
            String variableName = this.conditionMatcher.group("variableName");
            Optional<String> operator = this.convertOperator(this.conditionMatcher.group("operator"));
            String variableValue = GlobalFunctions.removeQuotesIfNeeded((String)this.conditionMatcher.group("variableValue"));
            return operator.map(op -> String.format("%s-%s-%s", variableName, op, variableValue)).orElse(String.format("%s-%s", variableName, variableValue));
        }

        private Optional<String> convertOperator(String operator) {
            String convertedValue = switch (operator) {
                case "!=" -> "not";
                case ">=" -> "gte";
                case "<=" -> "lte";
                case "<" -> "lt";
                case ">" -> "gt";
                default -> null;
            };
            return Optional.ofNullable(convertedValue);
        }
    }
}

