/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.Jil2Csv;
import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FileFunctions;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.streamutils.InputStreamGetter;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataImportAutosys
extends DataImportVendor {
    public static final String CA_AUTOSYS_DESCRIPTION = "CA_AUTOSYS_DESCRIPTION";
    private final BaseBrowseTextField jobDefinitions;
    private final BaseBrowseTextField timeZoneDefinitions;
    private final BaseBrowseTextField calendarDefinitions;
    private final BaseBrowseTextField extendedCalendarDefinitions;
    private final BaseBrowseTextField globalVariablesDefinitions;

    public DataImportAutosys() {
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("CAPTURE_DATA_TITLE_IMPORT_AUTOSYS")), new BaseFooterPanel(""));
        BaseSection section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA"));
        this.jobDefinitions = new BaseBrowseTextField(new String[]{"JIL"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
        String desc = String.format(TextManager.instance().get(CA_AUTOSYS_DESCRIPTION), "(.Jil)", "\"autorep -j ALL -q\"", Params.instance().getVendorName());
        section.addField(new BaseField((BaseComponent)this.jobDefinitions, TextManager.instance().get("CAPTURE_DATA_FIELD_AUTOSYS_JOB_DEFINITIONS"), true, desc));
        this.timeZoneDefinitions = new BaseBrowseTextField(new String[]{"TZO"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        desc = String.format(TextManager.instance().get(CA_AUTOSYS_DESCRIPTION), "Time Zone", "\"autotimezone -l\"", Params.instance().getVendorName());
        section.addField(new BaseField((BaseComponent)this.timeZoneDefinitions, TextManager.instance().get("FIELD_AUTOSYS_TIME_ZONE_DEFINITIONS"), false, desc));
        this.calendarDefinitions = new BaseBrowseTextField(new String[]{"CAL"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        desc = String.format(TextManager.instance().get(CA_AUTOSYS_DESCRIPTION), "Calendar", "\"autocal_asc -E autosys.STANDARD_CAL -s ALL\"", Params.instance().getVendorName());
        BaseField calendarField = new BaseField((BaseComponent)this.calendarDefinitions, TextManager.instance().get("FIELD_AUTOSYS_CALENDAR_DEFINITIONS"), false, desc);
        calendarField.setTooltip("Select the file that contains CA Autosys calendar definitions (optional).");
        section.addField(calendarField);
        this.extendedCalendarDefinitions = new BaseBrowseTextField(new String[]{"CAL"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        desc = String.format(TextManager.instance().get(CA_AUTOSYS_DESCRIPTION), "Extended calendar", "\"autocal_asc -E extended.CAL -e ALL\"", Params.instance().getVendorName());
        section.addField(new BaseField((BaseComponent)this.extendedCalendarDefinitions, TextManager.instance().get("FIELD_AUTOSYS_EXTENDED_CALENDAR_DEFINITIONS"), false, desc));
        this.globalVariablesDefinitions = new BaseBrowseTextField(new String[]{"txt"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        desc = String.format(TextManager.instance().get(CA_AUTOSYS_DESCRIPTION), "Global Variables", "\"autorep -G ALL\"", Params.instance().getVendorName());
        section.addField(new BaseField((BaseComponent)this.globalVariablesDefinitions, TextManager.instance().get("FIELD_AUTOSYS_GLOBAL_VARIABLES_DEFINITIONS"), false, desc));
        this.importPanel.addSection(section);
        this.importPanel.buildContentPanel();
    }

    public BaseContentPanel getNextPanel() {
        return this.importPanel;
    }

    public Component getDefaultFocusedComponent() {
        return this.jobDefinitions.getComponent();
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        return DataImportAutosys.staticDataImport(destinationFolderPath, this.jobDefinitions.getText(), this.timeZoneDefinitions.getText(), this.calendarDefinitions.getText(), this.extendedCalendarDefinitions.getText(), this.globalVariablesDefinitions.getText(), progressBar);
    }

    public static FlowGlobals.COMPLETION_MODE staticDataImport(String destinationFolderPath, String jobDefinitionsFolderPath, String timeZoneDefinitionsFolderPath, String calendarDefinitionsFolderPath, String extendedCalDefinitionsFolderPath, String globalVariablesDefinitions, BaseProgressBar progressBar) {
        boolean success;
        FlowGlobals.COMPLETION_MODE failure;
        if (progressBar != null) {
            progressBar.setLabel(TextManager.instance().get("AUTOSYS_PROGRESS_BAR_IMPORTING_DATA_FILES"));
        }
        if ((failure = DataImportAutosys.copyInputFiles(destinationFolderPath, jobDefinitionsFolderPath, timeZoneDefinitionsFolderPath, calendarDefinitionsFolderPath, extendedCalDefinitionsFolderPath, globalVariablesDefinitions)) != FlowGlobals.COMPLETION_MODE.SUCCESS) {
            return failure;
        }
        if (progressBar != null) {
            progressBar.setLabel(TextManager.instance().get("AUTOSYS_PROGRESS_BAR_PROCESSING_JILL_FILE"));
        }
        InputStreamGetter getter = new InputStreamGetter();
        Path pathInputStream = Paths.get(jobDefinitionsFolderPath, new String[0]);
        BufferedReader inputBufferedReader = new BufferedReader(new InputStreamReader(getter.getInputStream(pathInputStream)));
        InputStream inputStream = getter.getInputStream(pathInputStream);
        Path pathoutputStream = Paths.get(destinationFolderPath + "jil.csv", new String[0]);
        OutputStream outputStream = null;
        try {
            outputStream = Files.newOutputStream(pathoutputStream, new OpenOption[0]);
        }
        catch (IOException e1) {
            ConversionLogger.getLogger().info(e1.getMessage());
        }
        if (progressBar != null) {
            int totalJobs = 0;
            try {
                totalJobs = DataImportAutosys.getHowManyWords(inputBufferedReader);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(e.getMessage());
            }
            progressBar.setProgressMax(totalJobs);
        }
        Jil2Csv j2csv = new Jil2Csv(inputStream, outputStream, progressBar);
        try {
            success = j2csv.convert2CSV();
        }
        catch (ConvertorCancelClickException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            return FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(e.getMessage());
            }
        }
        return success ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    private static FlowGlobals.COMPLETION_MODE copyInputFiles(String destinationFolderPath, String jobDefinitionsFolderPath, String timeZoneDefinitionsFolderPath, String calendarDefinitionsFolderPath, String extendedCalDefinitionsFolderPath, String globalVariablesDefinitions) {
        try {
            DataImportAutosys.copyInputFileToProjectWorkspace(timeZoneDefinitionsFolderPath, destinationFolderPath, "AutosysTz.TZO");
            DataImportAutosys.copyInputFileToProjectWorkspace(calendarDefinitionsFolderPath, destinationFolderPath, "AutosysCalendars.CAL");
            DataImportAutosys.copyInputFileToProjectWorkspace(extendedCalDefinitionsFolderPath, destinationFolderPath, "ExtendedCalendars.CAL");
            DataImportAutosys.copyInputFileToProjectWorkspace(jobDefinitionsFolderPath, destinationFolderPath, "AutosysJil.JIL");
            DataImportAutosys.copyInputFileToProjectWorkspace(globalVariablesDefinitions, destinationFolderPath, "GlobalVariables.txt");
        }
        catch (IOException exception) {
            return FlowGlobals.COMPLETION_MODE.FAILURE;
        }
        return FlowGlobals.COMPLETION_MODE.SUCCESS;
    }

    private static void copyInputFileToProjectWorkspace(String inputFileName, String destinationFolderPath, String targetFileName) throws IOException {
        File inputFile = new File(inputFileName);
        if (!inputFile.getName().isEmpty()) {
            File destTzFile = new File(destinationFolderPath + targetFileName);
            try {
                FileFunctions.copyFile((File)inputFile, (File)destTzFile);
            }
            catch (IOException e) {
                ProcessAlertsManager.instance().addMessage(String.format("Failed to copy %s to %s", inputFile, destTzFile));
                throw e;
            }
        }
    }

    public String getHelpTitle() {
        return "LOAD_DATA_AUTOSYS";
    }

    public String getFieldsData() {
        return Stream.of(this.jobDefinitions, this.timeZoneDefinitions, this.calendarDefinitions, this.extendedCalendarDefinitions, this.globalVariablesDefinitions).map(item -> item.getComponent().getName() + "=" + item.getText()).collect(Collectors.joining("\n"));
    }

    private static int getHowManyWords(BufferedReader inputBufferedReader) throws IOException {
        String line;
        int cnt = 0;
        while ((line = inputBufferedReader.readLine()) != null) {
            if (!line.trim().startsWith("insert_job")) continue;
            ++cnt;
        }
        return cnt;
    }
}

