/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;

public class CyclicDecider {
    private String version;
    private boolean startMinsUsed;
    private boolean startTimesUsed;
    private String startTimes;
    private SchedEntity.TYPE m_type;
    private String startMins;
    private ArrayList<String> m_messages;
    private String m_jobName;

    public CyclicDecider(IAttrHolder m_sourceAttr, RulesDataSet m_rules, SchedEntity.TYPE m_type, String version, ArrayList<String> m_messages, String m_jobName) {
        boolean schedCondsUsed;
        this.version = version;
        this.m_type = m_type;
        this.m_messages = m_messages;
        this.m_jobName = m_jobName;
        String dateConds = m_sourceAttr.getAttr("date_conditions");
        boolean bl = schedCondsUsed = dateConds.equals("1") || dateConds.equalsIgnoreCase("YES") || dateConds.equalsIgnoreCase("Y");
        if (m_rules.getBooleanRule("Autosys rules", new String[]{"ON_DEMAND_UDLY"}).booleanValue()) {
            schedCondsUsed = true;
        }
        this.startMins = m_sourceAttr.getAttr("start_mins");
        this.startTimes = m_sourceAttr.getAttr("start_times");
        this.startMinsUsed = !this.startMins.equals("NULL") && !this.startMins.isEmpty();
        this.startTimesUsed = !this.startTimes.equals("NULL") && !this.startTimes.isEmpty();
        this.startMinsUsed = this.startMinsUsed && schedCondsUsed;
        this.startTimesUsed = this.startTimesUsed && schedCondsUsed;
    }

    public boolean couldEntityBeConvertedAsCyclic() {
        if (!this.startMinsUsed && !this.startTimesUsed) {
            return false;
        }
        if (this.isNonComptableEntity() && this.isCyclic()) {
            return false;
        }
        return !this.startMinsUsed || !this.startTimesUsed;
    }

    private boolean isNonComptableEntity() {
        boolean cyclicFolderSupported = Integer.valueOf(this.version) >= Integer.valueOf("18");
        return !cyclicFolderSupported && this.m_type != SchedEntity.TYPE.JOB || cyclicFolderSupported && this.m_type != SchedEntity.TYPE.JOB && this.m_type != SchedEntity.TYPE.SMART_TABLE;
    }

    private boolean isCyclic() {
        return this.startMinsUsed || this.startTimes.replaceAll("[ \t\"]+", "").split(",").length > 1;
    }

    public boolean startTimesUsed() {
        return this.startTimesUsed;
    }

    public boolean startMinsUsed() {
        return this.startMinsUsed;
    }

    public void issueMessages() {
        this.issueIncometiblEentityMessage();
        this.issuejobUsesStartTimeAndStartMinsMessage();
    }

    private void issueIncometiblEentityMessage() {
        if (this.isNonComptableEntity() && this.isCyclic()) {
            boolean cyclicFolderSupported;
            Object msgAttr = this.startMinsUsed ? "start_mins" : "";
            msgAttr = (String)msgAttr + (this.startTimesUsed() && this.startMinsUsed() ? " or " : "");
            msgAttr = (String)msgAttr + (this.startTimesUsed() ? "start_times" : "");
            boolean bl = cyclicFolderSupported = Integer.valueOf(this.version) >= Integer.valueOf("18");
            if (cyclicFolderSupported) {
                Reporter.addMessage(this.m_messages, (String)"WRN4051", (String)this.m_jobName, (String[])new String[]{msgAttr, this.m_jobName});
            } else {
                Reporter.addMessage(this.m_messages, (String)"WRN4006", (String)this.m_jobName, (String[])new String[]{msgAttr, this.m_jobName});
            }
        }
    }

    private void issuejobUsesStartTimeAndStartMinsMessage() {
        if (this.startMinsUsed() && this.startTimesUsed()) {
            Reporter.addMessage(this.m_messages, (String)"WRN4004", (String)this.m_jobName, (String[])new String[]{"start_mins", this.startMins, "start_times", this.startTimes});
        }
    }
}

