/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutosysUtilities {
    private static final Pattern sendeventPattern = Pattern.compile("^.*?sendevent\\s+-E\\s+SET_GLOBAL\\s+-G\\s+.*", 2);

    public static boolean isUtilityNameExistsInCommand(String utilityName, String command) {
        return AutosysUtilities.isSendEventGlobalVariable().negate().and(AutosysUtilities.hasUtilityName(utilityName)).test(command);
    }

    private static Predicate<String> isSendEventGlobalVariable() {
        return command -> {
            Matcher matcher = sendeventPattern.matcher((CharSequence)command);
            return matcher.matches();
        };
    }

    private static Predicate<String> hasUtilityName(String utilityName) {
        return command -> {
            String patternString = "(.*[^\\w./}]|\\s*)(" + utilityName + ")[^\\w/.{].*";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher((CharSequence)command);
            return matcher.matches();
        };
    }

    private static String replaceSendEventWithCtmvar(String command) {
        Pattern pattern = Pattern.compile("(?<command>sendevent\\s+-E\\s+SET_GLOBAL\\s+-G\\s+\"?)(?<variableName>[^=]+)\\s*=\\s*(?<variableValue>([^\"]+\"?)|([^`]+))", 2);
        Matcher matcher = pattern.matcher(command);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String name = matcher.group("variableName").trim();
            String value = matcher.group("variableValue").trim().replaceAll("\"$", "").trim();
            String replacement = "ctmvar -ACTION set -VAR %%\\" + name + " -VAREXPR " + value;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        String result = sb.toString();
        return result.contains("ctmvar -ACTION set") ? result : command;
    }

    public static String convertUtilities(String command) {
        if (AutosysUtilities.isSendEventGlobalVariable().test(command)) {
            return AutosysUtilities.replaceSendEventWithCtmvar(command);
        }
        return command;
    }
}

