/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.Arrays;

public class AutosysSchedulingUtils {
    private static final String[] weekDaysAutosysName = new String[]{"su", "mo", "tu", "we", "th", "fr", "sa"};
    private static final String[] weekDaysCMName = new String[]{"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
    public static final String CALENDARS_SEPARATOR = ";";
    public static final String CALENDARS_COLON = ":";
    private IAttrHolder entity;

    public AutosysSchedulingUtils(IAttrHolder entity) {
        this.entity = entity;
    }

    public String getDaysOfWeekAsNumber() {
        if (this.hasAllDaysOfWeek() || !this.hasDaysOfWeek() || this.noSchedulingSettings()) {
            return "ALL";
        }
        boolean[] daysOfWeek = this.getDaysOfWeek();
        String retVal = "";
        for (int i = 0; i < daysOfWeek.length; ++i) {
            if (!daysOfWeek[i]) continue;
            retVal = retVal.concat((retVal.isEmpty() ? "" : ",") + i);
        }
        return retVal;
    }

    public String getDaysOfWeekByName() {
        if (this.hasAllDaysOfWeek() || !this.hasDaysOfWeek() || this.noSchedulingSettings()) {
            return "ALL";
        }
        boolean[] daysOfWeek = this.getDaysOfWeek();
        String retVal = "";
        for (int i = 0; i < daysOfWeek.length; ++i) {
            if (!daysOfWeek[i]) continue;
            retVal = retVal.concat((retVal.isEmpty() ? "" : "_") + weekDaysCMName[i]);
        }
        return retVal;
    }

    private boolean[] getDaysOfWeek() {
        boolean[] toRet = new boolean[7];
        Arrays.fill(toRet, false);
        String daysOfWeek = this.entity.getAttr("days_of_week");
        for (int i = 0; i < toRet.length; ++i) {
            if (!this.doesStringContainThisDay(daysOfWeek, weekDaysAutosysName[i])) continue;
            toRet[i] = true;
        }
        return toRet;
    }

    public boolean doesStringContainThisDay(String string, String day) {
        String expr = String.format("(^%s.*|.+[, \t]+%s.*)", day, day);
        return string.matches(expr);
    }

    public boolean isDateConditions() {
        String dateConds = this.entity.getAttr("date_conditions").trim();
        return !this.isNullValue(dateConds) && (dateConds.equals("1") || dateConds.equalsIgnoreCase("Y") || dateConds.equalsIgnoreCase("YES"));
    }

    private boolean isNullValue(String attrValue) {
        return attrValue.equals("NULL");
    }

    public boolean hasAllDaysOfWeek() {
        String weekDays = this.entity.getAttr("days_of_week");
        boolean[] days = this.getDaysOfWeek();
        boolean[] alldays = new boolean[days.length];
        Arrays.fill(alldays, true);
        return weekDays.equalsIgnoreCase("all") || Arrays.equals(days, alldays);
    }

    public boolean hasExcludeCalendar() {
        String excludeCal = this.entity.getAttr("exclude_calendar");
        return !excludeCal.equals("NULL") && !excludeCal.isEmpty();
    }

    public String getExcludeCalendar() {
        String excludeCal = "";
        if (this.hasExcludeCalendar()) {
            excludeCal = this.entity.getAttr("exclude_calendar");
        }
        return excludeCal;
    }

    public boolean hasRunCalendar() {
        String runCal = this.entity.getAttr("run_calendar");
        return !runCal.equals("NULL") && !runCal.isEmpty();
    }

    public String getRunCalendar() {
        String runCal = "";
        if (this.hasRunCalendar()) {
            runCal = this.entity.getAttr("run_calendar");
        }
        return runCal;
    }

    public boolean hasDaysOfWeek() {
        String weekdays = this.entity.getAttr("days_of_week");
        return !weekdays.equals("NULL") && !weekdays.isEmpty();
    }

    public void setEntity(IAttrHolder entity) {
        this.entity = entity;
    }

    public boolean noSchedulingSettings() {
        return !this.hasDaysOfWeek() && !this.hasExcludeCalendar() && !this.hasRunCalendar();
    }

    private String getDaysStringID() {
        if (this.hasAllDaysOfWeek() || this.noSchedulingSettings()) {
            return "ALL";
        }
        boolean[] days = this.getDaysOfWeek();
        Object id = "";
        for (int i = 0; i < days.length; ++i) {
            id = (String)id + (days[i] ? "1" : "0");
        }
        return id;
    }

    private String appendSchedulingTagID(String tagsId, String schedulingTag) {
        String retval = tagsId + (tagsId.isEmpty() ? "" : CALENDARS_SEPARATOR);
        return retval + schedulingTag;
    }

    public String getSchedulingSettingsIdString() {
        boolean notStandaloneFolder;
        boolean bl = notStandaloneFolder = !this.entity.getAttr("box_name").equals("StandaloneJobs");
        if (notStandaloneFolder && AutosysSchedulingUtils.isTopLevelBox(this.entity) && this.noSchedulingSettings()) {
            return "NONE";
        }
        Object ret = "";
        if (this.hasDaysOfWeek()) {
            ret = "days_of_week:" + this.getDaysStringID();
        }
        if (this.isDateConditions()) {
            if (this.hasExcludeCalendar()) {
                if (!this.hasRunCalendar() && !this.hasDaysOfWeek()) {
                    ret = AutosysSchedulingUtils.isBox(this.entity) ? "days_of_week:ALL" : "use_parent:*";
                }
                ret = this.appendSchedulingTagID((String)ret, "exclude_calendar:" + this.getExcludeCalendar());
            }
            if (this.hasRunCalendar()) {
                ret = this.appendSchedulingTagID((String)ret, "run_calendar:" + this.getRunCalendar());
            }
        }
        return ret;
    }

    public static boolean isBox(IAttrHolder entity) {
        String jobType = AutosysDefs.getAutosysJobType(entity);
        return jobType.equalsIgnoreCase("b");
    }

    public static boolean isTopLevelBox(IAttrHolder entity) {
        return AutosysSchedulingUtils.isBox(entity) && AutosysSchedulingUtils.isTopLevel(entity);
    }

    private static boolean isTopLevel(IAttrHolder entity) {
        return "NULL".equals(entity.getAttr("box_name"));
    }

    public String toString() {
        StringBuilder str = new StringBuilder("entity: " + this.entity.getAttr("insert_job") + " Scheduling Settings: ");
        if (this.noSchedulingSettings()) {
            return str.append("NULL").toString();
        }
        if (this.hasDaysOfWeek()) {
            str.append("days_of_week: " + this.getDaysStringID() + " ");
        }
        if (this.hasRunCalendar()) {
            str.append("run_calendar: " + this.getRunCalendar() + " ");
        }
        if (this.hasExcludeCalendar()) {
            str.append("exclude_calendar: " + this.getExcludeCalendar());
        }
        return str.toString();
    }
}

