/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.autosys.AutosysSchedulingUtils;
import com.bmc.ctmconvert.autosys.ExtendedCalendarConvertor;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AutosysSchedulingSettingsConvertor {
    private final AutosysDefs defs;
    private final HashMap<String, Set<Properties>> entityTags;
    private final HashMap<String, Properties> allTags;
    private ExtendedCalendarConvertor extendedCalendarConvertor;

    public AutosysSchedulingSettingsConvertor(AutosysDefs autosysDefs, ExtendedCalendarConvertor extendedCalendarConvertor) {
        this.defs = autosysDefs;
        this.entityTags = new HashMap();
        this.allTags = new HashMap();
        this.extendedCalendarConvertor = extendedCalendarConvertor;
    }

    public Set<Properties> createTags(String root) {
        LinkedHashSet<Properties> tagSet = new LinkedHashSet<Properties>();
        if (this.defs.hasChildren(root)) {
            AttrHolderList children = this.defs.getChildren(root);
            for (IAttrHolder child : children) {
                Collection<Properties> childTag = this.createSchedulingSettingsForEntity(child);
                this.entityTags.put(this.getEntityName(child), new HashSet());
                this.entityTags.get(this.getEntityName(child)).addAll(this.createTags(this.getEntityName(child)));
                this.entityTags.get(this.getEntityName(child)).addAll(childTag);
                this.handleChildExtendedCalendar(child, this.extendedCalendarConvertor);
                tagSet.addAll(GlobalFunctions.filterInheritableCalendars((Collection)this.entityTags.get(this.getEntityName(child))));
            }
        }
        return tagSet;
    }

    public String generateTagsId(IAttrHolder entity) {
        return new AutosysSchedulingUtils(entity).getSchedulingSettingsIdString();
    }

    public void handleChildExtendedCalendar(IAttrHolder child, ExtendedCalendarConvertor extendedCalendarConvertor) {
        String runCal = child.getAttr("run_calendar");
        String excCal = child.getAttr("exclude_calendar");
        Collection allCalendarNames = this.allTags.values().stream().map(rbc -> rbc.getProperty("NAME")).collect(Collectors.toList());
        if (!excCal.equals("NULL") && !excCal.isEmpty() && extendedCalendarConvertor.isExtendedCalendar(excCal)) {
            this.entityTags.get(this.getEntityName(child)).addAll(extendedCalendarConvertor.getRbcsForDraft(excCal, true, allCalendarNames));
        }
        if (!runCal.equals("NULL") && !runCal.isEmpty() && extendedCalendarConvertor.isExtendedCalendar(runCal)) {
            this.entityTags.get(this.getEntityName(child)).addAll(extendedCalendarConvertor.getRbcsForDraft(runCal, allCalendarNames));
        }
    }

    public Collection<Properties> createSchedulingSettingsForEntity(IAttrHolder entity) {
        String tagsId = this.generateTagsId(entity);
        boolean allOrNone = tagsId.matches(String.format("(%s|%s)", "ALL", "NONE"));
        if (allOrNone) {
            return this.getAllOrNone(tagsId);
        }
        Map<String, String> separatedTags = this.separatedTagsId(tagsId);
        return separatedTags.entrySet().stream().flatMap(tag -> this.getGeneratedTag(entity, (String)tag.getKey(), (String)tag.getValue()).stream()).collect(Collectors.toSet());
    }

    private Optional<Properties> getGeneratedTag(IAttrHolder entity, String calendarType, String tagId) {
        String calendarNameInMap = (calendarType.equals("exclude_calendar") ? "!" : "") + tagId;
        if (this.allTags.containsKey(calendarNameInMap)) {
            return Optional.ofNullable(this.allTags.get(calendarNameInMap));
        }
        Optional<Properties> ret = this.generateTag(entity, calendarType, tagId);
        ret.ifPresent(rbc -> this.allTags.put(calendarNameInMap, (Properties)rbc));
        return ret;
    }

    private Set<Properties> getAllOrNone(String tagId) {
        Properties properties;
        HashSet<Properties> retval = new HashSet<Properties>();
        if (this.allTags.containsKey(tagId)) {
            properties = this.allTags.get(tagId);
        } else {
            properties = tagId.equals("ALL") ? AutosysSchedulingSettingsConvertor.getAllDaysRBC() : AutosysSchedulingSettingsConvertor.getNoneRBC();
            this.allTags.put(tagId, properties);
        }
        retval.add(properties);
        return retval;
    }

    public static Properties getAllDaysRBC() {
        Properties toRet = new Properties();
        toRet.setProperty("NAME", "ALL");
        toRet.setProperty("LEVEL", "CONTROL-M");
        toRet.setProperty("WEEKDAYS", "ALL");
        return AutosysSchedulingSettingsConvertor.addSchedulingPropertiesDefultValues(toRet, false);
    }

    public static Properties getNoneRBC() {
        Properties toRet = new Properties();
        toRet.setProperty("NAME", "NONE");
        toRet.setProperty("LEVEL", "CONTROL-M");
        return AutosysSchedulingSettingsConvertor.addSchedulingPropertiesDefultValues(toRet, true);
    }

    private Map<String, String> separatedTagsId(String tagsId) {
        String[] separatedTags;
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (String tag : separatedTags = tagsId.split(";")) {
            String[] typeAndName = tag.split(":");
            if (typeAndName.length != 2) continue;
            retVal.put(typeAndName[0], typeAndName[1]);
        }
        return retVal;
    }

    private Boolean getOnDemandFlagRule() {
        return this.defs.getRules().getBooleanRule("Autosys rules", new String[]{"ON_DEMAND_UDLY"});
    }

    private Optional<Properties> generateTag(IAttrHolder entity, String calendarsType, String tagId) {
        return switch (calendarsType) {
            case "days_of_week" -> Optional.ofNullable(this.getWeekDaysProperties(new AutosysSchedulingUtils(entity), tagId));
            case "exclude_calendar" -> this.getGlobalExcludeRBCProperties(tagId);
            case "run_calendar" -> this.getGlobalRunCalendarProperties(tagId);
            case "use_parent" -> Optional.ofNullable(this.getParentScheduling());
            default -> Optional.empty();
        };
    }

    private Properties getParentScheduling() {
        Properties prop = new Properties();
        prop.setProperty("NAME", "*");
        return prop;
    }

    private Optional<Properties> getGlobalRunCalendarProperties(String calName) {
        return this.getGlobalCalendarProperties(calName);
    }

    private Optional<Properties> getGlobalCalendarProperties(String calName) {
        String ctmCalName = this.getCtmCalendarName(calName);
        return this.getGlobalRBCProperties(ctmCalName);
    }

    private Optional<Properties> getGlobalExcludeRBCProperties(String calName) {
        return this.getGlobalCalendarProperties(calName).map(rbc -> {
            String oldName = rbc.getProperty("NAME");
            rbc.setProperty("NAME", "!" + oldName);
            return rbc;
        });
    }

    private String getCtmCalendarName(String calName) {
        return this.defs.getCalendarFinalName(calName);
    }

    private Optional<Properties> getGlobalRBCProperties(String calName) {
        Properties rbc = new Properties();
        if (this.extendedCalendarConvertor.isExtendedCalendar(calName)) {
            return Optional.empty();
        }
        Optional.ofNullable(StringUtils.left((String)calName, (int)19)).map(truncatedCalendarName -> FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", truncatedCalendarName)).ifPresent(validCalendarName -> rbc.setProperty("NAME", (String)validCalendarName));
        rbc.setProperty("LEVEL", "TABLE");
        return Optional.ofNullable(rbc);
    }

    public Properties getWeekDaysProperties(AutosysSchedulingUtils weekDaysConvertor, String tagId) {
        Properties toRet = new Properties();
        boolean allOrNone = tagId.matches(String.format("(%s|%s)", "ALL", "NONE"));
        String tagname = allOrNone ? tagId : weekDaysConvertor.getDaysOfWeekByName();
        toRet.setProperty("NAME", tagname);
        toRet.setProperty("LEVEL", AutosysSchedulingSettingsConvertor.getCalendarLevel(tagname));
        toRet.setProperty("WEEKDAYS", weekDaysConvertor.getDaysOfWeekAsNumber());
        return AutosysSchedulingSettingsConvertor.addSchedulingPropertiesDefultValues(toRet, "NONE".equals(tagId));
    }

    @NotNull
    private static String getCalendarLevel(String tagname) {
        return switch (tagname) {
            case "NONE", "ALL" -> "CONTROL-M";
            default -> "TABLE";
        };
    }

    private static Properties addSchedulingPropertiesDefultValues(Properties properties, boolean isNone) {
        properties.setProperty("JAN", isNone ? "0" : "1");
        properties.setProperty("FEB", isNone ? "0" : "1");
        properties.setProperty("MAR", isNone ? "0" : "1");
        properties.setProperty("APR", isNone ? "0" : "1");
        properties.setProperty("MAY", isNone ? "0" : "1");
        properties.setProperty("JUN", isNone ? "0" : "1");
        properties.setProperty("JUL", isNone ? "0" : "1");
        properties.setProperty("AUG", isNone ? "0" : "1");
        properties.setProperty("SEP", isNone ? "0" : "1");
        properties.setProperty("OCT", isNone ? "0" : "1");
        properties.setProperty("NOV", isNone ? "0" : "1");
        properties.setProperty("DEC", isNone ? "0" : "1");
        properties.setProperty("DAYS_AND_OR", "AND");
        properties.setProperty("SHIFT", "IGNOREJOB");
        properties.setProperty("SHIFTNUM", "+00");
        properties.setProperty("MAXWAIT", "00");
        properties.setProperty("RETRO", "0");
        return properties;
    }

    public Set<Properties> getEntTags(String entId) {
        LinkedHashSet<Properties> retList = new LinkedHashSet<Properties>();
        Set<Properties> entTags = this.entityTags.get(entId);
        if (entTags != null) {
            retList.addAll(entTags);
        }
        return retList;
    }

    public void addEntTags(String entId, List<Properties> tags) {
        if (this.entityTags.containsKey(entId)) {
            this.entityTags.get(entId).addAll(tags);
        }
    }

    private String getEntityName(IAttrHolder entity) {
        return entity.getAttr("insert_job");
    }

    public String toString() {
        return "AutosysSchedulingSettingsConvertor [m_entityTags=" + String.valueOf(this.entityTags) + ", m_allTags=" + String.valueOf(this.allTags) + "]";
    }
}

