/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutosysQuantResources {
    private final AutosysJob autosysJob;
    private final IAttrHolder sourceAttr;
    private final List<Properties> quantResList;
    private final SchedEntity.TYPE type;

    public AutosysQuantResources(AutosysJob autosysJob, IAttrHolder sourceAttr, List<Properties> quantResList, SchedEntity.TYPE type) {
        this.autosysJob = autosysJob;
        this.sourceAttr = sourceAttr;
        this.quantResList = quantResList;
        this.type = type;
    }

    public void generateQuantResources() {
        this.generateJobLoadResource();
        this.convertResources();
    }

    private void generateJobLoadResource() {
        String load = this.sourceAttr.getAttr("job_load").trim();
        if (!load.isEmpty() && !load.equals("NULL")) {
            boolean convertible = true;
            if (!load.matches("^[0-9]+$")) {
                this.autosysJob.addMessage("WRN4005", "job_load", load);
                convertible = false;
            }
            if (this.type != SchedEntity.TYPE.JOB) {
                this.autosysJob.addMessage("WRN4006", "job_load", this.autosysJob.getJobName());
                convertible = false;
            }
            if (convertible) {
                String node = this.sourceAttr.getAttr("machine");
                Properties qrProps = new Properties();
                String val = node + "_job_load";
                String newVal = FieldValidation.instance().validateAndReturnFixedValue("QUANTITATIVE_RESOURCE_NAME", val, true, null, this.autosysJob.getJobName(), this.autosysJob.getMessages());
                qrProps.setProperty("NAME", newVal);
                qrProps.setProperty("QUANT", load);
                this.quantResList.add(qrProps);
            }
        }
    }

    private void convertResources() {
        String resources = this.sourceAttr.getAttr("resources").trim();
        if (!resources.isEmpty() && !resources.equals("NULL")) {
            if (this.type != SchedEntity.TYPE.JOB) {
                this.autosysJob.addMessage("WRN4006", "resources", this.autosysJob.getJobName());
                return;
            }
            Pattern p = Pattern.compile("\\s*\\((.*?)\\)\\s*(AND\\s*(.*))?");
            String restResources = resources;
            while (restResources != null) {
                Matcher m = p.matcher(restResources);
                if (m.find()) {
                    this.addQuantitativeResource(m.group(1));
                    restResources = m.group(3);
                    if (m.hitEnd()) continue;
                    this.autosysJob.addMessage("WRN4054", this.autosysJob.getOriginalJobName(), resources);
                    restResources = null;
                    continue;
                }
                this.autosysJob.addMessage("WRN4054", this.autosysJob.getOriginalJobName(), restResources);
                restResources = null;
            }
        }
    }

    private String handleQuantity(String quantity) {
        String resourceMaxQuantity = "9999";
        if (GlobalFunctions.isNumber((String)quantity)) {
            return quantity;
        }
        this.autosysJob.addMessage("WRN4075", this.autosysJob.getOriginalJobName(), this.autosysJob.getJobName());
        return resourceMaxQuantity;
    }

    private void addQuantitativeResource(String resourceValue) {
        Pattern p = Pattern.compile("(.*?),QUANTITY=([^,FREE]+)(,FREE=(A|Y|N))?");
        Matcher m = p.matcher(resourceValue);
        if (m.find()) {
            String resName = m.group(1);
            String resQuant = m.group(2);
            Properties qrProps = new Properties();
            qrProps.setProperty("NAME", resName);
            qrProps.setProperty("QUANT", this.handleQuantity(resQuant));
            this.quantResList.add(qrProps);
            Optional<String> free = Optional.ofNullable(m.group(3));
            String autosysFreeSupportedValueInCtm = ",FREE=A";
            if (free.filter(autosysFreeSupportedValueInCtm::equalsIgnoreCase).isEmpty()) {
                String autosysFreeDefaultValue = ",FREE=Y";
                this.autosysJob.addMessage("WRN4056", this.autosysJob.getOriginalJobName(), this.autosysJob.getJobName(), free.orElse(autosysFreeDefaultValue).substring(1));
            }
        } else {
            this.autosysJob.addMessage("WRN4054", this.autosysJob.getOriginalJobName(), resourceValue);
        }
    }

    public void addQRActions(Reporter reporter) {
        for (Properties qres : this.quantResList) {
            HashMap<String, String> quantAction = new HashMap<String, String>();
            quantAction.put("ACTENTTYPE", "QR");
            quantAction.put("JOBID", this.autosysJob.getJobName());
            quantAction.put("ACTENTNAME", qres.getProperty("NAME"));
            quantAction.put("ACTENTQTY", qres.getProperty("QUANT"));
            quantAction.put("ACTSTATUS", "0");
            reporter.performAddAction(quantAction);
        }
    }
}

