/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.autosys.AutosysEnvVars;
import com.bmc.ctmconvert.autosys.AutosysFTPConvertor;
import com.bmc.ctmconvert.autosys.AutosysGenerateShouts;
import com.bmc.ctmconvert.autosys.AutosysGlobals;
import com.bmc.ctmconvert.autosys.AutosysHandleSuccessCodes;
import com.bmc.ctmconvert.autosys.AutosysQuantResources;
import com.bmc.ctmconvert.autosys.AutosysSCPConvertor;
import com.bmc.ctmconvert.autosys.AutosysSchedulingSettingsConvertor;
import com.bmc.ctmconvert.autosys.AutosysSchedulingUtils;
import com.bmc.ctmconvert.autosys.AutosysUtilities;
import com.bmc.ctmconvert.autosys.CyclicDecider;
import com.bmc.ctmconvert.autosys.CyclicHandler;
import com.bmc.ctmconvert.autosys.EndFolderAssistingJobCreator;
import com.bmc.ctmconvert.autosys.HandleBuiltinAutoEdits;
import com.bmc.ctmconvert.autosys.TimezoneConvert;
import com.bmc.ctmconvert.autosys.handlers.AutosysPsftConvertorHandler;
import com.bmc.ctmconvert.autosys.handlers.AutosysSAPConvertorHandler;
import com.bmc.ctmconvert.autosys.handlers.AutosysStandaloneJobPredecessorSchedulingHandler;
import com.bmc.ctmconvert.autosys.handlers.MaxExitSuccHandler;
import com.bmc.ctmconvert.autosys.handlers.NRetriesHandler;
import com.bmc.ctmconvert.autosys.handlers.RedirectionHandler;
import com.bmc.ctmconvert.autosys.handlers.SendNotificationHandler;
import com.bmc.ctmconvert.autosys.jobtypes.AutosysBoxSuccessFailureAssistingJobsBuilder;
import com.bmc.ctmconvert.autosys.jobtypes.AutosysFileWatcherConverter;
import com.bmc.ctmconvert.autosys.jobtypes.HttpConverter;
import com.bmc.ctmconvert.autosys.jobtypes.I5Converter;
import com.bmc.ctmconvert.autosys.jobtypes.OmtfConverter;
import com.bmc.ctmconvert.autosys.jobtypes.ZosConverter;
import com.bmc.ctmconvert.autosys.jobtypes.sap.SapBWConverter;
import com.bmc.ctmconvert.autosys.jobtypes.sap.SapR3CopyConverter;
import com.bmc.ctmconvert.autosys.jobtypes.sap.SapR3CreateConverter;
import com.bmc.ctmconvert.autosys.jobtypes.sql.SqlQueryConverter;
import com.bmc.ctmconvert.autosys.jobtypes.sql.StoredProcedureConverter;
import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.conditions.InConditionBuilder;
import com.bmc.ctmconvert.common.conditions.OutConditionBuilder;
import com.bmc.ctmconvert.common.dummy.DummyUtils;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class AutosysJob
implements SchedEntity {
    private boolean m_isValid;
    private static final CtmPriority priorityCalculator = new CtmPriority(0, 99);
    private SchedEntity.TYPE m_type;
    private AutosysJob m_parent = null;
    private String m_tableName;
    private String m_jobName;
    private static final String[] ctmCalendars = new String[]{"CONFCAL", "DAYSCAL", "WEEKSCAL"};
    private RulesDataSet m_rules = null;
    protected HashMap<String, String> m_jobAttr = new HashMap();
    private final IAttrHolder m_sourceAttr;
    private final AutosysDefs m_sourceDefs;
    private final LinkedHashMap<String, String> m_autoedits = new LinkedHashMap();
    private final List<String> m_optionalAttributesUsed = new ArrayList<String>();
    private final List<Properties> quantResList = new ArrayList<Properties>();
    private final HandleBuiltinAutoEdits handleBuiltinAutoEdits = new HandleBuiltinAutoEdits(this);
    private AutosysGenerateShouts autosysGenerateShouts;
    private AutosysQuantResources autosysQuantResources;
    private final UniqueValueGenerator uniqueValueGenerator = new UniqueValueGenerator();
    private final List<AssistingJob> assistingJobs = new ArrayList<AssistingJob>();
    private final ArrayList<String> m_messages = new ArrayList();
    private List<Properties> m_ctrlRes = null;
    private Set<Properties> m_RBCs = null;
    private AutosysStandaloneJobPredecessorSchedulingHandler autosysStandaloneJobPredecessorSchedulingHandler;
    private boolean isDSJob;
    private static final List<String> userDailyOnDemandAttribs = List.of("condition", "run_window", "start_times", "start_mins", "run_calendar", "exclude_calendar", "days_of_week");
    private static final List<String> unSupportedAttributes = List.of("override_job", "auto_delete", "avg_runtime", "chk_files", "delete_box", "delete_job", "heartbeat_interval", "job_terminator");

    public AutosysJob(IAttrHolder attributes, AutosysDefs sourceDef) {
        this.m_sourceDefs = sourceDef;
        this.m_isValid = true;
        this.m_sourceAttr = attributes;
        this.isDSJob = true;
    }

    public static AutosysJob createAutosysJob(IAttrHolder attributes, AutosysDefs sourceDef) {
        try {
            AutosysJob job = new AutosysJob(attributes, sourceDef);
            job.init();
            job.m_tableName = job.m_jobAttr.get("JOBNAME");
            return job;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error initialize Job " + attributes.getAttr("insert_job"), ex);
        }
    }

    public RulesDataSet getRules() {
        return this.m_rules;
    }

    AutosysJob(AutosysJob parent, IAttrHolder attributes, AutosysDefs sourceDef) {
        this(attributes, sourceDef);
        this.m_parent = parent;
        this.m_tableName = this.getTableName();
    }

    public static AutosysJob createAutosysJob(AutosysJob parent, IAttrHolder attributes, AutosysDefs sourceDef) {
        try {
            AutosysJob job = new AutosysJob(parent, attributes, sourceDef);
            job.init();
            return job;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error initialize Job " + attributes.getAttr("insert_job"), ex);
        }
    }

    public String applyFieldConversion(String field) {
        return this.m_rules.getFieldEditor().generateCTMField(field, this::getSourceAttr);
    }

    public String getSourceAttr(String field) {
        String value = this.m_sourceAttr.getAttr(field);
        return this.isEmptyValue(value) ? "" : value;
    }

    void init() {
        this.m_rules = this.m_sourceDefs.getRules();
        this.addFromDefs();
        String jobType = AutosysDefs.getAutosysJobType(this.m_sourceAttr);
        String parentEnt = this.m_sourceAttr.getAttr("box_name");
        this.m_type = jobType.equalsIgnoreCase("b") ? (parentEnt.equalsIgnoreCase("NULL") || !this.m_sourceDefs.getParents().containsKey(parentEnt) ? SchedEntity.TYPE.SMART_TABLE : SchedEntity.TYPE.SUB_TABLE) : SchedEntity.TYPE.JOB;
        this.m_jobName = this.m_type.equals((Object)SchedEntity.TYPE.JOB) ? this.applyFieldConversion("JOBNAME") : this.applyFieldConversion("TABLE_NAME");
        this.validateAttributesAndCommand();
        this.m_jobAttr.put("JOBNAME", this.m_jobName);
        this.m_jobAttr.put("MEMNAME", this.applyFieldConversion("MEMNAME"));
        this.m_jobAttr.put("OWNER", this.applyFieldConversion("OWNER"));
        this.m_jobAttr.put("AUTHOR", this.m_jobAttr.get("OWNER"));
        this.m_jobAttr.put("CONFIRM", this.attrFromSource("auto_hold", "0"));
        String tmpDesc = this.applyFieldConversion("DESCRIPTION").trim();
        if (tmpDesc.matches("^\"[^\"]*\"$")) {
            tmpDesc = tmpDesc.replaceAll("^\"", "").replaceAll("\"$", "");
        }
        this.m_jobAttr.put("DESCRIPTION", tmpDesc);
        this.m_jobAttr.put("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", this.applyFieldConversion("NODEID")));
        this.m_jobAttr.put("CYCLIC", "0");
        this.m_jobAttr.put("INTERVAL", "0");
        this.m_jobAttr.put("MAXRERUN", "0");
        this.handelRBCRelationship();
        this.m_jobAttr.put("APPLICATION", this.applyFieldConversion("APPLICATION"));
        this.m_jobAttr.put("GROUP", this.applyFieldConversion("GROUP"));
        this.convertTimeWindow(this.m_sourceAttr.getAttr("run_window"));
        HashMap<String, String> newAttrs = new HashMap<String, String>();
        for (String key : this.m_jobAttr.keySet()) {
            String originalValue = this.m_jobAttr.get(key);
            String validatedValue = this.isHostnameFiled(key) ? this.validateHostNameField(originalValue) : FieldValidation.instance().validateAndReturnFixedValue(key, originalValue, true, null, this.getJobName(), this.m_messages);
            newAttrs.put(key, validatedValue);
        }
        this.m_jobAttr = newAttrs;
        String cmdLine = this.m_sourceAttr.getAttr("command");
        if (!AutosysSAPConvertorHandler.instance().isSapJob(cmdLine) && !AutosysPsftConvertorHandler.instance().isPsftJob(cmdLine)) {
            FieldValidation.instance().cmdLineValidateAndReportMessages(cmdLine, this.m_jobAttr.get("JOBNAME"), this.m_messages);
        }
        this.m_jobAttr.put("CMDLINE", this.m_sourceAttr.getAttr("command"));
        this.m_jobName = this.m_jobAttr.get("JOBNAME");
        this.convertTimeZone();
        this.generateOnStatements();
        this.convertPriority();
        if (this.m_type == SchedEntity.TYPE.JOB) {
            this.handleTaskType();
            this.handleRedirection();
            this.m_jobAttr.put("CMDLINE", this.handleBuiltinAutoEdits.handle(this.m_jobAttr.get("CMDLINE")));
            this.convertPreCmd();
        }
        String version = Params.instance().getGUIVersion();
        CyclicDecider cyclicDecider = new CyclicDecider(this.m_sourceAttr, this.m_rules, this.m_type, version, this.m_messages, this.m_jobName);
        CyclicHandler cyclic = new CyclicHandler(cyclicDecider, this.m_jobAttr, this.m_messages, this.m_jobName);
        if (cyclicDecider.couldEntityBeConvertedAsCyclic()) {
            cyclic.convertCyclic(this.m_sourceAttr);
        } else {
            cyclicDecider.issueMessages();
        }
        this.autosysQuantResources = new AutosysQuantResources(this, this.m_sourceAttr, this.quantResList, this.m_type);
        this.autosysQuantResources.generateQuantResources();
        new AutosysEnvVars(this.m_sourceAttr, this.m_autoedits).generateEnvVars();
        this.convertByJobType();
        this.autosysGenerateShouts = new AutosysGenerateShouts();
        this.autosysGenerateShouts.generateShouts(this.m_sourceAttr, this, this.m_jobAttr.get("TIMEFROM"), this::issueMessageForAddDestKillJob);
        this.addJobActions();
        if (this.m_isValid) {
            this.m_isValid = !this.hasErrors();
        }
        this.m_jobAttr.put("ACTIVE_FROM", "");
        this.m_jobAttr.put("ACTIVE_TILL", "");
        this.autosysStandaloneJobPredecessorSchedulingHandler = new AutosysStandaloneJobPredecessorSchedulingHandler(this.m_sourceDefs, this.m_rules, this.m_sourceDefs.getPredecessorsMap());
        this.autosysStandaloneJobPredecessorSchedulingHandler.inheritPredecessorScheduling(this);
        if (this.m_type != SchedEntity.TYPE.SUB_TABLE) {
            this.setUserDaily();
        }
        this.handleStandalonejobsWithoutShceduling();
        if (this.isCyclic()) {
            this.m_jobAttr.put("IND_CYCLIC", "TARGET");
        }
    }

    private void handleStandalonejobsWithoutShceduling() {
        if (this.isStandAloneJobWithoutSchedule(new AutosysSchedulingUtils(this.m_sourceAttr))) {
            this.addAttribute("TAG_RELATIONSHIP", "OR");
            this.getJobAttr().remove("DAYS");
        }
    }

    private boolean isStandAloneJobWithoutSchedule(AutosysSchedulingUtils autosysSchedulingUtils) {
        return this.isStandaloneJobWithNoDateConditions(autosysSchedulingUtils) && autosysSchedulingUtils.noSchedulingSettings();
    }

    private boolean isStandaloneJobWithNoDateConditions(AutosysSchedulingUtils autosysSchedulingUtils) {
        return this.isStandAloneJob() && !autosysSchedulingUtils.isDateConditions();
    }

    public boolean isStandAloneJob() {
        return this.getSourceAttr("box_name").equals("StandaloneJobs");
    }

    private String validateHostNameField(String originalValue) {
        String validatedValue = FieldValidation.instance().validateAndReturnFixedValue("NODEID", originalValue);
        if (!validatedValue.equals(originalValue)) {
            this.addMessage("WRN4059", this.getJobName(), originalValue);
        }
        return originalValue;
    }

    private boolean isHostnameFiled(String key) {
        return key.equals("NODEID");
    }

    private void convertByJobType() {
        String autosysJobType;
        switch (autosysJobType = AutosysDefs.getAutosysJobType(this.m_sourceAttr)) {
            case "c": {
                this.convertSapAndPeopleSoftFromCommandJob();
                break;
            }
            case "f": {
                new AutosysFileWatcherConverter(this).convertFileWatch();
                break;
            }
            case "ftp": {
                new AutosysFTPConvertor(this).convert();
                break;
            }
            case "scp": {
                new AutosysSCPConvertor(this).convert();
                break;
            }
            case "sapjc": {
                new SapR3CopyConverter(this).convert();
                break;
            }
            case "sap": {
                new SapR3CreateConverter(this).convert();
                break;
            }
            case "sapbwpc": {
                new SapBWConverter(this).convert();
                break;
            }
            case "sql": {
                new SqlQueryConverter(this).convert();
                break;
            }
            case "dbproc": {
                new StoredProcedureConverter(this).convert();
                break;
            }
            case "omtf": {
                new OmtfConverter(this, this.m_rules.getStringRule("Autosys rules", new String[]{"OMTFType"})).convert();
                break;
            }
            case "i5": {
                new I5Converter(this).convert();
                break;
            }
            case "zos": {
                new ZosConverter(this).convert();
                break;
            }
            case "http": {
                new HttpConverter(this).convert();
                break;
            }
            default: {
                this.unsupportedJobType(autosysJobType);
            }
        }
    }

    private void convertSapAndPeopleSoftFromCommandJob() {
        boolean sapEnabled = this.m_rules.getBooleanRule("Autosys rules", new String[]{"EnableSAPConversion"});
        boolean isPsftEnabled = this.m_rules.getBooleanRule("Autosys rules", new String[]{"EnablePeopleSoftConversion"});
        if (sapEnabled) {
            this.convertCommandJobToSapJob();
        } else if (isPsftEnabled) {
            this.convertPeopleSoftJobs();
        }
    }

    private void unsupportedJobType(String autosysJobType) {
        if (!AutosysGlobals.SUPPORTED_JOB_TYPES.contains(autosysJobType)) {
            DummyUtils.convertToDummyJob((SchedEntity)this);
            this.addMessage("WRN4065", this.getJobName(), this.getSourceAttr("insert_job"), this.getSourceAttr("job_type"));
        }
    }

    private void convertPeopleSoftJobs() {
        String command = this.m_sourceAttr.getAttr("command");
        AutosysPsftConvertorHandler.instance().convertPsftJob(command, this.m_jobAttr, (ArrayList)this.m_optionalAttributesUsed, this.m_autoedits, this.m_rules, this.m_messages);
        if (this.m_autoedits.get("%%PS8-JOBNAME") != null && !this.m_autoedits.get("%%PS8-JOBNAME").isEmpty()) {
            this.m_jobAttr.put("MEMNAME", this.m_jobAttr.get("JOBNAME"));
        } else if (this.m_autoedits.get("%%PS8-PRCSNAME") != null && !this.m_autoedits.get("%%PS8-PRCSNAME").isEmpty()) {
            this.m_jobAttr.put("MEMNAME", this.m_jobAttr.get("JOBNAME"));
        }
        String ps8Userid = this.m_autoedits.get("%%PS8-USERID");
        if (ps8Userid != null && !ps8Userid.isEmpty()) {
            this.m_jobAttr.put("OWNER", ps8Userid);
        }
    }

    private void convertCommandJobToSapJob() {
        String sapR3Account;
        String command = this.m_sourceAttr.getAttr("command");
        AutosysSAPConvertorHandler.instance().convertSAPJob(command, this.m_jobAttr, (ArrayList)this.m_optionalAttributesUsed, this.m_autoedits, this.m_rules, this.m_messages);
        if (AutosysSAPConvertorHandler.instance().isSapJobCommand(command)) {
            this.m_jobAttr.put("CMDLINE", "");
            int stepsNumber = AutosysSAPConvertorHandler.instance().getNumberOfSteps(command);
            if (stepsNumber > 99) {
                this.addMessage("WRN4014", this.m_jobAttr.get("JOBNAME"), Integer.toString(stepsNumber));
                this.m_jobAttr.put("TASKTYPE", "Dummy");
            }
        }
        if (this.m_autoedits.get("%%SAPR3-JOBNAME") != null && !this.m_autoedits.get("%%SAPR3-JOBNAME").isEmpty()) {
            this.m_jobAttr.put("JOBNAME", this.m_autoedits.get("%%SAPR3-JOBNAME"));
            if (this.m_jobAttr.get("MEMNAME") == null || this.m_jobAttr.get("MEMNAME").isEmpty()) {
                this.m_jobAttr.put("MEMNAME", this.m_autoedits.get("%%SAPR3-JOBNAME"));
            }
        }
        if ((sapR3Account = this.m_autoedits.get("%%SAPR3-ACCOUNT")) != null && !sapR3Account.isEmpty() && !sapR3Account.equals("DEFAULT_CONNECTION")) {
            this.m_jobAttr.put("OWNER", sapR3Account);
        }
    }

    private void setUserDaily() {
        boolean isSchedCondsUsed;
        boolean isOnDemand = (this.type().equals((Object)SchedEntity.TYPE.SMART_TABLE) || this.type().equals((Object)SchedEntity.TYPE.JOB) && this.m_parent == null) && this.m_rules.getBooleanRule("Autosys rules", new String[]{"ON_DEMAND_UDLY"}) != false && userDailyOnDemandAttribs.stream().allMatch(attr -> this.isEmptyValue(this.m_sourceAttr.getAttr(attr)));
        String dateConds = this.m_sourceAttr.getAttr("date_conditions");
        boolean bl = isSchedCondsUsed = dateConds.equals("1") || dateConds.equalsIgnoreCase("YES") || dateConds.equalsIgnoreCase("Y");
        if (!isSchedCondsUsed || isOnDemand) {
            this.m_jobAttr.put("TABLE_USERDAILY", "ON_DEMAND");
            this.m_jobAttr.put("STANDALONE_TABLE_NAME", "StandAloneJobs_ON_DEMAND");
        } else {
            this.m_jobAttr.put("TABLE_USERDAILY", "SYSTEM");
            this.m_jobAttr.put("STANDALONE_TABLE_NAME", "StandAloneJobs");
        }
    }

    private void convertTimeZone() {
        String sourceTimezone = this.m_sourceAttr.getAttr("timezone");
        if (this.isEmptyValue(sourceTimezone)) {
            return;
        }
        TimezoneConvert timeZoneConvertor = this.m_sourceDefs.getTimeZoneConvert();
        String timezone = timeZoneConvertor.translate(sourceTimezone);
        String localTz = this.m_rules.getStringRule("Autosys rules", new String[]{"LocalTimezone"});
        if (timezone != null) {
            if (!timezone.equals(localTz)) {
                this.m_jobAttr.put("TIMEZONE", timezone);
            }
        } else {
            this.addMessage("WRN4009", this.getOriginalJobName(), this.getJobName(), sourceTimezone);
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "TZ");
            action.put("JOBID", this.m_jobName);
            action.put("ACTENTNAME", sourceTimezone);
            action.put("ACTENTQTY", "0");
            action.put("ACTSTATUS", "0");
            Reporter.addAction(action);
        }
    }

    private void validateAttributesAndCommand() {
        this.checkUnSupportedAttributes();
        this.validateAutosysCMD();
    }

    private void checkUnSupportedAttributes() {
        unSupportedAttributes.stream().filter(attr -> !this.isEmptyValue(this.m_sourceAttr.getAttr(attr))).forEach(attr -> this.addMessage("WRN4002", (String)attr));
    }

    private void sendMessage(String cmd, String utility) {
        String warning;
        switch (utility) {
            case "archive_events": {
                String string = "WRN4020";
                break;
            }
            case "as_info": {
                String string = "WRN4021";
                break;
            }
            case "as_safetool": {
                String string = "WRN4022";
                break;
            }
            case "as_server": {
                String string = "WRN4023";
                break;
            }
            case "auto_svcdesk": {
                String string = "WRN4024";
                break;
            }
            case "autoaggr": {
                String string = "WRN4025";
                break;
            }
            case "autocal_asc": {
                String string = "WRN4026";
                break;
            }
            case "autodwp": {
                String string = "WRN4027";
                break;
            }
            case "autoflags": {
                String string = "WRN4028";
                break;
            }
            case "autoping": {
                String string = "WRN4029";
                break;
            }
            case "autorep": {
                String string = "WRN4030";
                break;
            }
            case "autosec_test": {
                String string = "WRN4031";
                break;
            }
            case "autostatad": {
                String string = "WRN4032";
                break;
            }
            case "autostatus": {
                String string = "WRN4033";
                break;
            }
            case "autosys_secure": {
                String string = "WRN4034";
                break;
            }
            case "autosyslog": {
                String string = "WRN4035";
                break;
            }
            case "autotimezone": {
                String string = "WRN4036";
                break;
            }
            case "autotrack": {
                String string = "WRN4037";
                break;
            }
            case "chase": {
                String string = "WRN4038";
                break;
            }
            case "chk_auto_up": {
                String string = "WRN4039";
                break;
            }
            case "clean_files": {
                String string = "WRN4040";
                break;
            }
            case "cron2jil": {
                String string = "WRN4041";
                break;
            }
            case "eventor": {
                String string = "WRN4042";
                break;
            }
            case "jil": {
                String string = "WRN4043";
                break;
            }
            case "job_delete": {
                String string = "WRN4044";
                break;
            }
            case "job_depends": {
                String string = "WRN4045";
                break;
            }
            case "monbro": {
                String string = "WRN4046";
                break;
            }
            case "sendevent": {
                String string = "WRN4047";
                break;
            }
            case "time0": {
                String string = "WRN4048";
                break;
            }
            case "xql": {
                String string = "WRN4049";
                break;
            }
            case "zql": {
                String string = "WRN4050";
                break;
            }
            default: {
                String string = warning = null;
            }
        }
        if (warning != null) {
            this.addMessage(warning, this.getOriginalJobName(), utility, cmd, this.getJobName());
        }
    }

    private void validateAutosysCMD() {
        String cmd = this.m_sourceAttr.getAttr("command");
        if (cmd.equals("NULL")) {
            return;
        }
        for (int i = 0; i < AutosysGlobals.UTILS_ARRAY.length; ++i) {
            String utility = AutosysGlobals.UTILS_ARRAY[i];
            if (!AutosysUtilities.isUtilityNameExistsInCommand(utility, cmd)) continue;
            this.sendMessage(cmd, utility);
            break;
        }
    }

    private void handleTaskType() {
        String command2;
        Consumer<String> setCommand = command -> this.m_jobAttr.put("CMDLINE", AutosysUtilities.convertUtilities(command));
        String taskType = "Command";
        boolean toDummy = this.m_rules.getTaskTypeHandler().isToDummy();
        boolean toJob = this.m_rules.getTaskTypeHandler().getJobType().equals("JOB");
        if (!this.m_sourceAttr.getAttr("std_in_file").equals("NULL")) {
            toJob = false;
        }
        if ((command2 = this.handleBuiltinAutoEdits.handle(this.m_sourceAttr.getAttr("command"))) == null) {
            command2 = this.m_sourceAttr.getAttr("command");
        }
        if (command2.equalsIgnoreCase("NULL")) {
            if (toDummy) {
                this.m_autoedits.put("%%$BMCWAIORIGTYPE", taskType);
                taskType = "Dummy";
            } else {
                taskType = "Job";
            }
            this.m_jobAttr.put("TASKTYPE", taskType);
            return;
        }
        if (toJob) {
            for (String taskTypeFilter : this.m_rules.getTaskTypeHandler().getTaskTypeFilters()) {
                if (taskTypeFilter == null || !command2.contains(taskTypeFilter)) continue;
                taskType = "Job";
                break;
            }
            if (!taskType.equals("Job")) {
                setCommand.accept(command2);
            } else {
                ArrayList argsArray = GlobalFunctions.cmdline2ArgArr((String)command2, (boolean)true);
                if (argsArray == null) {
                    taskType = "Command";
                    this.addMessage("INF4000", command2);
                } else {
                    this.m_jobAttr.put("MEMLIB", (String)argsArray.get(0));
                    this.m_jobAttr.put("MEMNAME", (String)argsArray.get(1));
                    for (int i = 2; i < argsArray.size() && argsArray.size() > 2; ++i) {
                        String value = this.handleBuiltinAutoEdits.handle((String)argsArray.get(i));
                        this.m_autoedits.put(String.format("%%%%PARM%d", i - 1), value);
                    }
                }
            }
        } else {
            setCommand.accept(command2);
        }
        if (toDummy) {
            this.m_autoedits.put("%%$BMCWAIORIGTYPE", taskType);
            taskType = "Dummy";
        }
        this.m_jobAttr.put("TASKTYPE", taskType);
    }

    public String getAttr(String attrName) {
        return this.m_jobAttr.get(attrName);
    }

    public List<SchedEntity> getChildren() {
        ArrayList<SchedEntity> list = new ArrayList<SchedEntity>();
        AttrHolderList parentAttributes = this.m_sourceDefs.getParents().get(this.getOriginalJobName());
        if (parentAttributes != null) {
            List<AutosysJob> children = parentAttributes.stream().map(childAttribute -> this.m_sourceDefs.spawnJob(this, (IAttrHolder)childAttribute)).collect(Collectors.toList());
            this.standaloneFolderAppendChildrenCalendars(children);
            list.addAll(children);
            list.addAll(this.jobTerminators(children));
        }
        return list;
    }

    private List<SchedEntity> jobTerminators(List<AutosysJob> children) {
        ArrayList<SchedEntity> list = new ArrayList<SchedEntity>();
        long jobCount = children.stream().filter(child -> child.type() == SchedEntity.TYPE.JOB).count();
        List<AutosysJob> childrenWithBoxTerminator = children.stream().filter(AutosysJob::isBoxTerminator).toList();
        if (jobCount > 1L && !childrenWithBoxTerminator.isEmpty()) {
            AssistingJob okJob = EndFolderAssistingJobCreator.createFolderEndedOkJob(this);
            String notOkCondName = this.getJobName() + "_ENDED_NOTOK";
            AssistingJob notOkJob = EndFolderAssistingJobCreator.createFolderEndedNotOkJob(this, this.m_sourceDefs.getJobOnstmts(this), notOkCondName);
            childrenWithBoxTerminator.forEach(child -> {
                String okCondName = this.getJobName() + "_" + child.getJobName() + "_ENDED_OK";
                okJob.addInCondition(InConditionBuilder.make((String)okCondName));
                this.addOutCond((AutosysJob)child, okCondName);
                EndFolderAssistingJobCreator.linkAssistingJobWithSourceJob(this.m_sourceDefs.getJobOnstmts((SchedEntity)child), notOkCondName);
            });
            list.add((SchedEntity)okJob);
            list.add((SchedEntity)notOkJob);
            if (this.hasParent()) {
                this.addMessageWithOriginalJobName("WRN4078", new String[0]);
            }
        }
        return list;
    }

    private void addOutCond(AutosysJob job, String conditionName) {
        this.m_sourceDefs.getJobOutconds(job).add(OutConditionBuilder.make((String)conditionName));
    }

    private void standaloneFolderAppendChildrenCalendars(List<AutosysJob> list) {
        list.forEach(child -> this.m_sourceDefs.addEntTags(this.getOriginalJobName(), new ArrayList<Properties>(GlobalFunctions.filterInheritableCalendars(child.getTags()))));
    }

    public List<Properties> getInConds() {
        return this.validateConds(this.m_sourceDefs.getJobInconds(this));
    }

    public String getJobName() {
        return this.m_jobName;
    }

    public void setJobName(String jobName) {
        this.m_jobName = jobName;
    }

    public List<Properties> getOnStmt() {
        return this.m_sourceDefs.getJobOnstmts(this);
    }

    public List<Properties> getOnStmt(boolean create) {
        return this.m_sourceDefs.getJobOnstmts(this, create);
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getOutConds() {
        return this.validateConds(this.m_sourceDefs.getJobOutconds(this));
    }

    private List<Properties> validateConds(List<Properties> sourceProps) {
        sourceProps = Optional.ofNullable(sourceProps).orElse(Collections.emptyList());
        ArrayList<Properties> validProps = new ArrayList<Properties>();
        Iterator<Properties> iterator = sourceProps.iterator();
        while (iterator.hasNext()) {
            Properties currCond;
            Properties newCond = currCond = iterator.next();
            String newVal = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", currCond.getProperty("NAME"), true, null, this.getJobName(), this.m_messages);
            if (!newVal.equals(currCond.getProperty("NAME"))) {
                newCond = new Properties();
                newCond.putAll((Map<?, ?>)currCond);
                newCond.remove("NAME");
                newCond.put("NAME", newVal);
            }
            validProps.add(newCond);
        }
        return this.validateParentheses(validProps);
    }

    private List<Properties> validateParentheses(List<Properties> validProps) {
        List parentheses = validProps.stream().map(c -> c.getProperty("OP")).collect(Collectors.toList());
        boolean isBalanced = GlobalFunctions.isBalancedParentheses(parentheses);
        if (!isBalanced) {
            this.addMessage("WRN4063", this.getOriginalJobName(), this.getJobName());
            return this.removeAllParentheses(validProps);
        }
        return validProps;
    }

    private List<Properties> removeAllParentheses(List<Properties> validProps) {
        return validProps.stream().map(p -> {
            p.remove("OP");
            Properties result = new Properties();
            result.putAll((Map<?, ?>)p);
            return result;
        }).collect(Collectors.toList());
    }

    public String getParentName() {
        if (this.m_parent == null) {
            return "";
        }
        String grandParent = this.m_parent.getParentName();
        if (grandParent == null) {
            grandParent = "";
        }
        return grandParent + (grandParent.isEmpty() ? "" : "/") + this.m_parent.getJobName();
    }

    public SchedEntity getParent() {
        return this.m_parent;
    }

    public List<Properties> getQuantResources() {
        return this.quantResList;
    }

    public String getTableName() {
        if (this.m_parent == null) {
            if (this.m_tableName != null) {
                return this.m_tableName;
            }
            return this.m_jobName;
        }
        return this.m_parent.getTablePathForSons();
    }

    public String getTablePathForSons() {
        String tablePathForSons;
        if (this.m_parent == null) {
            tablePathForSons = this.m_jobName;
        } else {
            String fixedTableName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.m_jobName, true, null, this.getJobName(), this.m_messages);
            tablePathForSons = "%s/%s".formatted(this.m_parent.getTablePathForSons(), fixedTableName);
        }
        return tablePathForSons;
    }

    public List<Properties> getTags() {
        if (this.getRBCs() == null) {
            boolean shouldUseParentScheduling;
            Set<Properties> jobCalendars = this.m_sourceDefs.getEntTags(this.getOriginalJobName());
            AutosysSchedulingUtils autosysSchedulingUtils = new AutosysSchedulingUtils(this.m_sourceAttr);
            boolean bl = shouldUseParentScheduling = this.shouldInheritCalendars(jobCalendars) && !this.isStandaloneJobWithNoDateConditions(autosysSchedulingUtils);
            if (shouldUseParentScheduling) {
                jobCalendars = this.createUseParentSchedulingCalendarSet();
            }
            this.setRBCs(jobCalendars);
            List<Properties> predecessorsSchedulingCalendars = this.autosysStandaloneJobPredecessorSchedulingHandler.getPredecessorsSchedulingCalendars();
            if (this.isSmartThatInheritsCalendarsFromPredecessor(predecessorsSchedulingCalendars)) {
                this.getRBCs().removeIf(this::isNoneCalendar);
            }
            this.getRBCs().addAll(predecessorsSchedulingCalendars);
            if (shouldUseParentScheduling) {
                this.getRBCs().removeIf(GlobalFunctions::isIncludeCalendar);
            }
            if (this.isSmartFolderWithOnlyNoneCalendarAndExcludeCalendars()) {
                this.replaceNoneCalendarWithAllCalendar();
            }
            if (this.isStandAloneJob() && (this.getRBCs().isEmpty() || AutosysJob.hasOnlyExcludeCalendars(new ArrayList<Properties>(this.getRBCs())))) {
                this.getRBCs().add(AutosysJob.createUseParentSchedulingCalendar());
            }
            if (GlobalFunctions.isSmartFolder((SchedEntity)this) && this.getRBCs().isEmpty()) {
                this.addNoneCalendar();
            }
            this.validateCalendars();
        }
        return new ArrayList<Properties>(this.getRBCs());
    }

    private void addNoneCalendar() {
        this.getRBCs().add(AutosysSchedulingSettingsConvertor.getNoneRBC());
    }

    private void replaceNoneCalendarWithAllCalendar() {
        this.getRBCs().removeIf(this::isNoneCalendar);
        this.getRBCs().add(AutosysSchedulingSettingsConvertor.getAllDaysRBC());
    }

    private boolean isSmartFolderWithOnlyNoneCalendarAndExcludeCalendars() {
        return GlobalFunctions.isSmartFolder((SchedEntity)this) && AutosysJob.hasOnlyExcludeCalendars(this.filterOutNoneCalendar());
    }

    @NotNull
    private List<Properties> filterOutNoneCalendar() {
        return this.getRBCs().stream().filter(c -> !this.isNoneCalendar((Properties)c)).collect(Collectors.toList());
    }

    private boolean shouldInheritCalendars(Set<Properties> jobCalendars) {
        return this.hasParent() && jobCalendars.stream().allMatch(this::isAllOrNoneCalendars);
    }

    private boolean isSmartThatInheritsCalendarsFromPredecessor(List<Properties> calendars) {
        return GlobalFunctions.isSmartFolder((SchedEntity)this) && !calendars.isEmpty() && this.isNotAllExcludeCalendars(calendars);
    }

    private boolean isNotAllExcludeCalendars(List<Properties> calendars) {
        return !AutosysJob.hasOnlyExcludeCalendars(calendars);
    }

    private static boolean hasOnlyExcludeCalendars(List<Properties> calendars) {
        return !calendars.isEmpty() && calendars.stream().allMatch(c -> c.getProperty("NAME").startsWith("!"));
    }

    private void handelRBCRelationship() {
        this.m_jobAttr.put("TAG_RELATIONSHIP", "OR");
    }

    private void validateCalendars() {
        if (this.getRBCs() == null || this.getRBCs().equals(this.createUseParentSchedulingCalendarSet())) {
            return;
        }
        this.setRBCs(this.getRBCs().stream().map(this::validateCalendar).collect(Collectors.toSet()));
    }

    private String validateCalendarName(String calendarName) {
        String calendarType;
        if (calendarName.startsWith("!")) {
            calendarName = calendarName.substring(1);
            calendarType = "exclude_calendar";
        } else {
            calendarType = "days_of_week";
        }
        String validatedName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", calendarName, true, null, calendarType, this.m_messages);
        String uniqueName = this.getUniqueCalendarName(validatedName, calendarType);
        if (calendarType.equals("exclude_calendar")) {
            return "!" + uniqueName;
        }
        return uniqueName;
    }

    public Properties validateCalendar(Properties originalCalendar) {
        Properties validatedCalendar = (Properties)originalCalendar.clone();
        if (this.isRunCalendar(validatedCalendar)) {
            this.validateRunCalendarName(validatedCalendar);
        } else {
            String calendarName = validatedCalendar.getProperty("NAME");
            if (!calendarName.equals("*")) {
                String validatedName = this.validateCalendarName(calendarName);
                validatedCalendar.put("NAME", validatedName);
                if (!validatedName.equals(calendarName)) {
                    this.addMessage("INF0017", "Calendar name", "run_calendar/exclude_calendar", calendarName, validatedName, "since '" + calendarName + "' is too long or already in use. Control-M does not allow duplicate calendar names");
                }
            }
        }
        return validatedCalendar;
    }

    private String getUniqueCalendarName(String calendarName, String type) {
        int maxSize = Integer.parseInt(FieldValidation.instance().getValidationItem("TAG_NAME").getMaxSize());
        return this.uniqueValueGenerator.getUniqueValue(type, calendarName, maxSize);
    }

    private void validateRunCalendarName(Properties validatedCalendar) {
        for (String calendarType : ctmCalendars) {
            if (!validatedCalendar.containsKey(calendarType)) continue;
            String calendarName = (String)validatedCalendar.get(calendarType);
            String validatedName = FieldValidation.instance().validateAndReturnFixedValue(calendarType, calendarName, true, null, "run_calendar", this.m_messages);
            if (validatedName.equals(validatedCalendar.get(calendarType))) continue;
            validatedCalendar.put(calendarType, validatedName);
            this.addMessage("INF0017", "Calendar name", "run_calendar/exclude_calendar", calendarName, validatedName, "since '" + calendarName + "' is too long or already in use. Control-M does not allow duplicate calendar names");
        }
    }

    private boolean isRunCalendar(Properties calendar) {
        return Arrays.stream(ctmCalendars).anyMatch(calendar::containsKey);
    }

    public boolean isAllOrNoneCalendars(Properties calendar) {
        return AutosysJob.isAllCalendar(calendar) || this.isNoneCalendar(calendar);
    }

    private boolean isNoneCalendar(Properties calendar) {
        return "NONE".equals(calendar.getProperty("NAME"));
    }

    private static boolean isAllCalendar(Properties calendar) {
        return "ALL".equals(calendar.getProperty("NAME"));
    }

    public boolean hasParent() {
        return this.m_parent != null;
    }

    protected Set<Properties> createUseParentSchedulingCalendarSet() {
        LinkedHashSet<Properties> retVal = new LinkedHashSet<Properties>();
        retVal.add(AutosysJob.createUseParentSchedulingCalendar());
        return retVal;
    }

    @NotNull
    private static Properties createUseParentSchedulingCalendar() {
        Properties prop = new Properties();
        prop.setProperty("NAME", "*");
        return prop;
    }

    public boolean isCyclic() {
        return this.m_jobAttr.get("CYCLIC").equalsIgnoreCase("1");
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public void setIsValid(boolean isValid) {
        this.m_isValid = isValid;
    }

    public String originalProductID() {
        return null;
    }

    private String attrFromSource(String attrName, String defaultValue) {
        String toRet = this.m_sourceAttr.getAttr(attrName);
        return this.isEmptyValue(toRet) ? defaultValue : toRet;
    }

    public SchedEntity.TYPE type() {
        return this.m_type;
    }

    private boolean isEmptyValue(String value) {
        return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL");
    }

    public void convertTimeWindow(String timeWindow) {
        Matcher timeWindowMatcher = AutosysGlobals.timeWindowpattern.matcher(timeWindow);
        if (timeWindowMatcher.matches()) {
            Object start = timeWindowMatcher.group(1).replace(":", "");
            Object end = timeWindowMatcher.group(2).replace(":", "");
            if (((String)start).length() == 3) {
                start = "0" + (String)start;
            }
            if (((String)end).length() == 3) {
                end = "0" + (String)end;
            }
            this.m_jobAttr.put("TIMEFROM", (String)start);
            this.m_jobAttr.put("TIMETO", (String)end);
        }
    }

    public List<Properties> getCtrlResources() {
        if (this.m_ctrlRes != null) {
            return this.m_ctrlRes;
        }
        if (this.m_sourceDefs.getJobControlRes(this) == null) {
            return null;
        }
        this.m_ctrlRes = new ArrayList<Properties>();
        for (Properties currControl : this.m_sourceDefs.getJobControlRes(this)) {
            String value = currControl.getProperty("NAME");
            String newValue = FieldValidation.instance().validateAndReturnFixedValue("CONTROL_RESOURCE_NAME", value, true, null, this.getJobName(), this.m_messages);
            Properties newProp = (Properties)currControl.clone();
            newProp.put("NAME", newValue);
            this.m_ctrlRes.add(newProp);
        }
        return this.m_ctrlRes;
    }

    public String getApplication() {
        String toRet = "DEFAULT_APPLICATION";
        if (this.m_jobAttr.containsKey("APPLICATION")) {
            toRet = this.m_jobAttr.get("APPLICATION");
        }
        return toRet;
    }

    public String getGroup() {
        return this.m_jobAttr.get("GROUP");
    }

    public List<AssistingJob> getAssistingJobs() {
        this.assistingJobs.addAll(this.getSmartFolderAssistingJobs());
        return this.assistingJobs;
    }

    public List<AssistingJob> getSmartFolderAssistingJobs() {
        AutosysBoxSuccessFailureAssistingJobsBuilder boxSuccessFailureAssistingJobsBuilder = new AutosysBoxSuccessFailureAssistingJobsBuilder(this, this.m_sourceDefs);
        return boxSuccessFailureAssistingJobsBuilder.buildBoxSuccessFailureAssistingJobs(this.getSourceAttr("box_success"), this.getSourceAttr("box_failure"));
    }

    public boolean isBoxTerminator() {
        return "1".equals(this.m_sourceAttr.getAttr("box_terminator")) && this.type() == SchedEntity.TYPE.JOB;
    }

    public boolean hasWarnings() {
        if (this.m_messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        Stream<String> warningMessages = messageIds.keySet().stream().filter(id -> ((MessageId)messageIds.get(id)).getMessageType(id).equals("W"));
        return warningMessages.anyMatch(id -> this.m_messages.stream().anyMatch(currMessage -> currMessage.startsWith((String)id)));
    }

    private void convertPriority() {
        String origPriority = this.m_sourceAttr.getAttr("priority");
        if (this.isEmptyValue(origPriority)) {
            origPriority = "99";
        }
        int priority = Integer.parseInt(origPriority);
        String priorityStr = priorityCalculator.calculatePriority(99 - priority);
        this.m_jobAttr.put("PRIORITY", priorityStr);
    }

    private void convertPreCmd() {
        String profile = this.m_sourceAttr.getAttr("profile");
        if (this.isEmptyValue(profile)) {
            return;
        }
        String command = this.m_rules.getStringRule("Autosys rules", new String[]{"SourceCommand"});
        if (command == null || command.isEmpty()) {
            command = "/bin/csh -c source";
        }
        this.updateCmdLine(profile, command);
    }

    private void updateCmdLine(String profile, String command) {
        String tmpCmdLine = this.m_jobAttr.get("CMDLINE");
        String ruleProfileCmdLinePrefix = String.format("%s %s ", command, profile);
        String newCmdLine = ruleProfileCmdLinePrefix + "; " + tmpCmdLine;
        this.m_jobAttr.put("CMDLINE", newCmdLine);
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.m_autoedits;
    }

    private void generateOnStatements() {
        AutosysHandleSuccessCodes handleOnDoSatements = new AutosysHandleSuccessCodes(this);
        handleOnDoSatements.handleSuccessCodes();
        NRetriesHandler nRetriesHandler = new NRetriesHandler(this);
        nRetriesHandler.HandlerNRetries();
        MaxExitSuccHandler maxExitSuccHandler = new MaxExitSuccHandler(this);
        maxExitSuccHandler.handleMaxExitSucc();
        SendNotificationHandler sendNotificationHandler = new SendNotificationHandler(this);
        sendNotificationHandler.handleSendNotification();
    }

    public String getOriginalJobName() {
        return this.m_sourceAttr.getAttr("insert_job");
    }

    public List<Properties> getShouts() {
        return this.autosysGenerateShouts.getShouts();
    }

    public List<String> getOptionalAttributes() {
        return this.m_optionalAttributesUsed;
    }

    private void handleRedirection() {
        RedirectionHandler redirectionHandler = new RedirectionHandler(this);
        Properties shoutRedirection = redirectionHandler.getDoShoutWithRedirection();
        if (!shoutRedirection.isEmpty()) {
            this.addVariablesForShout(shoutRedirection);
            this.getOnStmt(true).add(shoutRedirection);
        }
    }

    private void addVariablesForShout(Properties shoutRedirection) {
        String output = shoutRedirection.getProperty("PAR");
        if (output.contains("%%CNV_RUN_ID")) {
            this.addAutoEdits("%%CNV_RUN_ID", "%%ORDERID..%%RUNCOUNT");
        }
        if (output.contains("AUTORUN")) {
            this.addAutoEdits("%%AUTORUN", "%%ORDERID..%%RUNCOUNT");
        }
        if (output.contains("AUTO_JOB_NAME")) {
            this.addAutoEdits("%%AUTO_JOB_NAME", "%%JOBNAME");
        }
    }

    public ArrayList<String> getMessages() {
        return this.m_messages;
    }

    private void addMessagesFromDefs(String originaJobName) {
        List<String> messages = this.m_sourceDefs.getJobMessages(originaJobName);
        this.m_messages.addAll(messages);
        List<Map<String, String>> actions = this.m_sourceDefs.getJobActions(originaJobName);
        if (actions != null) {
            for (Map<String, String> action : actions) {
                Reporter.addAction(action);
            }
        }
    }

    private void addFromDefs() {
        String originalJobName = this.m_sourceAttr.getAttr("insert_job");
        this.addMessagesFromDefs(originalJobName);
        this.addVariablesFromDefs(originalJobName);
    }

    private void addVariablesFromDefs(String originalJobName) {
        Map<String, String> variables = this.m_sourceDefs.getJobVariables(originalJobName);
        variables.forEach(this::addAutoEdits);
    }

    public void addMessage(String msgid, String ... stringsArr) {
        Reporter.addMessage(this.m_messages, (String)msgid, (String)this.getJobName(), (String[])stringsArr);
    }

    public void addMessageWithOriginalJobName(String msgid, String ... stringsArr) {
        this.addMessage(msgid, this.getJobName(), this.getOriginalJobName());
    }

    private void addJobActions() {
        this.addQRActions();
        this.addCalendarMessages();
        this.addCRActions();
    }

    private void addCRActions() {
        List<Properties> ctrlResources = this.getCtrlResources();
        if (ctrlResources == null) {
            return;
        }
        HashMap<String, String> ctlResAction = new HashMap<String, String>();
        for (Properties currRes : ctrlResources) {
            ctlResAction.put("ACTENTTYPE", "CTL");
            ctlResAction.put("JOBID", this.m_jobName);
            ctlResAction.put("ACTENTNAME", currRes.getProperty("NAME"));
            ctlResAction.put("ACTSTATUS", "0");
            Reporter.addAction(ctlResAction);
            ctlResAction.clear();
        }
    }

    private void addCalendarMessages() {
        String[] calNames = new String[]{this.m_sourceDefs.getCalendarFinalName(this.m_sourceAttr.getAttr("run_calendar")), this.m_sourceDefs.getCalendarFinalName(this.m_sourceAttr.getAttr("exclude_calendar"))};
        HashMap<String, String> calAction = new HashMap<String, String>();
        for (int i = 0; i < calNames.length; ++i) {
            if (this.isEmptyValue(calNames[i]) || this.m_sourceDefs.getConvertedCalendarList().contains(calNames[i]) || this.m_sourceDefs.getExtendedCalendarConvertor().isExtendedCalendar(calNames[i])) continue;
            calNames[i] = (i == 1 ? "not-" : "") + calNames[i];
            calNames[i] = FieldValidation.instance().validateAndReturnFixedValue("DAYSCAL", calNames[i]);
            calAction.put("ACTENTTYPE", "CAL");
            calAction.put("JOBID", this.m_jobName);
            calAction.put("ACTENTNAME", calNames[i]);
            calAction.put("ACTSTATUS", "0");
            Reporter.addAction(calAction);
            calAction.clear();
            this.addMessage("INF4004", calNames[i]);
        }
    }

    private void addQRActions() {
        this.autosysQuantResources.addQRActions(Reporter.instance());
    }

    private boolean hasErrors() {
        for (String currMsg : this.m_messages) {
            if (!currMsg.contains(",E,")) continue;
            return true;
        }
        return false;
    }

    public boolean hasMessages() {
        return !this.m_messages.isEmpty();
    }

    public boolean isDSJob() {
        return this.isDSJob;
    }

    public void addAutoEdits(String key, String value) {
        this.m_autoedits.put(key, value);
    }

    public void addAllAutoEdits(Map<String, String> newAutoedits) {
        this.m_autoedits.putAll(newAutoedits);
    }

    public String getOriginalJobData() {
        String[] header = this.m_sourceAttr.getCsvHeader().split(",");
        StringBuilder jobData = new StringBuilder();
        for (String field : header) {
            jobData.append(String.format("%-20s\t: %s%s", field, this.m_sourceAttr.getAttr(field), "\r\n"));
        }
        return jobData.toString();
    }

    public void setM_rules() {
        this.m_rules = this.m_sourceDefs.getRules();
    }

    public IAttrHolder getSourceAttr() {
        return this.m_sourceAttr;
    }

    public SchedEntity.TYPE getType() {
        return this.m_type;
    }

    public HashMap<String, String> getJobAttr() {
        return this.m_jobAttr;
    }

    public void addAttribute(String key, String value) {
        this.getJobAttr().put(key, value);
    }

    public HandleBuiltinAutoEdits getHandleBuiltinAutoEdits() {
        return this.handleBuiltinAutoEdits;
    }

    void issueMessageForAddDestKillJob() {
        String message = SettingsBooleanKeys.isSaas() ? "WRN4076" : "WRN4055";
        this.m_sourceDefs.addGeneralMessage(message);
    }

    public void setZOSJob() {
        this.isDSJob = false;
    }

    public boolean isInSubFolder() {
        return this.m_parent != null && this.m_parent.hasParent();
    }

    public Set<Properties> getRBCs() {
        return this.m_RBCs;
    }

    public void setRBCs(Set<Properties> rbcs) {
        this.m_RBCs = rbcs;
    }
}

