/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.List;
import java.util.Properties;

public class AutosysHandleSuccessCodes {
    private String m_jobName;
    private List<Properties> onStmtList;
    private AutosysJob autosysJob;
    private IAttrHolder m_sourceAttr;

    public AutosysHandleSuccessCodes(AutosysJob autosysJob) {
        this.m_sourceAttr = autosysJob.getSourceAttr();
        this.m_jobName = autosysJob.getJobName();
        this.onStmtList = autosysJob.getOnStmt(true);
        this.autosysJob = autosysJob;
    }

    public void handleSuccessCodes() {
        String success_codes = this.m_sourceAttr.getAttr("success_codes");
        if (success_codes != null && !success_codes.equalsIgnoreCase("null")) {
            String[] tokens = success_codes.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                this.addSetToOKOnCompletionStatusStatment(tokens[i]);
            }
        }
    }

    private void addSetToOKOnCompletionStatusStatment(String completionStatus) {
        if (!completionStatus.trim().contains("-")) {
            this.addOnDoStatmentOnEQCompstatSetJobToOk(completionStatus);
        } else {
            this.autosysJob.addMessage("WRN4057", this.m_sourceAttr.getAttr("insert_job"), this.m_jobName, completionStatus);
        }
    }

    private void addOnDoStatmentOnEQCompstatSetJobToOk(String completionStatus) {
        if (!completionStatus.trim().equals("0")) {
            Properties tmpStatement = new Properties();
            tmpStatement.setProperty("CODE", String.format("COMPSTAT EQ %s", completionStatus));
            tmpStatement.setProperty("STMT", "*");
            tmpStatement.setProperty("ACTION", "OK");
            tmpStatement.setProperty("NAME", String.format("%s_CompletionStatus_%s", this.m_jobName, completionStatus));
            this.onStmtList.add(0, tmpStatement);
        }
    }
}

