/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.autosys.Dependency;
import com.bmc.ctmconvert.common.conditions.InConditionBuilder;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AutosysHandleCondtions {
    private final RulesDataSet rules;
    private final boolean isAsymmetricConvertNegativeCond;

    public AutosysHandleCondtions(RulesDataSet rules) {
        this.rules = rules;
        this.isAsymmetricConvertNegativeCond = AutosysHandleCondtions.isAsymmetricConvertNegativeCond(rules);
    }

    public void handleConditions(Dependency dep, Map<String, List<Properties>> controlResources, Map<String, List<Properties>> onDoStatements, Map<String, List<Properties>> inConditions, Map<String, List<Properties>> outConditions) {
        inConditions.computeIfAbsent(dep.getInJob(), k -> new ArrayList());
        outConditions.computeIfAbsent(dep.getOutJob(), k -> new ArrayList());
        dep.setCondType(dep.getCondType().toLowerCase());
        if (dep.getCondType().matches("\\s*(not ?running|n)\\s*")) {
            boolean symmetricalNotCondition;
            boolean bl = symmetricalNotCondition = dep.getInJob().equals(dep.getOutJob()) || AutosysDefs.conditionsMap.getOrDefault(dep.getOutJob(), "").contains("n(" + dep.getInJob() + ")");
            if (this.isAsymmetricConvertNegativeCond && !symmetricalNotCondition) {
                this.notRunningConditionByDependency(dep, inConditions, outConditions);
            } else {
                this.notRunningConditionByResources(dep, controlResources);
            }
        } else if (dep.getCondType().matches("\\s*(success|s)\\s*") || dep.getCondType().matches("\\s*(fail|failure|f|terminated|t)\\s*") || dep.getCondType().matches("\\s*(done|d)\\s*")) {
            this.handleSuccessFailDoneConditions(dep, onDoStatements, inConditions, outConditions);
        } else if (dep.getCondType().matches("\\s*(exitcode|e)\\s*")) {
            this.handleExitCodeCondition(dep, onDoStatements, inConditions);
        } else if (dep.getCondType().matches("\\s*(v|value|VALUE|V)\\s*")) {
            this.handleValueConditions(dep, inConditions);
        }
    }

    public static boolean isAsymmetricConvertNegativeCond(RulesDataSet rules) {
        return rules.getBooleanRule("Autosys rules", new String[]{"CONVERT_NEGATIVE_COND"});
    }

    private void handleValueConditions(Dependency dep, Map<String, List<Properties>> inConditions) {
        Properties inCondition = ((InConditionBuilder)((InConditionBuilder)new InConditionBuilder().setConditionName(dep.getOutJob())).setOdate("STAT")).build().getProperties();
        inConditions.computeIfAbsent(dep.getInJob(), k -> new ArrayList()).add(inCondition);
    }

    private void handleSuccessFailDoneConditions(Dependency dep, Map<String, List<Properties>> onDoStatements, Map<String, List<Properties>> inConditions, Map<String, List<Properties>> outConditions) {
        Properties outProps;
        String depName = dep.getDepName(this.rules);
        Properties inProps = new Properties();
        inProps.setProperty("AND_OR", dep.getOrAnd());
        inProps.setProperty("ODATE", "ODAT");
        inProps.setProperty("NAME", depName);
        if (dep.getParen() != null) {
            inProps.setProperty("OP", dep.getParen());
        }
        inConditions.get(dep.getInJob()).add(inProps);
        if (!dep.getCondType().matches("\\s*(fail|failure|f|terminated|t)\\s*")) {
            outProps = new Properties();
            outProps.setProperty("ODATE", "ODAT");
            outProps.setProperty("NAME", depName);
            outProps.setProperty("SIGN", "ADD");
            this.addIfAbsent(outConditions.get(dep.getOutJob()), outProps);
        }
        if (dep.getCondType().matches("\\s*(fail|failure|f|terminated|t)\\s*") || dep.getCondType().matches("\\s*(done|d)\\s*")) {
            outProps = new Properties();
            outProps.put("STMT", "*");
            outProps.put("CODE", dep.generateCompStatCode());
            outProps.put("ACTION", "DOCOND");
            outProps.put("NAME", depName);
            outProps.setProperty("ODATE", "ODAT");
            outProps.put("SIGN", "ADD");
            List onDo = onDoStatements.computeIfAbsent(dep.getOutJob(), k -> new ArrayList());
            this.addIfAbsent(onDo, outProps);
        }
    }

    private void notRunningConditionByDependency(Dependency dep, Map<String, List<Properties>> inConditions, Map<String, List<Properties>> outConditions) {
        String depName = "N_" + dep.getDepName(this.rules);
        Properties inProps = new Properties();
        inProps.setProperty("AND_OR", dep.getOrAnd());
        inProps.setProperty("ODATE", "ODAT");
        inProps.setProperty("NAME", depName);
        inProps.setProperty("notRunningWith", "Y");
        if (dep.getParen() != null) {
            inProps.setProperty("OP", dep.getParen());
        }
        inConditions.get(dep.getInJob()).add(inProps);
        Properties outProps = new Properties();
        outProps.setProperty("ODATE", "ODAT");
        outProps.setProperty("NAME", depName);
        outProps.setProperty("SIGN", "ADD");
        this.addIfAbsent(outConditions.get(dep.getOutJob()), outProps);
    }

    private void notRunningConditionByResources(Dependency dep, Map<String, List<Properties>> controlResources) {
        List outJobProp;
        String controlName = dep.getInJob();
        List inJobProp = controlResources.computeIfAbsent(dep.getInJob(), k -> new ArrayList());
        if (inJobProp.stream().noneMatch(p -> p.get("NAME").equals(controlName))) {
            Properties p2 = new Properties();
            p2.put("NAME", controlName);
            p2.put("TYPE", "E");
            inJobProp.add(p2);
        }
        if ((outJobProp = controlResources.computeIfAbsent(dep.getOutJob(), k -> new ArrayList())).stream().noneMatch(p -> p.get("NAME").equals(controlName))) {
            Properties p3 = new Properties();
            p3.put("NAME", controlName);
            p3.put("TYPE", "S");
            outJobProp.add(p3);
        }
    }

    private void handleExitCodeCondition(Dependency dep, Map<String, List<Properties>> onDoStatements, Map<String, List<Properties>> inCondtions) {
        String depName = dep.getDepName(this.rules);
        Properties stmtProps = new Properties();
        Properties incondProps = new Properties();
        if (!inCondtions.containsKey(dep.getInJob())) {
            inCondtions.put(dep.getInJob(), new ArrayList());
        }
        if (!onDoStatements.containsKey(dep.getOutJob())) {
            onDoStatements.put(dep.getOutJob(), new ArrayList());
        }
        stmtProps.put("STMT", "*");
        stmtProps.put("CODE", dep.generateCompStatCode());
        stmtProps.put("ACTION", "DOCOND");
        stmtProps.put("NAME", depName);
        stmtProps.put("SIGN", "ADD");
        stmtProps.put("ODATE", "ODAT");
        incondProps.setProperty("AND_OR", dep.getOrAnd());
        incondProps.setProperty("ODATE", "ODAT");
        incondProps.setProperty("NAME", depName);
        if (dep.getParen() != null) {
            incondProps.setProperty("OP", dep.getParen());
        }
        this.addOnDoStatement(dep.getOutJob(), stmtProps, onDoStatements);
        inCondtions.get(dep.getInJob()).add(incondProps);
    }

    private void addOnDoStatement(String jobName, Properties stmtProps, Map<String, List<Properties>> onDoStatements) {
        List<Properties> onDo = onDoStatements.get(jobName);
        if (this.rules.getStringRule("Autosys rules", new String[]{"ConvertToFormat"}).equals("{Job/Folder Name}_Status")) {
            this.addIfAbsent(onDo, stmtProps);
        } else {
            onDo.add(stmtProps);
        }
    }

    private void addIfAbsent(List<Properties> properties, Properties newProp) {
        if (properties.stream().noneMatch(oldProp -> oldProp.get("NAME").equals(newProp.get("NAME")))) {
            properties.add(newProp);
        }
    }
}

