/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SchedEntityUtils;
import com.bmc.ctmconvert.common.message.MessageIssuer;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.shouts.ShoutsGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class AutosysGenerateShouts {
    private IAttrHolder mSourceAttr;
    private String mJobName;
    private String timeFrom;
    private final List<Properties> mShouts = new ArrayList<Properties>();
    private String mOriginalJobName;
    private AutosysJob job;

    public void generateShouts(IAttrHolder mSourceAttr, AutosysJob job, String timeFrom, MessageIssuer issueGeneralMassageAddDestKillJob) {
        this.mSourceAttr = mSourceAttr;
        this.job = job;
        this.mJobName = job.getJobName();
        this.mOriginalJobName = job.getOriginalJobName();
        this.timeFrom = timeFrom;
        this.shoutOnRunTime(issueGeneralMassageAddDestKillJob);
        this.shoutOnFail();
        this.shoutOnMustStartCompleteTime();
    }

    private void shoutOnFail() {
        String alarmIfFail = this.mSourceAttr.getAttr("alarm_if_fail").trim();
        if (!alarmIfFail.equals("1")) {
            return;
        }
        Properties tmpProps = new Properties();
        tmpProps.setProperty("DEST", "EM");
        tmpProps.setProperty("MESSAGE", String.format("Job %s has failed", this.mJobName));
        tmpProps.setProperty("URGENCY", "R");
        tmpProps.setProperty("WHEN", "NOTOK");
        this.mShouts.add(tmpProps);
    }

    private void shoutOnRunTime(MessageIssuer issueGeneralMassegeAddDestKilljob) {
        this.generateShoutOnRunTime("max_run_alarm", "EM", "%s execution time %s %s minutes", ">");
        this.generateShoutOnRunTime("min_run_alarm", "EM", "%s execution time %s %s minutes", "<");
        if (SettingsBooleanKeys.isSaas()) {
            this.handleTermRunTimeSaas(issueGeneralMassegeAddDestKilljob);
        } else {
            this.handleTermRunTimeOnPrem(issueGeneralMassegeAddDestKilljob);
        }
    }

    private void handleTermRunTimeSaas(MessageIssuer issueGeneralMassegeAddDestKilljob) {
        if (SchedEntityUtils.isOsJob((SchedEntity)this.job)) {
            this.issueMessageWhenGeneratingShoutIsSuccessful(issueGeneralMassegeAddDestKilljob, "NotifyScriptLnx", "KILLJOB %%%%ORDERID");
        } else {
            this.issueMessageWhenGeneratingShoutIsSuccessful(() -> this.job.addMessage("WRN4064", this.mOriginalJobName, this.mJobName), "EM", "Job %%%%JOBNAME %%%%ORDERID runs for too long, and should be killed.");
        }
    }

    private void issueMessageWhenGeneratingShoutIsSuccessful(MessageIssuer messageIssuer, String destination, String message) {
        boolean successfullyGeneratedShout = this.generateShoutForTermRunTime(destination, message);
        if (successfullyGeneratedShout) {
            messageIssuer.issueMessage();
        }
    }

    private boolean generateShoutForTermRunTime(String dest, String shoutMessage) {
        return this.generateShoutOnRunTime("term_run_time", dest, shoutMessage, ">");
    }

    private void handleTermRunTimeOnPrem(MessageIssuer issueGeneralMassegeAddDestKilljob) {
        this.issueMessageWhenGeneratingShoutIsSuccessful(issueGeneralMassegeAddDestKilljob, "KILLJOB", "%%%%ORDERID");
    }

    private boolean generateShoutOnRunTime(String key, String dest, String shoutMessage, String rel) {
        String valueStr = this.mSourceAttr.getAttr(key).trim();
        if (valueStr.equals("NULL") || valueStr.isEmpty()) {
            return false;
        }
        if (!valueStr.matches("^[0-9]+$")) {
            this.job.addMessage("WRN4005", key, valueStr);
            return false;
        }
        if (Integer.parseInt(valueStr) > 999) {
            String msgidInvalidTermRunTimeLimit = key.equals("term_run_time") ? "WRN4061" : "WRN4060";
            this.job.addMessage(msgidInvalidTermRunTimeLimit, this.mOriginalJobName, this.mJobName, valueStr);
            valueStr = "999";
        }
        Properties tmpProps = new ShoutsGenerator().generateShoutOnRunTime(dest, String.format(shoutMessage, this.mJobName, rel, valueStr), rel, valueStr);
        this.mShouts.add(tmpProps);
        return true;
    }

    private void shoutOnMustStartCompleteTime() {
        this.generateShoutOnMustStartCompleteTime("must_start_times", "LATESUB", "submitted", "WRN4052");
        this.generateShoutOnMustStartCompleteTime("must_complete_times", "LATETIME", "finished", "WRN4053");
    }

    private void generateShoutOnMustStartCompleteTime(String shoutType, String shoutWhen, String shoutMessage, String shoutWarningMessage) {
        Object shoutTimeStr;
        String valueStr = this.mSourceAttr.getAttr(shoutType).trim();
        if (valueStr.equals("NULL") || valueStr.isEmpty()) {
            return;
        }
        if (valueStr.startsWith("\"")) {
            valueStr = valueStr.substring(1, valueStr.length() - 1);
        }
        if (valueStr.startsWith("+")) {
            int relativeTime = Integer.parseInt(valueStr);
            int startTime = 0;
            if (this.timeFrom != null) {
                startTime = Integer.parseInt(this.timeFrom.substring(0, 2)) * 60 + Integer.parseInt(this.timeFrom.substring(2));
            }
            int shoutTime = startTime + relativeTime;
            int shoutHour = shoutTime / 60;
            Integer shoutMin = shoutTime - shoutHour * 60;
            shoutTimeStr = String.format("%02d%02d", shoutHour, shoutMin);
        } else {
            shoutTimeStr = valueStr.replace(":", "");
        }
        if (((String)shoutTimeStr).length() == 3) {
            shoutTimeStr = "0" + (String)shoutTimeStr;
        }
        if (this.validateShoutTimeIsOnlyDigits(shoutType, (String)(shoutTimeStr = this.calculateShoutTimeDoesNotExceedAllowedValue(shoutWarningMessage, (String)shoutTimeStr)))) {
            return;
        }
        Properties tmpProps = new Properties();
        tmpProps.setProperty("DEST", "EM");
        tmpProps.setProperty("MESSAGE", String.format("Job %s not %s by %s", this.mJobName, shoutMessage, shoutTimeStr));
        tmpProps.setProperty("TIME", (String)shoutTimeStr);
        tmpProps.setProperty("URGENCY", "R");
        tmpProps.setProperty("WHEN", shoutWhen);
        this.mShouts.add(tmpProps);
    }

    private boolean validateShoutTimeIsOnlyDigits(String shoutType, String shoutTimeStr) {
        if (!shoutTimeStr.matches("^[0-9]+$") || shoutTimeStr.length() != 4) {
            this.job.addMessage("WRN4005", shoutType, shoutTimeStr);
            return true;
        }
        return false;
    }

    private String calculateShoutTimeDoesNotExceedAllowedValue(String shoutWarningMessage, String shoutTime) {
        String validatedShoutTime = shoutTime;
        String shoutTimeHour = shoutTime.substring(0, 2);
        if (shoutTimeHour.compareTo("24") >= 0) {
            int validatedShoutTimeHour = Integer.parseInt(shoutTimeHour) % 24;
            validatedShoutTime = String.format("%02d%s", validatedShoutTimeHour, shoutTime.substring(2));
            this.job.addMessage(shoutWarningMessage, this.mJobName, shoutTime, validatedShoutTime);
        }
        return validatedShoutTime;
    }

    public List<Properties> getShouts() {
        return this.mShouts;
    }
}

