/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.FileTransferConvertor;

public class AutosysFTPConvertor
extends FileTransferConvertor {
    public AutosysFTPConvertor(AutosysJob autosysJob) {
        super(autosysJob);
    }

    @Override
    public void convert() {
        super.convert();
        this.addFileTransferAutoedits();
        this.addConnectionProfile();
        this.addMessage();
    }

    private void addMessage() {
        this.autosysJob.addMessage("WRN4058", this.autosysJob.getJobName());
    }

    private void addFileTransferAutoedits() {
        String type = this.getFtpMode();
        this.checkAndInsertAutoedit("%%FTP-TYPE1", type);
        String direction = this.getDirection("ftp_transfer_direction");
        this.checkAndInsertAutoedit("%%FTP-UPLOAD1", direction);
        this.checkAndInsertAutoedit("%%FTP-LPATH1", this.sourceAttr.getAttr("ftp_local_name"));
        this.checkAndInsertAutoedit("%%FTP-RPATH1", this.sourceAttr.getAttr("ftp_remote_name"));
    }

    private String getFtpMode() {
        String type = this.sourceAttr.getAttr("ftp_transfer_type");
        if (type.equalsIgnoreCase("b")) {
            type = "I";
        }
        return type;
    }

    private void addConnectionProfile() {
        String connectionProfile = "";
        String ftpLocalUser = this.sourceAttr.getAttr("ftp_local_user");
        String ftpServerName = this.sourceAttr.getAttr("ftp_server_name");
        if (ftpLocalUser.equals("NULL") || ftpServerName.equals("NULL")) {
            connectionProfile = "DEF_CON_PROFILE";
            this.autoedits.put("%%FTP-ACCOUNT", connectionProfile);
            return;
        }
        connectionProfile = this.converteToLegalCP(ftpLocalUser, ftpServerName);
        this.autoedits.put("%%FTP-ACCOUNT", connectionProfile);
    }
}

