/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutosysEnvVars {
    private IAttrHolder sourceAttrHolder;
    private LinkedHashMap<String, String> m_autoedits;
    private static final Pattern VARIABLES_PATTERN = Pattern.compile("[, ]*(?<KEY>(\"[^=]+\")|([^=]+))=(?<VALUE>(\"[^\"]+\")|([^,]+))");

    public AutosysEnvVars(IAttrHolder sourceAttrHolder, LinkedHashMap<String, String> m_autoedits) {
        this.sourceAttrHolder = sourceAttrHolder;
        this.m_autoedits = m_autoedits;
    }

    public void generateEnvVars() {
        String envVars = this.sourceAttrHolder.getAttr("envvars");
        if (envVars != null && !envVars.equals("NULL")) {
            Matcher matcher = VARIABLES_PATTERN.matcher(envVars);
            while (matcher.find()) {
                String key = GlobalFunctions.removeQuotesIfNeeded((String)matcher.group("KEY"));
                String value = GlobalFunctions.removeQuotesIfNeeded((String)matcher.group("VALUE"));
                String variableName = "%%" + key;
                this.m_autoedits.put(variableName, value);
            }
        }
    }
}

