/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.AutosysHandleCondtions;
import com.bmc.ctmconvert.autosys.AutosysJob;
import com.bmc.ctmconvert.autosys.AutosysJobFlowHandler;
import com.bmc.ctmconvert.autosys.AutosysSchedulingSettingsConvertor;
import com.bmc.ctmconvert.autosys.CalendarsFile;
import com.bmc.ctmconvert.autosys.Dependency;
import com.bmc.ctmconvert.autosys.ExtendedCalendarConvertor;
import com.bmc.ctmconvert.autosys.GlobalVariables;
import com.bmc.ctmconvert.autosys.JilTable;
import com.bmc.ctmconvert.autosys.TimezoneConvert;
import com.bmc.ctmconvert.autosys.jobtypes.AutosysBoxSuccessFailureAssistingJobsBuilder;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.TopLevelAttrHolder;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.vc.FieldValidation;
import dependencies.CleanUpConditionHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AutosysDefs
implements SourceDefinitions {
    public static final String DUMMY_CONDITION_NAME = "DUMMY";
    private JilTable jil;
    private final Map<String, Map<String, String>> jobVariables = new HashMap<String, Map<String, String>>();
    private final HashMap<String, List<Map<String, String>>> jobActions = new HashMap();
    private Boolean isOrCond = null;
    private Boolean isIncludeType = null;
    private final RulesDataSet rules;
    private final HashMap<String, List<Properties>> controlRes = new HashMap();
    private final Map<String, List<Properties>> inconds = new HashMap<String, List<Properties>>();
    private final Map<String, List<Properties>> outconds = new HashMap<String, List<Properties>>();
    private final Map<String, List<Properties>> onStatements = new HashMap<String, List<Properties>>();
    private final Map<String, List<String>> jobsMessages = new HashMap<String, List<String>>();
    private Map<String, AttrHolderList> parents = new HashMap<String, AttrHolderList>();
    private final Map<String, AttrHolderList> filteredParents = new HashMap<String, AttrHolderList>();
    private final ArrayList<String> deadEntities = new ArrayList();
    private List<String> convertedCals = null;
    private final TimezoneConvert timeZoneConvert;
    private final ArrayList<String> messages = new ArrayList();
    private final ArrayList<String> calGeneralMessages = new ArrayList();
    private CalendarsFile calendarsFile;
    public AutosysSchedulingSettingsConvertor autosysSchedulingConvertor;
    private final ExtendedCalendarConvertor extendedCalendarConvertor;
    private final Map<IAttrHolder, List<IAttrHolder>> predecessorsMap = new HashMap<IAttrHolder, List<IAttrHolder>>();
    static Map<String, String> conditionsMap = new HashMap<String, String>();
    private final Map<String, IAttrHolder> attrMap = new HashMap<String, IAttrHolder>();

    public TimezoneConvert getTimeZoneConvert() {
        return this.timeZoneConvert;
    }

    public Map<String, AttrHolderList> getParents() {
        return this.parents;
    }

    public AutosysDefs(RulesDataSet rules, TimezoneConvert timeZoneConvert, InputStream datasource, OutputStream filteredCsvPath, InputStream calendarsInputStream, InputStream globalVariables, ExtendedCalendarConvertor extendedCalendarConvertor) {
        this.rules = rules;
        this.timeZoneConvert = timeZoneConvert;
        this.extendedCalendarConvertor = extendedCalendarConvertor;
        this.initialize(datasource, filteredCsvPath, calendarsInputStream, globalVariables);
    }

    protected void initialize(InputStream datasource, OutputStream filteredCsvPath, InputStream calendarsInputStream, InputStream globalVariables) {
        this.loadJilFile(datasource);
        this.loadCalendars(calendarsInputStream);
        this.createGlobalVariablesActions(globalVariables);
        this.issueErrorForOrphanJobs();
        conditionsMap = new HashMap<String, String>();
        this.calculateNotRunningConditions("NULL");
        this.createDependencies("NULL");
        if (AutosysDefs.isCleanUpChecked(this.rules)) {
            this.addCleanupConditions();
        }
        this.handleStandaloneJobs();
        this.createTags("NULL");
        this.applyFilter("NULL");
        this.jil.saveCsv(this.filteredParents, filteredCsvPath);
        this.parents = this.filteredParents;
    }

    private void createGlobalVariablesActions(InputStream globalVariablesStream) {
        List<Map<String, String>> actions = new GlobalVariables(globalVariablesStream).toActions();
        actions.forEach(Reporter::addAction);
    }

    private void loadJilFile(InputStream datasource) {
        this.jil = new JilTable(this);
        this.jil.load(datasource);
    }

    private void loadCalendars(InputStream calendarsInputStream) {
        boolean hasExtended;
        boolean bl = hasExtended = !this.getExtendedCalendarConvertor().getAllConvertedCalendars().isEmpty();
        if (calendarsInputStream != null || hasExtended) {
            try {
                this.calendarsFile = new CalendarsFile(Params.instance().getDatacenterName(), calendarsInputStream, this.getExtendedCalendarConvertor(), this::addGeneralMessage);
                this.convertedCals = this.calendarsFile.convert();
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        } else {
            GlobalFunctions.getTempCalendarFilePath().forEach(calendarFile -> {
                if (GlobalFunctions.isFileExist((String)calendarFile)) {
                    File tmpFile = new File((String)calendarFile);
                    tmpFile.delete();
                }
            });
            this.convertedCals = new ArrayList<String>();
        }
    }

    public static boolean isCleanUpChecked(RulesDataSet rules) {
        boolean isAtoB = "{Job/Folder Name}-TO-{TargetJob:Job/Folder Name}".equals(rules.getStringRule("Autosys rules", new String[]{"ConvertToFormat"}));
        return isAtoB && rules.getBooleanRule("Autosys rules", new String[]{"CLEANUP_CONDITIONS"}) != false;
    }

    private void addCleanupConditions() {
        CleanUpConditionHandler cleanUpConditionHandler = new CleanUpConditionHandler();
        this.inconds.forEach((job, conditions) -> {
            List outConditions = cleanUpConditionHandler.getCleanUpOutConds(conditions);
            if (!outConditions.isEmpty()) {
                if (this.outconds.containsKey(job)) {
                    this.outconds.get(job).addAll(outConditions);
                } else {
                    this.outconds.put((String)job, outConditions);
                }
            }
        });
    }

    public static List<Properties> removeDummyConditions(Collection<Properties> conditionsWithDummy) {
        return conditionsWithDummy.stream().filter(condition -> !condition.containsKey(DUMMY_CONDITION_NAME)).collect(Collectors.toList());
    }

    public String getCalendarFinalName(String name) {
        if (this.calendarsFile != null) {
            name = this.calendarsFile.getCalendarFinalName(name);
        }
        return name;
    }

    private void issueErrorForOrphanJobs() {
        for (String parentBoxName : this.parents.keySet()) {
            if (parentBoxName.equals("NULL") || parentBoxName.isEmpty() || !this.parentBoxNotFound(parentBoxName)) continue;
            List<String> childrenNames = this.getChildrenNames(parentBoxName);
            Reporter.addMessage(this.getGeneralMessages(), (String)"ERR4002", (String)parentBoxName, (String[])new String[]{parentBoxName, childrenNames.toString(), String.valueOf(childrenNames.size())});
        }
    }

    private List<String> getChildrenNames(String parentBoxName) {
        return this.getParents().get(parentBoxName).stream().map(job -> job.getAttr(this.getEntNameFieldName())).collect(Collectors.toList());
    }

    private boolean parentBoxNotFound(String parentBoxName) {
        return !this.jil.isExplicitlyDefined(parentBoxName);
    }

    public List<String> getConvertedCalendarList() {
        return this.convertedCals == null ? new ArrayList() : this.convertedCals;
    }

    public void applyFilter(String root) {
        AttrHolderList children = this.getChildren(root);
        if (children == null) {
            return;
        }
        for (IAttrHolder child : children) {
            String jobName = child.getAttr(this.getEntNameFieldName());
            if (this.isFiltered(child)) {
                if (this.deadEntities.contains(root)) {
                    root = "NULL";
                    Reporter.addMessage((List)this.jobsMessages.computeIfAbsent(jobName, k -> new ArrayList()), (String)"INF4005", (String)jobName, (String[])new String[]{child.getAttr("box_name")});
                }
                this.filteredParents.computeIfAbsent(root, k -> new AttrHolderList()).add((Object)child);
            } else {
                this.deadEntities.add(jobName);
            }
            this.applyFilter(jobName);
        }
    }

    private boolean isFiltered(IAttrHolder job) {
        boolean rc = false;
        boolean isInclude = this.getIncludeType();
        boolean isOrCondition = this.getOrCondition();
        ArrayList filterConds = this.rules.getFilterHandler().getConditions();
        if (filterConds == null || filterConds.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : filterConds) {
            boolean funcRC;
            String field = (String)entry.getKey();
            String regVal = (String)entry.getValue();
            String jobVal = job.getAttr(field);
            if (field.equalsIgnoreCase("insert_job")) {
                String jobName = job.getAttr("insert_job");
                funcRC = this.checkDescendant(regVal, jobName);
            } else {
                funcRC = this.matchWildcard(jobVal, regVal);
            }
            if (funcRC) {
                if (isOrCondition) {
                    rc = true;
                    break;
                }
                rc = true;
                continue;
            }
            if (isOrCondition) {
                rc = false;
                continue;
            }
            rc = false;
            break;
        }
        if (isInclude) {
            return rc;
        }
        return !rc;
    }

    private boolean checkDescendant(String expr, String toTest) {
        if (this.matchWildcard(toTest, expr)) {
            return true;
        }
        String desecndantParentBoxName = this.getParentByEntName(toTest);
        if (desecndantParentBoxName.equals("")) {
            return false;
        }
        if (this.matchWildcard(desecndantParentBoxName, expr)) {
            return true;
        }
        return this.checkDescendant(expr, desecndantParentBoxName);
    }

    public Set<Properties> getEntTags(String entId) {
        return this.autosysSchedulingConvertor.getEntTags(entId);
    }

    public void addEntTags(String entId, List<Properties> tags) {
        this.autosysSchedulingConvertor.addEntTags(entId, tags);
    }

    public Set<Properties> createTags(String root) {
        if (this.autosysSchedulingConvertor == null) {
            this.autosysSchedulingConvertor = new AutosysSchedulingSettingsConvertor(this, this.getExtendedCalendarConvertor());
        }
        return this.autosysSchedulingConvertor.createTags("NULL");
    }

    private String getParentByEntName(String descendant) {
        for (String key : this.parents.keySet()) {
            AttrHolderList children = this.parents.get(key);
            for (IAttrHolder child : children) {
                String childName = child.getAttr(this.getEntNameFieldName());
                if (!childName.equalsIgnoreCase(descendant)) continue;
                return key;
            }
        }
        return "";
    }

    private boolean getIncludeType() {
        if (this.isIncludeType == null) {
            this.isIncludeType = this.rules.getFilterHandler().isInclude();
        }
        return this.isIncludeType;
    }

    private boolean getOrCondition() {
        if (this.isOrCond == null) {
            this.isOrCond = this.rules.getFilterHandler().isOr();
        }
        return this.isOrCond;
    }

    private boolean matchWildcard(String value, String expr) {
        String regExp = expr.replace("\\*", ".*");
        regExp = regExp.replace("\\?", ".");
        return value.matches(regExp);
    }

    public void finalize_() {
        this.parents.clear();
        this.jil = null;
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return this.parents.get(parentEntityId);
    }

    public AttrHolderList getTopLevelEntities() {
        return this.getChildren("NULL");
    }

    private void handleStandaloneJobs() {
        AttrHolderList standaloneJobs;
        if (this.getTopLevelEntities() != null && !(standaloneJobs = this.removeStandaloneJobsFromTopLevelEntities()).isEmpty()) {
            if (this.isStandAloneJobsGrouped()) {
                AttrHolderList rest = this.createFoldersForFlows(standaloneJobs);
                this.createSmartFolder("StandaloneJobs", rest);
            } else {
                this.createSmartFolderPerStandaloneJob(standaloneJobs);
            }
        }
    }

    private boolean isStandAloneJobsGrouped() {
        return this.rules.getStringRule("Autosys rules", new String[]{"GROUP_STANDALONE_JOBS_IN_ONE_TABLE"}).equals("OneTable");
    }

    private void createSmartFolderPerStandaloneJob(AttrHolderList standaloneJobs) {
        for (IAttrHolder attr : standaloneJobs) {
            AttrHolderList subJobs = new AttrHolderList();
            subJobs.add((Object)attr);
            String folderName = "Folder_" + FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", attr.getAttr("insert_job"), true, null, null, new ArrayList());
            this.createSmartFolder(folderName, subJobs);
        }
    }

    public static Properties createDummyCondition() {
        Properties dummyCond = new Properties();
        dummyCond.setProperty(DUMMY_CONDITION_NAME, "I AM A DUMMY CONDITION");
        return dummyCond;
    }

    private void createSmartFolder(String name, AttrHolderList subJobs) {
        this.createSmartFolder(name, subJobs, Collections.emptyMap());
    }

    private void createSmartFolder(String name, AttrHolderList subJobs, Map<String, String> smartFolderAttributes) {
        HashMap<String, Integer> jilHeaders = this.getJilHeaders();
        String[] values = this.createStandaloneJobsContainerRecord(name, jilHeaders, smartFolderAttributes);
        AttrHolder standaloneJobsContainer = new AttrHolder(values, jilHeaders);
        this.parents.put(name, this.addBoxNameForEntities(name, subJobs));
        this.getTopLevelEntities().add((Object)standaloneJobsContainer);
    }

    private String[] createStandaloneJobsContainerRecord(String name, HashMap<String, Integer> jilHeaders, Map<String, String> smartFolderAttributes) {
        Map<String, String> standaloneJobsContainerRecord = Map.of("insert_job", name, "alarm_if_fail", "1", "date_conditions", "1", "days_of_week", "ALL", "job_type", "b", "permission", "wx");
        Map<String, String> combined = Stream.concat(smartFolderAttributes.entrySet().stream(), standaloneJobsContainerRecord.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a.equals("NULL") || a.isEmpty() ? b : a));
        Stream headersSortedByIndex = jilHeaders.entrySet().stream().sorted(Map.Entry.comparingByValue());
        return (String[])headersSortedByIndex.map(Map.Entry::getKey).map(header -> combined.getOrDefault(header, "NULL")).toArray(String[]::new);
    }

    private AttrHolderList createFoldersForFlows(AttrHolderList topLevelEntities) {
        kotlin.Pair<List<Set<IAttrHolder>>, AttrHolderList> result = AutosysJobFlowHandler.extractFlows(topLevelEntities);
        List jobsInFlows = (List)result.getFirst();
        AttrHolderList restOfJobs = (AttrHolderList)result.getSecond();
        List<AutosysJobFlowHandler.Flow> flows = jobsInFlows.stream().map(AutosysJobFlowHandler.Flow::new).toList();
        for (AutosysJobFlowHandler.Flow flow : flows) {
            Optional<IAttrHolder> firstJobInFlow = Optional.ofNullable(flow.getFirstJobInFlow());
            firstJobInFlow.ifPresent(firstJob -> {
                String folderName = firstJob.getAttr("insert_job");
                Map<String, String> schedulingAttributesFromFirstJob = this.schedulingAttributesOf((IAttrHolder)firstJob);
                this.createSmartFolder(folderName + "_flow", flow.getJobs(), schedulingAttributesFromFirstJob);
            });
        }
        return restOfJobs;
    }

    private Map<String, String> schedulingAttributesOf(IAttrHolder job) {
        List<String> schedulingAttributes = List.of("date_conditions", "days_of_week", "exclude_calendar", "run_calendar", "timezone", "run_window", "start_mins", "start_times");
        return schedulingAttributes.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((IAttrHolder)job).getAttr(arg_0)));
    }

    public HashMap<String, Integer> getJilHeaders() {
        return this.jil.getHeaders();
    }

    private AttrHolderList addBoxNameForEntities(String name, AttrHolderList subJobs) {
        for (IAttrHolder entity : subJobs) {
            entity.setAttr("box_name", name);
        }
        return subJobs;
    }

    public boolean isStandaloneJob(IAttrHolder entity) {
        boolean isHasChildren = entity instanceof TopLevelAttrHolder ? this.hasChildren(((TopLevelAttrHolder)entity).getIdValue()) : this.hasChildren(entity.getAttr(this.getIdFieldName()));
        return !isHasChildren && !this.isContainerEntity(entity);
    }

    public void init() {
    }

    public AutosysJob spawnJob(String tableName, IAttrHolder attributes) {
        if (tableName == null || tableName.isEmpty()) {
            tableName = attributes.getAttr(this.getEntNameFieldName());
        }
        return AutosysJob.createAutosysJob(attributes, this);
    }

    public Map<IAttrHolder, List<IAttrHolder>> getPredecessorsMap() {
        return this.predecessorsMap;
    }

    public AutosysJob spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return AutosysJob.createAutosysJob((AutosysJob)parent, attributes, this);
    }

    public String getIdFieldName() {
        return "insert_job";
    }

    public boolean hasChildren(String entId) {
        return this.parents.containsKey(entId);
    }

    public String getEntNameFieldName() {
        return "insert_job";
    }

    public String getParentEntFieldName() {
        return "box_name";
    }

    private void calculateNotRunningConditions(String root) {
        for (IAttrHolder child : this.parents.getOrDefault(root, new AttrHolderList())) {
            String rawConditions = child.getAttr("condition");
            String jobName = child.getAttr("insert_job");
            if (rawConditions.contains("n(")) {
                conditionsMap.put(jobName, this.normalizeOrAnd(rawConditions));
            }
            this.calculateNotRunningConditions(jobName);
        }
    }

    public void createDependencies(String root) {
        if (this.hasChildren(root)) {
            AutosysHandleCondtions handleConditions = new AutosysHandleCondtions(this.rules);
            AttrHolderList children = this.getChildren(root);
            for (IAttrHolder child : children) {
                String rawDependencies = child.getAttr("condition");
                rawDependencies = this.normalizeOrAnd(rawDependencies);
                String jobName = child.getAttr("insert_job");
                this.handleEntitiyConditions(handleConditions, "(and|AND|OR|or|&&|&|\\|)", rawDependencies, jobName);
                this.convertBoxSuccessFailure(handleConditions, child);
                this.cleanDummyDeps(jobName);
                this.createDependencies(jobName);
            }
        }
    }

    private void convertBoxSuccessFailure(AutosysHandleCondtions handleCondtions, IAttrHolder child) {
        this.handleBoxSuccessFail(handleCondtions, child, "box_success");
        this.handleBoxSuccessFail(handleCondtions, child, "box_failure");
    }

    public IAttrHolder getJobAttrByJobName(String jobName) {
        if (this.attrMap.containsKey(jobName)) {
            return this.attrMap.get(jobName);
        }
        for (AttrHolderList jobList : this.parents.values()) {
            for (IAttrHolder job : jobList) {
                if (!job.getAttr("insert_job").equals(jobName)) continue;
                this.attrMap.put(jobName, job);
                return job;
            }
        }
        return null;
    }

    private void handleEntitiyConditions(AutosysHandleCondtions handleCondtions, String opsSubExpr, String rawDependencies, String jobName) {
        this.checkNestedParentheses(rawDependencies, jobName);
        this.jobsMessages.computeIfAbsent(jobName, k -> new ArrayList());
        String[] tokens = rawDependencies.split("\\s+" + opsSubExpr + "\\s+");
        for (int i = 0; i < tokens.length && !rawDependencies.equals("NULL") && rawDependencies.length() != 0; ++i) {
            boolean validDep;
            Dependency currDep = new Dependency(tokens[i]);
            currDep.setInJob(jobName);
            if (!currDep.isValid) {
                Reporter.addMessage(this.jobsMessages.get(jobName), (String)"WRN4007", (String)jobName, (String[])new String[]{jobName, tokens[i]});
                this.addDummyDep(currDep);
                continue;
            }
            currDep.handleCrossInstanceCond(this.jobsMessages, this.jobActions);
            if (currDep.isLookbackDep()) {
                this.handleLookBackConditions(jobName, currDep);
            }
            if (i + 1 < tokens.length) {
                if (rawDependencies.contains(tokens[i] + " or " + tokens[i + 1])) {
                    currDep.setOrAnd("OR");
                } else {
                    currDep.setOrAnd("AND");
                }
            }
            if (validDep = this.isValidDep(currDep)) {
                handleCondtions.handleConditions(currDep, this.controlRes, this.onStatements, this.inconds, this.outconds);
                continue;
            }
            this.addDummyDep(currDep);
        }
    }

    private void handleLookBackConditions(String jobName, Dependency currDep) {
        Pair<String, String> lookBackDetails = currDep.getLookBackDetails();
        String lookBackVariableName = "%%LEADTM_" + (String)lookBackDetails.getKey();
        List jobMessages = this.jobsMessages.computeIfAbsent(jobName, k -> new ArrayList());
        String validatedLookBackVariableName = FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", lookBackVariableName, true, "look back condition", jobName, jobMessages);
        String lookBackVariableValue = (String)lookBackDetails.getValue();
        this.jobVariables.computeIfAbsent(jobName, k -> {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put(validatedLookBackVariableName, lookBackVariableValue);
            return variables;
        });
    }

    private String normalizeOrAnd(String rawDependencies) {
        rawDependencies = rawDependencies.trim();
        rawDependencies = rawDependencies.replaceAll("[ \t]+", " ");
        rawDependencies = rawDependencies.replace(" OR ", " or ");
        rawDependencies = rawDependencies.replace(" AND ", " and ");
        rawDependencies = rawDependencies.replaceAll("\\s*\\|\\s*", " or ");
        rawDependencies = rawDependencies.replaceAll("\\s*&&\\s*", " and ");
        rawDependencies = rawDependencies.replaceAll("\\s*&\\s*", " and ");
        return rawDependencies;
    }

    private boolean isValidDep(Dependency currDep) {
        boolean validDep = true;
        if (this.hasChildren(currDep.getOutJob()) && currDep.getCondType().matches("\\s*(exitcode|e)\\s*")) {
            this.jobsMessages.computeIfAbsent(currDep.getOutJob(), k -> new ArrayList());
            Reporter.addMessage(this.jobsMessages.get(currDep.getOutJob()), (String)"WRN4006", (String)currDep.getInJob(), (String[])new String[]{"exitcode condition", currDep.getOutJob()});
            validDep = false;
        }
        return validDep;
    }

    private void checkNestedParentheses(String rawDependencies, String jobname) {
        int parenthesisCount = 0;
        for (int i = 0; i < rawDependencies.length() - 1; ++i) {
            if (rawDependencies.charAt(i) == '(') {
                ++parenthesisCount;
            }
            if (rawDependencies.charAt(i) == ')') {
                --parenthesisCount;
            }
            if (parenthesisCount <= 2) continue;
            int indexCandidate = 0;
            while (rawDependencies.indexOf(" and ", indexCandidate + 5) < i && rawDependencies.indexOf(" and ", indexCandidate + 5) > 0) {
                indexCandidate = rawDependencies.indexOf(" and ", indexCandidate + 5);
            }
            int startIndex = indexCandidate;
            indexCandidate = 0;
            while (rawDependencies.indexOf(" or ", indexCandidate + 4) < i && rawDependencies.indexOf(" or ", indexCandidate + 4) > 0) {
                indexCandidate = rawDependencies.indexOf(" or ", indexCandidate + 4);
            }
            startIndex = Math.max(indexCandidate, startIndex);
            indexCandidate = rawDependencies.indexOf(" and ", i);
            int endIndex = rawDependencies.indexOf(" or ", i);
            if (indexCandidate < 0 && endIndex < 0) {
                endIndex = rawDependencies.length();
            }
            if (indexCandidate >= 0 && indexCandidate < endIndex || endIndex < 0) {
                endIndex = indexCandidate;
            }
            if (endIndex < 0 || endIndex >= rawDependencies.length() - 5) {
                endIndex = rawDependencies.length() - 5;
            }
            if (!this.jobsMessages.containsKey(jobname)) {
                this.jobsMessages.put(jobname, new ArrayList());
            }
            Reporter.addMessage(this.jobsMessages.get(jobname), (String)"WRN4012", (String)jobname, (String[])new String[]{jobname, rawDependencies, "..." + rawDependencies.substring(startIndex, endIndex + 4) + "..."});
            break;
        }
    }

    private void cleanDummyDeps(String jobName) {
        if (!this.inconds.containsKey(jobName)) {
            return;
        }
        for (int i = 0; i < this.inconds.get(jobName).size(); ++i) {
            Properties currCond = this.inconds.get(jobName).get(i);
            if (!currCond.containsKey(DUMMY_CONDITION_NAME) || !currCond.containsKey("OP")) continue;
            if (currCond.getProperty("OP").equals("(")) {
                this.removeMatchingParentheses(jobName, i, "(");
                continue;
            }
            this.removeMatchingParentheses(jobName, i, ")");
        }
        List<Properties> conditionsWithoutDummy = AutosysDefs.removeDummyConditions((Collection<Properties>)this.inconds.get(jobName));
        this.inconds.put(jobName, conditionsWithoutDummy);
    }

    private AttrHolderList removeStandaloneJobsFromTopLevelEntities() {
        AttrHolderList standaloneJobs = new AttrHolderList();
        Iterator iterator = this.getTopLevelEntities().iterator();
        while (iterator.hasNext()) {
            IAttrHolder entity = (IAttrHolder)iterator.next();
            if (!this.isStandaloneJob(entity)) continue;
            iterator.remove();
            standaloneJobs.add((Object)entity);
        }
        return standaloneJobs;
    }

    private void removeMatchingParentheses(String jobName, int locationOfDummyDependency, String parenthesesType) {
        int parenthesesCount = 0;
        for (int j = locationOfDummyDependency; j < this.inconds.get(jobName).size(); ++j) {
            Properties condition = this.inconds.get(jobName).get(j);
            if (condition.containsKey("OP")) {
                parenthesesCount = condition.get("OP").equals(parenthesesType) ? ++parenthesesCount : --parenthesesCount;
            }
            if (parenthesesCount != 0) continue;
            condition.remove("OP");
            break;
        }
    }

    private void handleBoxSuccessFail(AutosysHandleCondtions handleCondtions, IAttrHolder child, String boxSuccessFail) {
        String rawDependencies = child.getAttr(boxSuccessFail);
        if (rawDependencies != null && !"NULL".equals(rawDependencies)) {
            rawDependencies = this.normalizeOrAnd(rawDependencies);
            String assistingJobName = AutosysBoxSuccessFailureAssistingJobsBuilder.getAssistingJobName(child.getAttr("insert_job"), boxSuccessFail);
            this.handleEntitiyConditions(handleCondtions, "(and|AND|OR|or|&&|&|\\|)", rawDependencies, assistingJobName);
            this.cleanDummyDeps(assistingJobName);
        }
    }

    private void addDummyDep(Dependency dep) {
        if (dep.getOutJob() == null || dep.getOutJob().isEmpty()) {
            return;
        }
        Properties dummyCond = AutosysDefs.createDummyCondition();
        if (dep.getParen() != null) {
            dummyCond.setProperty("OP", dep.getParen());
        }
        List jobInConditions = this.inconds.computeIfAbsent(dep.getInJob(), k -> new ArrayList());
        jobInConditions.add(dummyCond);
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return this.controlRes.get(job.getOriginalJobName());
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return this.inconds.get(job.getOriginalJobName());
    }

    public List<Properties> getJobInconds(String jobName) {
        return this.inconds.get(jobName);
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return this.onStatements.get(job.getOriginalJobName());
    }

    public List<Properties> getJobOnstmts(SchedEntity job, boolean create) {
        List<Properties> toRet = this.onStatements.get(job.getOriginalJobName());
        if (toRet == null && create) {
            toRet = new ArrayList<Properties>();
            this.onStatements.put(job.getOriginalJobName(), toRet);
        }
        return toRet;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return this.outconds.computeIfAbsent(job.getOriginalJobName(), k -> new ArrayList());
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public List<String> getJobMessages(String jobname) {
        return this.jobsMessages.getOrDefault(jobname, Collections.emptyList());
    }

    public Map<String, String> getJobVariables(String jobName) {
        return this.jobVariables.getOrDefault(jobName, Collections.emptyMap());
    }

    public static String getAutosysJobType(IAttrHolder attr) {
        String type = attr.getAttr("job_type");
        return AutosysDefs.getPrefixType(type);
    }

    public static String getPrefixType(String type) {
        if (type == null || type.isEmpty()) {
            return "NULL";
        }
        return switch (type.toLowerCase()) {
            case "ftp", "scp", "sapjc", "sap", "sapbwpc", "dbproc", "sql", "omtf", "i5", "zos", "http" -> type.toLowerCase();
            default -> type.substring(0, 1).toLowerCase();
        };
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return AutosysDefs.getAutosysJobType(entAttr).equals("b");
    }

    public List<Map<String, String>> getJobActions(String jobId) {
        return this.jobActions.getOrDefault(jobId, Collections.emptyList());
    }

    public void addGeneralMessage(String msgId) {
        this.addGeneralMessage(msgId, Collections.emptyList());
    }

    public void addGeneralMessage(String msgId, List<String> arguments) {
        Reporter.addMessage(this.messages, (String)msgId, (String)"General", (String[])arguments.toArray(new String[0]));
    }

    public ArrayList<String> getGeneralMessages() {
        if (this.calGeneralMessages.isEmpty()) {
            for (String extCalName : this.getExtendedCalendarConvertor().getAllConvertedCalendars()) {
                Map<String, String[]> calMessages = this.getExtendedCalendarConvertor().getMessages(extCalName);
                if (calMessages == null) continue;
                for (Map.Entry<String, String[]> msgId : calMessages.entrySet()) {
                    Reporter.addMessage(this.calGeneralMessages, (String)msgId.getKey(), (String)("## Extended Calendar Conversion (" + extCalName + ")"), (String[])msgId.getValue());
                }
            }
            this.calGeneralMessages.forEach(msg -> {
                if (!this.messages.contains(msg)) {
                    this.messages.add((String)msg);
                }
            });
        }
        return this.messages;
    }

    public RulesDataSet getRules() {
        return this.rules;
    }

    public ExtendedCalendarConvertor getExtendedCalendarConvertor() {
        return this.extendedCalendarConvertor;
    }
}

