/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.autosys;

import com.bmc.ctmconvert.autosys.TimezoneConvert;
import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class AutoSysDefData {
    InputStream dataInputStream = null;
    TimezoneConvert timeZoneConvert = null;
    OutputStream filterCsv;
    InputStream calendarsInputStream = null;
    InputStream globalVariablesInputStream;

    public AutoSysDefData(Path dataPath) {
        Path filteredCsvPath = dataPath.resolve("filteredCsv.csv");
        this.initialization(dataPath, filteredCsvPath);
    }

    private void initialization(Path dataPath, Path filteredCsvPath) {
        try {
            Path jilpath = dataPath.resolve("jil.csv");
            Path timeZonepath = dataPath.resolve("AutosysTz.TZO");
            this.dataInputStream = Files.newInputStream(jilpath, new OpenOption[0]);
            this.timeZoneConvert = new TimezoneConvert(timeZonepath.toString());
            Files.deleteIfExists(filteredCsvPath);
            Files.createFile(filteredCsvPath, new FileAttribute[0]);
            this.filterCsv = Files.newOutputStream(filteredCsvPath, new OpenOption[0]);
            this.calendarsInputStream = this.readFileIfExists(dataPath, "AutosysCalendars.CAL");
            this.globalVariablesInputStream = this.readFileIfExists(dataPath, "GlobalVariables.txt");
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new RuntimeException(e);
        }
    }

    private InputStream readFileIfExists(Path dataPath, String filename) throws IOException {
        if (Files.exists(dataPath.resolve(filename), new LinkOption[0])) {
            Path calendarPath = dataPath.resolve(filename);
            return Files.newInputStream(calendarPath, new OpenOption[0]);
        }
        return null;
    }

    public InputStream getDataInputStream() {
        return this.dataInputStream;
    }

    public TimezoneConvert getTimeZoneConvert() {
        return this.timeZoneConvert;
    }

    public OutputStream getFilterCsv() {
        return this.filterCsv;
    }

    public InputStream getCalendarsFile() {
        return this.calendarsInputStream;
    }

    public InputStream getGlobalVariablesStream() {
        return this.globalVariablesInputStream;
    }
}

