/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.autosys.AutoSysDefData;
import com.bmc.ctmconvert.autosys.AutosysDefs;
import com.bmc.ctmconvert.autosys.CliImporterAutosys;
import com.bmc.ctmconvert.autosys.DataImportAutosys;
import com.bmc.ctmconvert.autosys.ExtendedCalendarConvertor;
import com.bmc.ctmconvert.autosys.SourceDataPanel;
import com.bmc.ctmconvert.autosys.TimezoneConvert;
import com.bmc.ctmconvert.autosys.calendar.ExtendedCalendarHandler;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AppData
implements VendorData {
    public String getName() {
        return "CA_AUTOSYS";
    }

    public String getDisplayName() {
        return "Broadcom AutoSys\u00ae Workload Automation";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public DataImportVendor getDataImport() {
        return new DataImportAutosys();
    }

    public BasePanel getAssessmentReport(String path) {
        return new SourceDataPanel(path + "jil.csv", Globs.ASSESSMENT_REPORT_DESCRIPTION_XML);
    }

    public CliImporter getCLIImporter() {
        return new CliImporterAutosys();
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) {
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        Path datasourcePath = Paths.get(Params.instance().getDatasourcePath(), new String[0]);
        AutoSysDefData autoSysDefData = new AutoSysDefData(datasourcePath);
        TimezoneConvert timeZoneConvert = autoSysDefData.getTimeZoneConvert();
        InputStream dataInputStream = autoSysDefData.getDataInputStream();
        InputStream calendarsInputStream = autoSysDefData.getCalendarsFile();
        OutputStream outputStreamCsvFile = autoSysDefData.getFilterCsv();
        InputStream globalVariablesInputStream = autoSysDefData.getGlobalVariablesStream();
        return new AutosysDefs(rules, timeZoneConvert, dataInputStream, outputStreamCsvFile, calendarsInputStream, globalVariablesInputStream, this.createExtendedCalendarsConvertor());
    }

    private ExtendedCalendarConvertor createExtendedCalendarsConvertor() {
        return new ExtendedCalendarHandler(AppData.getExtendedCalendarsFileContent());
    }

    private static String getExtendedCalendarsFileContent() {
        String result = "";
        Path extendedCalendarsPath = Paths.get(Params.instance().getDatasourcePath() + "ExtendedCalendars.CAL", new String[0]);
        try {
            if (Files.isRegularFile(extendedCalendarsPath, new LinkOption[0])) {
                result = Files.readString(extendedCalendarsPath);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return result;
    }

    public InputStream getRulesResourceFile() {
        return AppData.class.getResourceAsStream("/rules.xml");
    }

    public boolean isZOS() {
        return false;
    }
}

