/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.xmlJobs;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.common.xml.predicates.ComparablePredicate;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.xmlJobs.XmlElementHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.w3c.dom.Element;

public class UC4XmlReader {
    private final List<XmlElementHandler> handlers = new ArrayList<XmlElementHandler>();
    private final Predicate<String> tagPredicate;

    public UC4XmlReader(Predicate<String> tagPredicate) {
        this.tagPredicate = tagPredicate;
    }

    public UC4XmlReader(UC4Globals.UC4_TYPES type, XmlElementHandler handler) {
        this.tagPredicate = tag -> tag.startsWith(type.getTagName() + "_");
        this.handlers.add(handler);
    }

    public UC4XmlReader(Predicate<String> tagPredicate, XmlElementHandler handler) {
        this.tagPredicate = tagPredicate;
        this.handlers.add(handler);
    }

    public void read(InputStream in) {
        XmlElement newXml = XmlLoader.from((InputStream)in);
        List filteredXml = newXml.filterAndReturnXmlElement(new ComparablePredicate(){

            public boolean testImpl(Element subjectElement) {
                String tag = subjectElement.getTagName();
                return UC4XmlReader.this.tagPredicate.test(tag);
            }
        });
        for (XmlElement jobsElement : filteredXml) {
            for (XmlElementHandler xmlElementHandler : this.handlers) {
                xmlElementHandler.handleElement(jobsElement);
            }
        }
    }

    public void addHandler(XmlElementHandler handler) {
        this.handlers.add(handler);
    }
}

