/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.IUC4Job;
import com.bmc.ctmconvert.uc4.scripts.ActionHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class VariableXmlHandler
implements ActionHandler {
    private String xmlWithVariable;

    public VariableXmlHandler(String xmlWithVariable) {
        this.xmlWithVariable = xmlWithVariable;
    }

    @Override
    public void convert(IUC4Job uc4Job, String script) {
        try {
            XmlElement variableXmlElement = VariableXmlHandler.generateDocumentFromXmlString("<body>" + this.xmlWithVariable + "</body>");
            boolean variableProcessed = false;
            for (XmlElement varElement : variableXmlElement.getAllDecnedElementByName("VARIABLE")) {
                Map varAttributesMap = varElement.getAttributes();
                String variableName = (String)varAttributesMap.get("NAME");
                String variableValue = (String)varAttributesMap.get("VALUE");
                uc4Job.addVariable(variableName, variableValue);
                variableProcessed = true;
            }
            if (!variableProcessed) {
                throw new varXmlException();
            }
        }
        catch (varXmlException | IOException | ParserConfigurationException | SAXException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            uc4Job.addMessage("WRN8054", uc4Job.getOriginalJobName(), uc4Job.generateUniqueID(), this.xmlWithVariable, "UC4_scripts_conversion_to_ctm.xlsx");
        }
    }

    private static XmlElement generateDocumentFromXmlString(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        byte[] xmlStringBytes = xmlString.getBytes();
        Document doc = documentBuilder.parse(new ByteArrayInputStream(xmlStringBytes));
        Element element = doc.getDocumentElement();
        XmlElement result = new XmlElement(element);
        return result;
    }

    private class varXmlException
    extends RuntimeException {
        private static final long serialVersionUID = -7997928388149735385L;

        varXmlException() {
            super("Content of the supplied XML is not a valid Control-M On Do XML");
        }
    }
}

