/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.common.streamutils.InputStreamGetter;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.scripts.ActionValueRecordToScriptMapper;
import com.bmc.ctmconvert.uc4.scripts.IScriptRecord;
import com.bmc.ctmconvert.uc4.scripts.MainScriptsMapCreator;
import com.bmc.ctmconvert.uc4.scripts.PatternToscriptMapper;
import com.bmc.ctmconvert.uc4.scripts.ScriptEntry;
import com.bmc.ctmconvert.uc4.scripts.ScriptExcelReader;
import com.bmc.ctmconvert.uc4.scripts.ScriptRecordCollector;
import com.bmc.ctmconvert.utils.Counter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;

public class Uc4ScriptsMapCreator {
    private LinkedHashMap<ScriptEntry, Counter> postScriptEntryMap;
    private LinkedHashMap<ScriptEntry, Counter> preScriptEntryMap;
    private HashMap<String, List<ScriptDetails>> scriptsEntryMap;
    private final Path scriptsExcelPath;
    private final InputStreamGetter inputStreamGetter;

    public Uc4ScriptsMapCreator(Path scriptsExcelPath, InputStreamGetter inputStreamGetter) {
        this.scriptsExcelPath = scriptsExcelPath;
        this.inputStreamGetter = inputStreamGetter;
        this.postScriptEntryMap = new LinkedHashMap();
        this.preScriptEntryMap = new LinkedHashMap();
        this.scriptsEntryMap = new HashMap();
    }

    public void fillPrePostMapsbyReadingExcelFile() throws IOException {
        ScriptRecordCollector collector = new ScriptRecordCollector(new ActionValueRecordToScriptMapper());
        new ScriptExcelReader(collector, this.inputStreamGetter.getInputStream(this.scriptsExcelPath)).parseSheet("UC4 scripts conversion");
        this.postScriptEntryMap = new LinkedHashMap();
        collector.forEachRecored(record -> this.postScriptEntryMap.computeIfAbsent(new ScriptEntry(record.getScript(), record.getOsType(), record.getJobType()), k -> new Counter(record.getNumberofOccurences())), t -> t.getType() == UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_POST);
        this.preScriptEntryMap = new LinkedHashMap();
        collector.forEachRecored(record -> this.preScriptEntryMap.computeIfAbsent(new ScriptEntry(record.getScript(), record.getOsType(), record.getJobType()), k -> new Counter(record.getNumberofOccurences())), t -> t.getType() == UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE);
    }

    public List<IScriptRecord> fillScriptsMapByReadingExcelFile() throws IOException {
        PatternToscriptMapper scriptMapper = new PatternToscriptMapper();
        ScriptRecordCollector collector = new ScriptRecordCollector(scriptMapper);
        ScriptExcelReader scriptExcelReader = new ScriptExcelReader(collector, this.inputStreamGetter.getInputStream(this.scriptsExcelPath));
        scriptExcelReader.parseSheet("UC4_scripts_analysis");
        MainScriptsMapCreator scriptsMapCreator = new MainScriptsMapCreator();
        Predicate<IScriptRecord> filter = record -> true;
        collector.forEachRecored(scriptsMapCreator, filter);
        this.scriptsEntryMap = scriptsMapCreator.getScriptsEntryMap();
        return collector.getRecords();
    }

    public LinkedHashMap<ScriptEntry, Counter> getPostScriptEntryMap() {
        return this.postScriptEntryMap;
    }

    public LinkedHashMap<ScriptEntry, Counter> getPreScriptEntryMap() {
        return this.preScriptEntryMap;
    }

    public HashMap<String, List<ScriptDetails>> getScriptsEntryMap() {
        return this.scriptsEntryMap;
    }
}

