/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.uc4.CommandPredicate;
import com.bmc.ctmconvert.uc4.IUC4Job;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4ScriptingAnalysis;
import com.bmc.ctmconvert.uc4.predicate.TaskTypeGetter;
import com.bmc.ctmconvert.uc4.scripts.IScriptHandler;
import com.bmc.ctmconvert.uc4.scripts.ScriptContainsUc4LanguageKeyword;
import org.apache.commons.lang3.StringUtils;

public class UC4ScriptsHandler {
    private final IUC4Job uc4Job;
    private final UC4Object uc4Obj;
    private static final String[] emptyScriptArray = new String[]{"!"};
    private static final String POWER_SHELL_PREFIX = "#!powershell.exe  -File\n";
    private static final String POWER_SHELL = "#!powershell.exe";

    public UC4ScriptsHandler(IUC4Job uc4Job) {
        this.uc4Job = uc4Job;
        this.uc4Obj = uc4Job.getObj();
    }

    public void convertUc4Scripts() {
        if (!this.uc4Job.type().equals((Object)SchedEntity.TYPE.JOB) || new CommandPredicate().test(this.uc4Obj)) {
            return;
        }
        boolean isSqlJob = UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_SQL.toString().equalsIgnoreCase(this.uc4Obj.getFullType());
        String preScript = this.uc4Obj.getAttribute("PSCRI");
        String mscri = isSqlJob ? "" : this.uc4Obj.getAttribute("MSCRI");
        String postScript = this.uc4Obj.getAttribute("OSCRI");
        String typeOfScript = this.getTypeofScript(preScript, mscri, postScript);
        if (this.uc4Job.getPreScriptHandler().hasHandler(this.uc4Job, preScript)) {
            preScript = "";
        }
        if (this.uc4Job.getPostScriptHandler().hasHandler(this.uc4Job, postScript)) {
            postScript = "";
        }
        if (!(preScript.isEmpty() && mscri.isEmpty() && postScript.isEmpty())) {
            boolean isContainsUc4KeyWord;
            this.uc4Job.addAttribute("MEMNAME", this.addSuffix(this.uc4Job.getAttr("MEMNAME"), TaskTypeGetter.getMemNameSuffix(this.uc4Job)));
            this.uc4Job.getEmbeddedScript().clear();
            String instreamJcl = "";
            boolean allScriptsConverted = true;
            String type = this.uc4Obj.getFullType();
            if (!preScript.isEmpty() && (isContainsUc4KeyWord = this.checkIfScriptContainsUc4LanguageKeyword(preScript))) {
                if (!type.equals(UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_MVS.toString())) {
                    this.uc4Job.addMessage("WRN8050", this.uc4Job.generateUniqueID(), this.uc4Job.getOriginalJobName(), this.uc4Job.getJobName(), "Pre Process");
                }
                allScriptsConverted = false;
            }
            if (!mscri.isEmpty()) {
                mscri = this.addPowerShellPrefix(UC4ScriptsHandler.replaceUC4Comments(mscri, this.uc4Job), this.uc4Job);
                String convertedScripViaAI = this.uc4Job.getConvertedScripFromAnalysisSheet();
                if (convertedScripViaAI != null && !convertedScripViaAI.isEmpty()) {
                    mscri = convertedScripViaAI;
                    this.uc4Job.addMessage("WRN8071", this.uc4Job.getJobName());
                } else if (this.checkIfScriptContainsUc4LanguageKeyword(mscri)) {
                    if (UC4ScriptsHandler.isNotMVSTypeJob(type)) {
                        this.uc4Job.addMessage("WRN8051", this.uc4Job.generateUniqueID(), this.uc4Job.getOriginalJobName(), this.uc4Job.getJobName(), "Process");
                    }
                    allScriptsConverted = false;
                }
                this.uc4Job.getEmbeddedScript().addToScript(mscri);
            }
            if (!postScript.isEmpty() && (isContainsUc4KeyWord = this.checkIfScriptContainsUc4LanguageKeyword(postScript))) {
                this.uc4Job.addMessage("WRN8052", this.uc4Job.generateUniqueID(), this.uc4Job.getOriginalJobName(), this.uc4Job.getJobName(), "Post Process");
            }
            UC4ScriptingAnalysis uc4ScriptingAnalysis = UC4ScriptingAnalysis.instance();
            if (allScriptsConverted) {
                boolean msciExitCommand = this.isScriptContainsExitCommand(mscri);
                boolean psciExitCommand = this.isScriptContainsExitCommand(preScript);
                uc4ScriptingAnalysis.addToContent(new String[]{this.uc4Job.getJobName(), this.uc4Job.getOriginalJobName(), this.uc4Obj.getFullType(), typeOfScript, instreamJcl, "YES"});
                if (!mscri.isEmpty() && psciExitCommand || !postScript.isEmpty() && (psciExitCommand || msciExitCommand)) {
                    String generateUniqueID = this.uc4Job.generateUniqueID();
                    String jobName = this.uc4Job.getJobName();
                    this.uc4Job.addMessage("WRN8026", generateUniqueID, jobName);
                }
            } else {
                uc4ScriptingAnalysis.addToContent(new String[]{this.uc4Job.getJobName(), this.uc4Job.getOriginalJobName(), this.uc4Obj.getFullType(), typeOfScript, instreamJcl, "NO"});
                if (this.checkIfCmJob() && typeOfScript.equals("MSCRI-")) {
                    ConversionLogger.getLogger().info("CAN BE IGNORED:  Job: " + this.uc4Job.getOriginalJobName() + " Job Type: " + this.uc4Obj.getFullType() + " Ignore message for script: " + typeOfScript + " was not converted.");
                }
            }
        }
    }

    private static boolean isNotMVSTypeJob(String type) {
        return !type.equals(UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_MVS.toString());
    }

    private String getTypeofScript(String preScript, String mscri, String postScript) {
        IScriptHandler postScriptHandler = this.uc4Job.getPostScriptHandler();
        boolean postScriptConverted = postScriptHandler.hasHandler(this.uc4Job, postScript);
        if (postScriptConverted) {
            postScript = "";
        }
        Object typeOfScript = "";
        if (!(preScript.isEmpty() && mscri.isEmpty() && postScript.isEmpty())) {
            if (!preScript.isEmpty()) {
                typeOfScript = (String)typeOfScript + "PSCRI-";
            }
            if (!mscri.isEmpty()) {
                typeOfScript = (String)typeOfScript + "MSCRI-";
            }
            if (!postScript.isEmpty()) {
                typeOfScript = (String)typeOfScript + "OSCRI-";
            }
        }
        return typeOfScript;
    }

    private boolean checkIfCmJob() {
        return this.uc4Obj.getFullType().equalsIgnoreCase(UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_PS.toString()) || this.uc4Obj.getFullType().equalsIgnoreCase(UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_R3.toString());
    }

    static String replaceUC4Comments(String script, IUC4Job uc4Job) {
        if (script == null) {
            return "";
        }
        boolean isOs400 = uc4Job.getObj().getFullType().equals(UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_OS400.toString());
        String comment = "\n" + (uc4Job.isUnixJob() ? "# " : "rem ");
        String[] stringArr = UC4ScriptsHandler.trimToEmptyIfCommentsOnly(script.split("\n"));
        StringBuilder sb = new StringBuilder();
        for (String line : stringArr) {
            if (line.trim().startsWith("!")) {
                sb.append(comment);
            } else {
                if (line.trim().startsWith(":JCL_CONCAT_CHAR")) continue;
                if (isOs400) {
                    line = line.replaceAll("^:([pP]) ", "");
                }
            }
            sb.append(line).append("\n");
        }
        String sbResult = sb.toString();
        if (sbResult.equals("\n")) {
            return "";
        }
        return sbResult;
    }

    private static String[] trimToEmptyIfCommentsOnly(String[] script) {
        for (String line : script) {
            if (line.trim().startsWith("!")) continue;
            return script;
        }
        return emptyScriptArray;
    }

    private String addPowerShellPrefix(String script, IUC4Job uc4Job) {
        if (TaskTypeGetter.isWindowsPowerShell(uc4Job) && !script.startsWith(POWER_SHELL)) {
            return POWER_SHELL_PREFIX + script;
        }
        return script;
    }

    private boolean checkIfScriptContainsUc4LanguageKeyword(String script) {
        return new ScriptContainsUc4LanguageKeyword().test(script);
    }

    private boolean isScriptContainsExitCommand(String script) {
        return script.toLowerCase().contains("exit ");
    }

    private String addSuffix(String jobFileName, String fileNameSuffix) {
        return StringUtils.left((String)jobFileName, (int)(64 - fileNameSuffix.length())) + fileNameSuffix;
    }
}

