/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.scripts.IRecord;
import com.bmc.ctmconvert.uc4.scripts.IScriptRecord;

public class ScriptsPatternsRecord
implements IRecord,
IScriptRecord {
    static final int SCRIPT_PATTERN_INDEX = 0;
    static final int SCRIPT_INDEX = 1;
    static final int NUMBER_OF_OCCURENCES_INDEX = 2;
    static final int JOB_NAME_INDEX = 3;
    static final int JOB_TYPE_INDEX = 4;
    static final int CONVERTED_SCRIPT_INDEX = 5;
    private static final int RECORD_SIZE = 6;
    private final String pattern;
    private final int numberofOccurences;
    private final String script;
    private final String convertedScript;
    private final String jobName;
    private final String jobType;

    public ScriptsPatternsRecord(String pattern, String script, int occurrences, String jobName, String jobType, String convertedScript) {
        this.pattern = pattern;
        this.script = script;
        this.numberofOccurences = occurrences;
        this.jobName = jobName;
        this.jobType = jobType;
        this.convertedScript = convertedScript;
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public UC4Globals.OS_TYPE getOsType() {
        return null;
    }

    public String getConvertedScript() {
        return this.convertedScript;
    }

    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public UC4Globals.SCRIPT_TYPE getType() {
        return null;
    }

    @Override
    public int getNumberofOccurences() {
        return this.numberofOccurences;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public static ScriptsPatternsRecord fromStringArray(String[] paramters) {
        String script = ScriptsPatternsRecord.getValueOfExistsOrElse(paramters, 1, "");
        String numberOfOccurences = ScriptsPatternsRecord.getValueOfExistsOrElse(paramters, 2, "");
        String pattern = ScriptsPatternsRecord.getValueOfExistsOrElse(paramters, 0, "");
        String jobName = ScriptsPatternsRecord.getValueOfExistsOrElse(paramters, 3, "");
        String jobType = ScriptsPatternsRecord.getValueOfExistsOrElse(paramters, 4, "");
        String convertedScript = ScriptsPatternsRecord.getValueOfExistsOrElse(paramters, 5, "");
        int occurences = 0;
        if (GlobalFunctions.isNumber((String)numberOfOccurences)) {
            occurences = Integer.parseInt(numberOfOccurences);
        }
        return new ScriptsPatternsRecord(pattern, script, occurences, jobName, jobType, convertedScript);
    }

    private static String getValueOfExistsOrElse(String[] paramters, int index, String elseValue) {
        if (paramters.length > index) {
            return paramters[index];
        }
        return elseValue;
    }

    @Override
    public String[] getRecord() {
        String[] record = new String[6];
        record[1] = this.getScript();
        record[2] = this.getNumberofOccurences() != 0 ? Integer.toString(this.getNumberofOccurences()) : "";
        record[0] = this.getPattern();
        return record;
    }
}

