/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.scripts.ActionHandler;
import com.bmc.ctmconvert.uc4.scripts.ActionValueRecord;
import com.bmc.ctmconvert.uc4.scripts.IScriptHandlerFactory;
import com.bmc.ctmconvert.uc4.scripts.IScriptRecord;
import com.bmc.ctmconvert.uc4.scripts.IgnoreHandler;
import com.bmc.ctmconvert.uc4.scripts.MultiActionsHandler;
import com.bmc.ctmconvert.uc4.scripts.OnDoXmlHandler;
import com.bmc.ctmconvert.uc4.scripts.PreScriptReplaceHandler;
import com.bmc.ctmconvert.uc4.scripts.VariableXmlHandler;

public class ScriptHandlerFactory
implements IScriptHandlerFactory {
    private final ActionHandler defaultActionHandler;

    public ScriptHandlerFactory(ActionHandler defaultActionHandler) {
        this.defaultActionHandler = defaultActionHandler;
    }

    @Override
    public ActionHandler getHandler(IScriptRecord iScriptRecord) {
        ActionValueRecord actionValueRecord = (ActionValueRecord)iScriptRecord;
        UC4Globals.SCRIPT_ACTION action1 = UC4Globals.SCRIPT_ACTION.fromString(actionValueRecord.getAction1());
        String value1 = actionValueRecord.getValue1();
        if (action1.getValue().equalsIgnoreCase(UC4Globals.SCRIPT_ACTION.SCRIPT_ACTION_IGNORE.getValue())) {
            return new IgnoreHandler();
        }
        MultiActionsHandler multiActionsHandler = new MultiActionsHandler();
        ActionHandler action1Handler = this.getHandlerFromAction(action1, value1);
        multiActionsHandler.addAction(action1Handler);
        UC4Globals.SCRIPT_ACTION action2 = UC4Globals.SCRIPT_ACTION.fromString(actionValueRecord.getAction2());
        String value2 = actionValueRecord.getValue2();
        if (action2.getValue().equalsIgnoreCase(UC4Globals.SCRIPT_ACTION.SCRIPT_ACTION_IGNORE.getValue())) {
            return new IgnoreHandler();
        }
        ActionHandler action2Handler = this.getHandlerFromAction(action2, value2);
        multiActionsHandler.addAction(action2Handler);
        return multiActionsHandler;
    }

    private ActionHandler getHandlerFromAction(UC4Globals.SCRIPT_ACTION action, String value) {
        switch (action) {
            case SCRIPT_ACTION_ADD_VARIABLE: {
                return new VariableXmlHandler(value);
            }
            case SCRIPT_ACTION_REPLACE_SCRIPT: {
                return new PreScriptReplaceHandler(value);
            }
            case SCRIPT_ACTION_ADD_ONDO: {
                return new OnDoXmlHandler(value);
            }
            case SCRIPT_KEEP_ORIGINAL: {
                return this.defaultActionHandler;
            }
        }
        return new IgnoreHandler();
    }
}

