/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.Uc4ScriptFilesCreationHandler;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.scripts.ActionValueRecord;
import com.bmc.ctmconvert.uc4.scripts.CellCreator;
import com.bmc.ctmconvert.uc4.scripts.ExcelDropDown;
import com.bmc.ctmconvert.uc4.scripts.IRecord;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.stream.IntStream;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ScriptExcelWriter
implements Consumer<IRecord> {
    private static final String CLICK_TO_VIEW = "\n(Click '+' to view)";
    private final XSSFWorkbook excelWorkBook = new XSSFWorkbook();
    private final XSSFSheet pre_post_sheet = this.excelWorkBook.createSheet("UC4 scripts conversion");
    private final Sheet scripts_m_sheet = this.excelWorkBook.createSheet("UC4_scripts_analysis");
    private final Sheet includeContentSheet = this.excelWorkBook.createSheet("INCLUDE content");
    private int rowNumberForPrePost = 1;
    private final CellStyle style;
    private int rowNumberForScriptM;
    private final XSSFFont blueFont = this.excelWorkBook.createFont();

    public ScriptExcelWriter(String[] header) {
        this.blueFont.setColor(IndexedColors.BLUE.getIndex());
        this.setColumnWidthForPrePostSheet();
        this.setColumnWidthForUc4ScriptAnalysis();
        this.style = this.excelWorkBook.createCellStyle();
        XSSFFont font = this.excelWorkBook.createFont();
        font.setBold(true);
        this.style.setFont((Font)font);
        this.style.setWrapText(true);
        HorizontalAlignment align = HorizontalAlignment.CENTER;
        this.style.setAlignment(align);
        String[] scriptHeader = new String[]{"UC4 Script Pattern", "UC4 Script Content \n(Click '+' to view)", "Number of UC4 Jobs use the Script Pattern", "Job Name \n(Click '+' to view)", "Job Type \n(Click '+' to view)", "Converted Script"};
        this.createRow(header, this.style, (Sheet)this.pre_post_sheet);
        this.createRow(scriptHeader, this.style, this.scripts_m_sheet);
        this.createRow(new String[]{"Name", "Usages", "Content"}, this.style, this.includeContentSheet);
        this.includeContentSheet.setColumnWidth(0, 10000);
    }

    @Override
    public void accept(IRecord preRecord) {
        this.handleStatistic(preRecord);
    }

    private void createRow(String[] header, CellStyle style, Sheet sheet) {
        Row row = sheet.createRow(0);
        sheet.createFreezePane(0, 1);
        for (int i = 0; i < header.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(header[i]);
            cell.setCellStyle(style);
        }
    }

    private void setColumnWidthForPrePostSheet() {
        this.pre_post_sheet.setColumnWidth(0, 5000);
        this.pre_post_sheet.setColumnWidth(1, 17000);
        this.pre_post_sheet.setColumnWidth(2, 5500);
        this.pre_post_sheet.setColumnWidth(3, 5000);
        this.pre_post_sheet.setColumnWidth(4, 4000);
        this.pre_post_sheet.setColumnWidth(5, 8000);
        this.pre_post_sheet.setColumnWidth(6, 6500);
        this.pre_post_sheet.setColumnWidth(7, 8000);
        this.pre_post_sheet.setColumnWidth(8, 6500);
    }

    private void setColumnWidthForUc4ScriptAnalysis() {
        this.scripts_m_sheet.setColumnWidth(0, 17000);
        this.scripts_m_sheet.setColumnWidth(1, 17000);
        this.scripts_m_sheet.setColumnWidth(2, 5500);
        this.scripts_m_sheet.setColumnWidth(3, 8000);
        this.scripts_m_sheet.setColumnWidth(4, 8000);
    }

    public void writePrePostScriptSheet(List<ActionValueRecord> records) {
        records.forEach(this::handleStatistic);
    }

    public void handleStatistic(IRecord staticRecord) {
        String[] newRecord = staticRecord.getRecord();
        XSSFRow row = this.pre_post_sheet.createRow(this.rowNumberForPrePost);
        for (int columnIndex = 0; columnIndex < newRecord.length; ++columnIndex) {
            Cell cell = row.createCell(columnIndex);
            String value = newRecord[columnIndex];
            if (columnIndex == 2) {
                this.handleNumericColumn(value, cell);
                continue;
            }
            this.handleStringColumn(value, cell);
        }
        String scriptType = newRecord[0];
        if (scriptType.equals(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_POST.getValue()) | scriptType.equals(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE.getValue())) {
            ExcelDropDown.addActionsDropDowns(this.pre_post_sheet, this.rowNumberForPrePost, scriptType);
        }
        ++this.rowNumberForPrePost;
    }

    private void handleNumericColumn(String value, Cell cell) {
        cell.setCellType(CellType.NUMERIC);
        cell.setCellValue((double)Integer.parseInt(value));
    }

    private void handleStringColumn(String value, Cell cell) {
        cell.setCellValue(value);
        cell.setCellType(CellType.STRING);
    }

    public XSSFWorkbook getExcelWorkBook() {
        return this.excelWorkBook;
    }

    public void write(OutputStream excelFileOutPut) throws IOException {
        this.excelWorkBook.write(excelFileOutPut);
    }

    public void writeScriptsSheet(Map<String, List<ScriptDetails>> scriptsEntryMap) {
        this.rowNumberForScriptM = 1;
        scriptsEntryMap.forEach((pattern, scripts) -> {
            int firstRow = this.rowNumberForScriptM;
            scripts.forEach(script -> this.createRowInScriptExcel((ScriptDetails)script, (String)pattern, scripts.size()));
            this.groupScriptM(firstRow, (String)pattern, scripts.size());
        });
    }

    private void createRowInScriptExcel(ScriptDetails script, String patternName, int countScript) {
        try {
            Row row = this.scripts_m_sheet.createRow(this.rowNumberForScriptM);
            CellCreator cellCreator = new CellCreator(row);
            XSSFCellStyle cellStyle = this.excelWorkBook.createCellStyle();
            HorizontalAlignment align = HorizontalAlignment.CENTER;
            cellStyle.setAlignment(align);
            cellCreator.setPattern(patternName);
            cellCreator.setScript(script.script());
            cellCreator.setJobName(script.jobName());
            cellCreator.setJobType(script.jobType());
            cellCreator.setCount(countScript, (CellStyle)cellStyle);
            ++this.rowNumberForScriptM;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to add script for job " + script.jobName(), ex);
        }
    }

    private void groupScriptM(int firstRow, String pattern, int size) {
        int idy = 0;
        Row row = this.scripts_m_sheet.createRow(this.rowNumberForScriptM);
        Cell cell = row.createCell(idy);
        cell.setCellValue(pattern);
        cell = row.createCell(++idy);
        cell.setCellValue("");
        cell = row.createCell(++idy);
        cell.setCellValue((double)size);
        cell.setCellStyle(this.style);
        this.scripts_m_sheet.groupRow(firstRow, this.rowNumberForScriptM - 1);
        this.scripts_m_sheet.setRowGroupCollapsed(firstRow, true);
        ++this.rowNumberForScriptM;
    }

    public void writeIncludeContentSheet(List<List<String>> rows) {
        HashMap<String, Integer> scriptCellMap = new HashMap<String, Integer>();
        int rowIndex = 1;
        for (List<String> data : rows) {
            Row row = this.includeContentSheet.createRow(rowIndex++);
            IntStream.of(0, 1, 2).forEach(index -> row.createCell(index).setCellValue((String)data.get(index)));
            scriptCellMap.put(data.getFirst(), rowIndex);
        }
        this.createLinksToIncludes(scriptCellMap, (Sheet)this.pre_post_sheet);
        this.createLinksToIncludes(scriptCellMap, this.scripts_m_sheet);
    }

    private void createLinksToIncludes(Map<String, Integer> scriptCellMap, Sheet sheet) {
        for (int rowNum = 0; rowNum < sheet.getLastRowNum(); ++rowNum) {
            Cell scriptCell = sheet.getRow(rowNum).getCell(1);
            Matcher includeMatcher = Uc4ScriptFilesCreationHandler.findIncludeInScript(scriptCell.getStringCellValue());
            if (includeMatcher == null) continue;
            XSSFHyperlink link = new XSSFCreationHelper(this.excelWorkBook).createHyperlink(HyperlinkType.DOCUMENT);
            link.setAddress("'INCLUDE content'!A" + String.valueOf(scriptCellMap.get(includeMatcher.group("scriptName").toUpperCase())));
            scriptCell.setHyperlink((Hyperlink)link);
            scriptCell.getRichStringCellValue().applyFont(includeMatcher.start(), includeMatcher.end(), (Font)this.blueFont);
        }
    }
}

