/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.uc4.scripts.IRecord;
import com.bmc.ctmconvert.uc4.scripts.Record;
import com.bmc.ctmconvert.uc4.scripts.RecordHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ScriptExcelReader {
    private final XSSFWorkbook workbook;
    private final RecordHandler handler;

    public ScriptExcelReader(RecordHandler recordHandler, InputStream inputStream) throws IOException {
        this.handler = recordHandler;
        this.workbook = new XSSFWorkbook(inputStream);
    }

    public void parseSheet(String sheetName) throws IOException {
        XSSFSheet sheet = this.workbook.getSheet(sheetName);
        for (int lineNumber = 1; lineNumber < sheet.getPhysicalNumberOfRows(); ++lineNumber) {
            this.handler.handleRecord(this.getRecord(sheet, lineNumber));
        }
    }

    private IRecord getRecord(XSSFSheet sheet, int lineNumber) {
        XSSFRow row = sheet.getRow(lineNumber);
        ArrayList<String> nextSheetRow = new ArrayList<String>();
        for (Cell cell : row) {
            CellType type = cell.getCellTypeEnum();
            if (type.equals((Object)CellType.STRING)) {
                nextSheetRow.add(cell.getStringCellValue());
            }
            if (!type.equals((Object)CellType.NUMERIC)) continue;
            nextSheetRow.add(String.valueOf((int)cell.getNumericCellValue()));
        }
        String[] line = nextSheetRow.toArray(new String[0]);
        return new Record(line);
    }
}

