/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.scripts.ActionHandler;
import com.bmc.ctmconvert.uc4.scripts.IScriptActionGetter;
import com.bmc.ctmconvert.uc4.scripts.IScriptRecord;
import com.bmc.ctmconvert.uc4.scripts.ScriptEntry;
import java.util.HashMap;
import java.util.Map;

public class ScriptActionGetter
implements IScriptActionGetter {
    private final Map<ScriptEntry, ActionHandler> uc4ScriptMap = new HashMap<ScriptEntry, ActionHandler>();
    private final ActionHandler defaultActionHandler;

    public ScriptActionGetter(ActionHandler defaultActionHandler) {
        this.defaultActionHandler = defaultActionHandler;
    }

    @Override
    public void addAction(IScriptRecord scriptRecord, ActionHandler action) {
        String script = scriptRecord.getScript();
        UC4Globals.OS_TYPE osType = scriptRecord.getOsType();
        ScriptEntry entry = new ScriptEntry(script.toUpperCase(), osType, scriptRecord.getJobType());
        this.uc4ScriptMap.put(entry, action);
    }

    @Override
    public ActionHandler get(String script, UC4Globals.OS_TYPE osType, String jobType) {
        return this.uc4ScriptMap.get(new ScriptEntry(script.toUpperCase(), osType, jobType));
    }

    @Override
    public boolean hasHandler(String script, UC4Globals.OS_TYPE osType, String jobType) {
        return this.uc4ScriptMap.containsKey(new ScriptEntry(script.toUpperCase(), osType, jobType));
    }

    @Override
    public ActionHandler getDefaultAction() {
        return this.defaultActionHandler;
    }
}

