/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.uc4.IUC4Job;
import com.bmc.ctmconvert.uc4.OS400Convertor;
import java.util.Arrays;
import java.util.stream.Collectors;

public class EmbeddedScript {
    private String script;
    private String preScript;
    private String postScript;
    private final IUC4Job uc4Job;
    private String total;

    public EmbeddedScript(IUC4Job uc4Job) {
        this.uc4Job = uc4Job;
        this.script = "";
        this.preScript = "";
        this.postScript = "";
        this.total = "";
    }

    public void set(String script) {
        this.script = script;
        this.addToJob();
    }

    public void setAll(String script) {
        this.script = script;
        this.preScript = "";
        this.postScript = "";
        this.addToJob();
    }

    public String getString() {
        return this.total;
    }

    public void clear() {
        this.script = "";
        this.preScript = "";
        this.postScript = "";
        this.addToJob();
    }

    public void setPreScript(String preScript) {
        this.preScript = preScript;
        this.addToJob();
    }

    public void setPostScript(String postScript) {
        this.postScript = postScript;
        this.addToJob();
    }

    public void addToPreScript(String preScript) {
        this.preScript = this.preScript + preScript;
        this.addToJob();
    }

    public void addToPostScript(String postScript) {
        this.postScript = this.postScript + postScript;
        this.addToJob();
    }

    public void addToScript(String script) {
        this.script = this.script + script;
        this.addToJob();
    }

    private void addToJob() {
        this.total = this.preScript + this.script + this.postScript;
        if (this.embeddedScriptJob()) {
            this.uc4Job.addAttribute("INSTREAM_JCL", this.prefixLineCountToInstreamJCL(this.total));
            this.uc4Job.addAttribute("USE_INSTREAM_JCL", "Y");
        } else if (this.isValid()) {
            String withoutLda = OS400Convertor.removeLDAFromScript(this.total.trim());
            this.uc4Job.addAttribute("DESCRIPTION", withoutLda);
        }
    }

    private boolean embeddedScriptJob() {
        return !(!"Job".equals(this.uc4Job.getAttr("TASKTYPE")) && !this.isARunAsDummyJob() || !"OS".equals(this.uc4Job.getAttr("APPL_TYPE")) && this.uc4Job.getAttr("APPL_TYPE") != null);
    }

    private boolean isARunAsDummyJob() {
        boolean isDummyJob = "Dummy".equals(this.uc4Job.getAttr("TASKTYPE"));
        boolean hasRunAsDummyVariable = "Job".equals(this.uc4Job.getAutoedits().get("%%$BMCWAIORIGTYPE"));
        return isDummyJob && hasRunAsDummyVariable;
    }

    private boolean isValid() {
        return !this.total.isBlank();
    }

    private boolean shouldPrefixCountToInstreamJcl() {
        return this.uc4Job.isMFJob();
    }

    private String prefixLineCountToInstreamJCL(String inStreamJcl) {
        if (this.shouldPrefixCountToInstreamJcl()) {
            return Arrays.stream(inStreamJcl.split("\\r?\\n")).map(String::trim).filter(s -> !s.isBlank()).map(line -> {
                String lineLength = String.format("%04d", line.length());
                return lineLength + line;
            }).collect(Collectors.joining());
        }
        return inStreamJcl.trim();
    }
}

