/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;

public class CellCreator {
    private static final int PATTERN_INDEX = 0;
    private static final int SCRIPT_INDEX = 1;
    private static final int COUNT_INDEX = 2;
    private static final int JOB_NAME_INDEX = 3;
    private static final int JOB_TYPE_INDEX = 4;
    private static final String SCRIPT_TRUNCATED_MSG = "\n!!!! Script was truncated! You should manually review it !!!";
    private static final int MAX_TEXT_LENGTH = 32000 - "\n!!!! Script was truncated! You should manually review it !!!".length();
    private final Row row;

    public CellCreator(Row row) {
        this.row = row;
    }

    public void setScript(String script) {
        Cell cell = this.row.createCell(1);
        if (script.length() > MAX_TEXT_LENGTH) {
            cell.setCellValue(script.substring(0, MAX_TEXT_LENGTH) + SCRIPT_TRUNCATED_MSG);
        } else {
            cell.setCellValue(script);
        }
    }

    public void setPattern(String Keywords) {
        Cell cell = this.row.createCell(0);
        cell.setCellValue(Keywords.substring(1, Keywords.length() - 1));
    }

    public void setCount(int numberOfScript, CellStyle cellStyle) {
        Cell cell = this.row.createCell(2);
        cell.setCellValue((double)numberOfScript);
        cell.setCellStyle(cellStyle);
    }

    public void setJobName(String jobName) {
        Cell cell = this.row.createCell(3);
        cell.setCellValue(jobName);
    }

    public void setJobType(String jobType) {
        Cell cell = this.row.createCell(4);
        cell.setCellValue(jobType);
    }
}

