/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research.handlers;

import com.bmc.ctmconvert.uc4.research.handlers.KeyWordCollector;
import com.bmc.ctmconvert.uc4.research.handlers.KeyWordHandler;
import com.bmc.ctmconvert.uc4.research.handlers.ScriptScanner;
import com.bmc.ctmconvert.uc4.research.handlers.line_predicates.AnyKeyWordPredicate;
import com.bmc.ctmconvert.uc4.research.handlers.line_predicates.PredicatekeyWordMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ScriptParser {
    private String scriptValue;

    public ScriptParser(String scriptValue) {
        this.scriptValue = scriptValue;
    }

    public int getNumberOfScriptKeyWordsLine() {
        int counterJobsWithUc4Cmds = 0;
        String searchFor = ":";
        Scanner scanner = new Scanner(this.scriptValue);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.startsWith(searchFor)) continue;
            ++counterJobsWithUc4Cmds;
        }
        scanner.close();
        return counterJobsWithUc4Cmds;
    }

    public boolean hasKeyWord(String keyWord) {
        PredicatekeyWordMatch matchOne = new PredicatekeyWordMatch(keyWord);
        boolean ret = false;
        Scanner scanner = new Scanner(this.scriptValue);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!matchOne.test(line)) continue;
            ret = true;
            break;
        }
        scanner.close();
        return ret;
    }

    public int countKeyWord(String keyWord) {
        KeyWordCounter handler = new KeyWordCounter(this);
        PredicatekeyWordMatch matchOne = new PredicatekeyWordMatch(keyWord);
        ScriptScanner scanner = new ScriptScanner(matchOne, handler);
        scanner.scan(this.scriptValue);
        return handler.getNumber();
    }

    public boolean hasKeyWord() {
        AnyKeyWordPredicate anykeyWordPredicate = new AnyKeyWordPredicate();
        HasScriptIndicator hasScriptInidicator = new HasScriptIndicator(this);
        ScriptScanner scanner = new ScriptScanner(anykeyWordPredicate, hasScriptInidicator);
        scanner.scan(this.scriptValue);
        return hasScriptInidicator.found();
    }

    public List<String> getKeyWordsValues(String keyWord) {
        KeyWordLineCollector collector = new KeyWordLineCollector(this);
        PredicatekeyWordMatch matchOne = new PredicatekeyWordMatch(keyWord);
        ScriptScanner scanner = new ScriptScanner(matchOne, collector);
        scanner.scan(this.scriptValue);
        return collector.toList();
    }

    public List<String> getKeyWordsKeys() {
        KeyWordCollector collector = new KeyWordCollector();
        AnyKeyWordPredicate anykeyWordPredicate = new AnyKeyWordPredicate();
        ScriptScanner scanner = new ScriptScanner(anykeyWordPredicate, collector);
        scanner.scan(this.scriptValue);
        return collector.toList();
    }

    private final class KeyWordCounter
    implements KeyWordHandler {
        int counter = 0;

        private KeyWordCounter(ScriptParser scriptParser) {
        }

        @Override
        public void handleKeyword(String internalKeyWord) {
            ++this.counter;
        }

        public int getNumber() {
            return this.counter;
        }
    }

    private final class HasScriptIndicator
    implements KeyWordHandler {
        private boolean matchedOnce = false;

        private HasScriptIndicator(ScriptParser scriptParser) {
        }

        @Override
        public void handleKeyword(String keyWrod) {
            this.matchedOnce = true;
        }

        public boolean found() {
            return this.matchedOnce;
        }
    }

    public class KeyWordLineCollector
    implements KeyWordHandler {
        private List<String> keyWordsLine = new ArrayList<String>();

        public KeyWordLineCollector(ScriptParser this$0) {
        }

        @Override
        public void handleKeyword(String keyWrod) {
            this.keyWordsLine.add(keyWrod);
        }

        public List<String> toList() {
            return this.keyWordsLine;
        }
    }
}

