/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research.group_key_words;

import com.bmc.ctmconvert.uc4.research.KeyWordPattern;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelScriptsPatternsWriter
implements BiConsumer<KeyWordPattern, List<ScriptDetails>> {
    private static final int PATTERN_INDEX = 0;
    private static final int SCRIPT_INDEX = 1;
    private final Workbook excelWorkBook;
    private final Sheet sheet;
    private int rowNumber = 1;

    public ExcelScriptsPatternsWriter() {
        String[] header = new String[]{"pattern", "script"};
        String sheetName = "script's patterns";
        this.excelWorkBook = new XSSFWorkbook();
        this.sheet = this.excelWorkBook.createSheet(sheetName);
        this.setColumnWidth();
        CellStyle style = this.excelWorkBook.createCellStyle();
        Font font = this.excelWorkBook.createFont();
        font.setBold(true);
        style.setFont(font);
        style.setWrapText(true);
        HorizontalAlignment align = HorizontalAlignment.CENTER;
        style.setAlignment(align);
        Row row = this.sheet.createRow(0);
        this.sheet.createFreezePane(0, 1);
        for (int i = 0; i < header.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(header[i]);
            cell.setCellStyle(style);
        }
    }

    @Override
    public void accept(KeyWordPattern pattern, List<ScriptDetails> scripts) {
        for (ScriptDetails script : scripts) {
            Row row = this.sheet.createRow(this.rowNumber);
            CellCreator cellCreator = new CellCreator(row);
            cellCreator.setPattern(pattern.getKeyWords());
            cellCreator.setScript(script.script());
            ++this.rowNumber;
        }
    }

    private void setColumnWidth() {
        this.sheet.setColumnWidth(0, 4000);
        this.sheet.setColumnWidth(1, 17000);
        this.sheet.setColumnWidth(2, 5500);
    }

    public Workbook getExcelWorkBook() {
        return this.excelWorkBook;
    }

    public void write(OutputStream excelFileOutPut) throws IOException {
        this.excelWorkBook.write(excelFileOutPut);
    }

    public static class CellCreator {
        private final Row row;

        public CellCreator(Row row) {
            this.row = row;
        }

        public void setScript(String script) {
            Cell cell = this.row.createCell(1);
            cell.setCellValue(script);
        }

        public void setPattern(List<String> list) {
            Cell cell = this.row.createCell(0);
            String Keywordlist = list.toString();
            cell.setCellValue(Keywordlist.substring(1, Keywordlist.length() - 1));
        }
    }
}

