/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research.analyzTools;

import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.research.ScriptreaderHandler;
import com.bmc.ctmconvert.uc4.research.analyzTools.KeyWordInfo;
import com.bmc.ctmconvert.uc4.research.analyzTools.KeyWordMap;
import com.bmc.ctmconvert.uc4.research.handlers.ScriptParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SingleScriptKeyFinder
implements ScriptreaderHandler {
    private int numberOfScripts;
    private int total;
    private final Map<Integer, KeyWordMap> keyWordMaps = new HashMap<Integer, KeyWordMap>();
    private final KeyWordMap totalMap;

    public SingleScriptKeyFinder(Integer interval) {
        for (int i = 1; i <= interval; ++i) {
            this.keyWordMaps.put(i, new FriendsKeyWordMap());
        }
        this.totalMap = new KeyWordMap();
    }

    @Override
    public void handleScript(ScriptDetails script) {
        ScriptParser parser = new ScriptParser(script.script());
        boolean hasScriptKeyWord = parser.hasKeyWord();
        ++this.total;
        if (hasScriptKeyWord) {
            ++this.numberOfScripts;
            List<String> keyWordSInScripts = parser.getKeyWordsKeys();
            int numberOfOcurences = keyWordSInScripts.size();
            if (this.keyWordMaps.containsKey(numberOfOcurences)) {
                KeyWordMap map = this.keyWordMaps.get(numberOfOcurences);
                map.put(keyWordSInScripts);
            }
            this.totalMap.put(keyWordSInScripts);
        }
    }

    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer occurence : this.keyWordMaps.keySet()) {
            stringBuilder.append("occurence").append(occurence).append("\n");
            KeyWordMap map = this.keyWordMaps.get(occurence);
            stringBuilder.append(map.getResult());
            stringBuilder.append("***\n");
        }
        stringBuilder.append("\n toatal keyWords: \n");
        stringBuilder.append(this.totalMap.getResult());
        stringBuilder.append("\n");
        stringBuilder.append(", total Script: ");
        stringBuilder.append(this.total);
        return stringBuilder.toString();
    }

    public static Map<String, KeyWordInfo> sortByValue(Map<String, KeyWordInfo> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static class FriendsKeyWordMap
    extends KeyWordMap {
        @Override
        public void put(List<String> keyWordSInScripts) {
            super.put(keyWordSInScripts);
            for (String keyWord : keyWordSInScripts) {
                KeyWordInfo keyWordInfoo = (KeyWordInfo)this.keyWordMap.get(keyWord);
                ArrayList<String> friendsList = new ArrayList<String>(keyWordSInScripts);
                friendsList.remove(keyWord);
                keyWordInfoo.addFriends(friendsList);
            }
        }
    }
}

