/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research;

import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.research.ScriptreaderHandler;
import com.bmc.ctmconvert.uc4.research.analyzTools.KeyWordMap;
import com.bmc.ctmconvert.uc4.research.handlers.ScriptParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SingleScriptKeyFinder
implements ScriptreaderHandler {
    private int total;
    private final Map<Integer, KeyWordMap> keyWordMaps = new HashMap<Integer, KeyWordMap>();
    private int totalExistScriptContent;

    public SingleScriptKeyFinder(Integer interval) {
        for (int i = 1; i <= interval; ++i) {
            this.keyWordMaps.put(i, new KeyWordMap());
        }
    }

    @Override
    public void handleScript(ScriptDetails script) {
        List<String> keyWordSInScripts;
        int numberOfOccurrences;
        if (!script.script().isEmpty()) {
            ++this.totalExistScriptContent;
        }
        ScriptParser parser = new ScriptParser(script.script());
        boolean hasScriptKeyWord = parser.hasKeyWord();
        ++this.total;
        if (hasScriptKeyWord && this.keyWordMaps.containsKey(numberOfOccurrences = (keyWordSInScripts = parser.getKeyWordsKeys()).size())) {
            KeyWordMap map = this.keyWordMaps.get(numberOfOccurrences);
            map.put(keyWordSInScripts);
        }
    }

    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer occurence : this.keyWordMaps.keySet()) {
            stringBuilder.append("occurence").append(occurence).append("\n");
            KeyWordMap map = this.keyWordMaps.get(occurence);
            stringBuilder.append(map.getResult());
            stringBuilder.append("\n");
        }
        stringBuilder.append(", total jobs: ");
        stringBuilder.append(this.total);
        stringBuilder.append("\n, total Script with content: ");
        stringBuilder.append(this.totalExistScriptContent).append("\n");
        return stringBuilder.toString();
    }
}

