/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.research.ScriptreaderHandler;
import com.bmc.ctmconvert.uc4.xmlJobs.TagPredicate;
import com.bmc.ctmconvert.uc4.xmlJobs.UC4XmlReader;
import com.bmc.ctmconvert.uc4.xmlJobs.XmlElementHandler;
import java.io.InputStream;
import java.util.List;
import java.util.function.Predicate;

public class ScriptreaderAnalyze {
    private final ScriptreaderHandler scriptContainserHandler;

    public ScriptreaderAnalyze(ScriptreaderHandler allHandlersContainer) {
        this.scriptContainserHandler = allHandlersContainer;
    }

    public void read(InputStream input) {
        TagPredicate jobIPredicate = new TagPredicate("JOBI");
        TagPredicate jobSPredicate = new TagPredicate("JOBS_");
        Predicate<String> multiPredcate = t -> jobIPredicate.test((String)t) || jobSPredicate.test((String)t);
        UC4XmlReader reader = new UC4XmlReader(multiPredcate);
        ScriptReader scriptHanlder = new ScriptReader(this.scriptContainserHandler);
        reader.addHandler(scriptHanlder);
        reader.read(input);
    }

    public static class ScriptReader
    implements XmlElementHandler {
        private static final String MSCRI = "MSCRI";
        private final ScriptreaderHandler scriptHandler;

        public ScriptReader(ScriptreaderHandler scriptHandler) {
            this.scriptHandler = scriptHandler;
        }

        @Override
        public void handleElement(XmlElement jobsElement) {
            String tag = jobsElement.getTagName();
            if (tag.equals("JOBS_MVS")) {
                return;
            }
            String name = jobsElement.getAttribute("name");
            List scripts = jobsElement.getAllDecnedElementByName(MSCRI);
            for (XmlElement script : scripts) {
                String scriptValue = script.getCData();
                ScriptDetails scriptDetails = ScriptDetails.of(name, tag, scriptValue);
                this.scriptHandler.handleScript(scriptDetails);
            }
        }
    }
}

