/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research;

import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.research.ScriptreaderHandler;
import com.bmc.ctmconvert.uc4.research.analyzTools.KeyWordMap;
import com.bmc.ctmconvert.uc4.research.handlers.ScriptParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IncWithUc4KeywordsFinder
implements ScriptreaderHandler {
    private final KeyWordMap incMapNoKeyWords;
    private final KeyWordMap incMapWithKeyWords;
    private int totalScripts;
    private int toalInc;
    private int toalIncWithUc4Keyword;
    private final Map<String, Boolean> incHasUc4Keywords;

    public IncWithUc4KeywordsFinder(Map<String, Boolean> incHasUc4Keywords) {
        this.incHasUc4Keywords = incHasUc4Keywords;
        this.incMapNoKeyWords = new KeyWordMap();
        this.incMapWithKeyWords = new KeyWordMap();
    }

    @Override
    public void handleScript(ScriptDetails script) {
        ScriptParser parser;
        boolean hasInc;
        if (!script.script().isEmpty()) {
            ++this.totalScripts;
        }
        if (hasInc = (parser = new ScriptParser(script.script())).hasKeyWord("INC")) {
            ++this.toalInc;
            List<String> incValues = parser.getKeyWordsValues("INC");
            for (String incValue : incValues) {
                KeyWordMap incMap = this.incMapNoKeyWords;
                String[] incValueSplit = incValue.split(" ");
                String incName = incValueSplit[incValueSplit.length - 1];
                if (this.incHasUc4Keywords.containsKey(incName) && this.incHasUc4Keywords.get(incName).booleanValue()) {
                    ++this.toalIncWithUc4Keyword;
                    incMap = this.incMapWithKeyWords;
                }
                ArrayList<String> tempIncList = new ArrayList<String>();
                tempIncList.add(incValue);
                incMap.put(tempIncList);
            }
        }
    }

    public String getResults() {
        return "Scripts distribution with no UC4 Keywords:\n" + this.incMapNoKeyWords.getResult() + "\n\nScripts distribution with UC4 Keywords:\n" + this.incMapWithKeyWords.getResult() + "\n\n total scripts " + this.totalScripts + "\n total scripts contain INC " + this.toalInc + "\n total scripts contain INC with UC4 Keyword " + this.toalIncWithUc4Keyword;
    }
}

