/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.jobTypes;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MvsFileName {
    private final String mvsFilePattern = "(.*?)\\((.*)\\)";

    public Optional<String> getFileName(String fileName) {
        RegexHandler handler = new RegexHandler(this, fileName);
        Optional<String> ret = Optional.empty();
        if (handler.hasFile()) {
            ret = Optional.of(handler.getFile());
        }
        return ret;
    }

    public Optional<String> getLibrary(String fileName) {
        RegexHandler handler = new RegexHandler(this, fileName);
        Optional<String> ret = Optional.empty();
        if (handler.hasLibrary()) {
            ret = Optional.of(handler.getLibrary());
        }
        return ret;
    }

    public String removeQuotes(String str) {
        if (str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public class RegexHandler {
        private String library = null;
        private String file = null;

        public RegexHandler(MvsFileName this$0, String fileName) {
            fileName = this$0.removeQuotes(fileName);
            Pattern r = Pattern.compile("(.*?)\\((.*)\\)");
            Matcher m = r.matcher(fileName);
            if (m.find()) {
                this.library = m.group(1);
                this.file = m.group(2);
            }
        }

        public boolean hasLibrary() {
            return this.library != null;
        }

        public boolean hasFile() {
            return this.file != null;
        }

        public String getLibrary() {
            return this.library;
        }

        public String getFile() {
            return this.file;
        }
    }
}

